<?php
/*
 * member/mail/template/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール テンプレート作成 実行用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @subpackage template テンプレートパッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_template_Execute extends system_login_ModuleBase {
	function member_mail_template_Execute(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo					= $request->getAttribute( 'dbo' );
		$templateNumber				= $request->getParam('tpln','get');
		$sessionObjectName	= 'member.mail.template.modify.object.'.$templateNumber;
		$sessionConfirmName	= 'member.mail.template.modify.confirm.'.$templateNumber;
		$compareTemplateObject= spider_Controller::createObject('member_DaoMemberMailTemplate');
		$mailTemplateObject		= $request->getSession($sessionObjectName);
		$confirm_result				= $request->getSession($sessionConfirmName);
		$loginUserObject			= $this->getLoginUserObject( $request );

		if( 'OK' != $confirm_result ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( get_class($mailTemplateObject) != get_class($compareTemplateObject) ){
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( !$request->isError() ) {
			if( strlen(trim($mailTemplateObject->template_number)) > 0 ) {
				// IDが設定済みなら更新
				if( $loginUserObject->getUniqueId() != 'SYSADMIN'
					&& $mailTemplateObject->open_flag != 0
					&& $mailTemplateObject->owner_id != $loginUserObject->getUniqueId() ) {
					// 公開フラグが共有になっていない場合は所有者でなければエラー
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else if( $this->lockData( $request, $mailTemplateObject ) ) {
					// そうでないなら更新
					$mailTemplateObject->modifier_id	= $loginUserObject->getUniqueId();
					$mailTemplateObject->updated_date	= date('Y-m-d H:i:s');
					if( $dbo->update( $mailTemplateObject,true) ) {
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
					// エラー有無に関わらずロックを解除
					$this->unlockData( $request, $mailTemplateObject );
				} else {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				// 番号がないなら新規挿入
				$mailTemplateObject->owner_id			= $loginUserObject->getUniqueId();
				$mailTemplateObject->modifier_id		= $loginUserObject->getUniqueId();
				$mailTemplateObject->updated_date		= date('Y-m-d H:i:s');
				$mailTemplateObject->registered_date	= date('Y-m-d H:i:s');
				if( strlen($mailTemplateObject->template_id) == 0 ){
					if( !$dbo->setNextId($mailTemplateObject,'MMTP{num:4}') ){
						$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
				if( !$request->isError() ){
					if( $dbo->insert($mailTemplateObject) ){
					} else {
						$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			}
		}
		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('member.mail.template.mail_template_object',$mailTemplateObject);

	}
}
?>