<?php
/*
 * member/mail/reject/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール 配信メールマガジン種別一覧取得用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @subpackage reject メールマガジン種別パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_reject_LoadList extends system_login_ModuleBase {
	function member_mail_reject_LoadList() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo		= $request->getAttribute( 'dbo' );
		$query_word		= trim( stripslashes( $_GET['mmrq'] ) );
		$status_flag	= trim( stripslashes( $_GET['mmrstf'] ) );
		$page_number	= trim( stripslashes( $_GET['mmrpn'] ) );
		$page_rows		= trim( stripslashes( $_GET['mmrpr'] ) );
		$sort_item		= trim( stripslashes( $_GET['mmrsi'] ) );
		$sort_order		= trim( stripslashes( $_GET['mmrso'] ) );
		if ( !is_numeric( $page_rows ) || $page_rows < 0 ) {
			$page_rows		= 20;
		} else if ( $page_rows > 100 ) {
			$page_rows		= 20;
		}
		if( 'desc' != $sort_order ) {
			$sort_order	= 'asc';
		}
		$order_condition	= '';
		if( 'id' == $sort_item ) {
			$order_condition	= " ORDER BY list_id ".$sort_order;
		} else if ( 'aname' == $sort_item ) {
			$order_condition	= " ORDER BY list_name ".$sort_order;
		} else {
			$sort_item			= 'reg';
			$order_condition	= " ORDER BY registered_date ".$sort_order;
		}
				
		$condition_string	= "";
		$condition_array	= array();
		if ( strlen( $query_word ) > 0 ) {
			$str	= "( list_id LIKE " . $dbo->quote( '%'.$query_word.'%' )
				. " OR "
				. "list_name LIKE " . $dbo->quote( '%'.$query_word.'%' )
				. " OR "
				. "description LIKE " . $dbo->quote( '%'.$query_word.'%' )
				. " )"
			;
			array_push( $condition_array, $str );
		}
		if ( strlen( $status_flag ) > 0 ) {
			$str	= "status_flag=" . $dbo->quote( $status_flag );
			array_push( $condition_array, $str );
		} else {
			$str	= "status_flag<200";
			array_push( $condition_array, $str );
		}
		if ( count( $condition_array ) > 0 ) {
			$condition_string	= " WHERE " . implode( " AND ", $condition_array );
		}

		// 条件にマッチする件数の取得
		$sql	= "SELECT count(*) FROM ".TABLE_NAME_MEMBER_MAIL_REJECT
			. $condition_string
		;
		$total_count	= $dbo->queryOne( $sql );
		if ( $total_count === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			if ( is_numeric( $total_count ) || $total_count < 0 ) {
				$total_page		= ceil( $total_count / $page_rows );
			} else {
				$total_count	= 0;
				$total_page		= 1;
			}
		}
		// オフセットの整理
		if ( !is_numeric( $page_number ) || $page_number <= 0 ) {
			$page_number	= 1;
		} else if ( $page_number > $total_page	 ) {
			$page_number	= $total_page;
		}

		// ページ分のデータを取得
		$rejectListObjectArray	= array();
		$sql	= "SELECT * FROM ".TABLE_NAME_MEMBER_MAIL_REJECT
			. $condition_string
			. $order_condition
		;
		$dbo->setLimit( $page_rows, ( $page_number - 1 ) * $page_rows );
		$rejectListObject	= spider_Controller::createObject('member_DaoMemberMailReject');
		$result	= $dbo->queryAll( $sql, $rejectListObject );
		if ( $result === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			foreach( $result as $rejectListObject ) {
				// ロック状態の確認
				$this->setLockStatus( $request, $rejectListObject );
				array_push( $rejectListObjectArray, $rejectListObject );
			}
		}
		$request->setAttribute( 'member.mail.reject.data_array', $rejectListObjectArray );
		$request->setAttribute( 'member.mail.reject.total_count', $total_count );
		$request->setAttribute( 'member.mail.reject.total_page', $total_page );
		$request->setAttribute( 'member.mail.reject.page_number', $page_number );
		$request->setAttribute( 'member.mail.reject.page_rows', $page_rows );
		$request->setAttribute( 'member.mail.reject.query', $query_word );
		$request->setAttribute( 'member.mail.reject.sort_item', $sort_item );
		$request->setAttribute( 'member.mail.reject.sort_order', $sort_order );
		
		$has_next_page	= false;
		if( $page_number < $total_page ) {
			$has_next_page	= true;
		}
		$request->setAttribute( 'member.mail.reject.has_next_page', $has_next_page );
		$next_page_number	= $page_number + 1;
		$request->setAttribute( 'member.mail.reject.next_page_number', $next_page_number );
		$has_prev_page	= false;
		if( $page_number > 1 ) {
			$has_prev_page	= true;
		}
		$request->setAttribute( 'member.mail.reject.has_prev_page', $has_prev_page );
		$prev_page_number	= $page_number - 1;
		$request->setAttribute( 'member.mail.reject.prev_page_number', $prev_page_number );
		
	}
}
?>