<?php
/*
 * member/mail/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール 配信確認用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_Confirm extends system_login_ModuleBase {
	function member_mail_Confirm(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo					= $request->getAttribute( 'dbo' );
		$member_id				= $_GET['mi'];
		$select_type			= trim(stripslashes( $_GET['stype'] ));
		if( 'q' != $select_type && 's' != $select_type ) {
			$select_type		= 'm';
		}
		$session_sufix			= '_'.$select_type.'_';
		if(is_array($member_id)) {
			$session_sufix		.= implode('.',$member_id);
		} else {
			$session_sufix		.= trim($member_id);
		}
		$sessionObjectName	= MEMBER_SESSION_NAME_MAIL_OBJECT.$session_sufix;
		$sessionConfirmName	= MEMBER_SESSION_NAME_SENDMAIL_CONFIRM_RESULT.$session_sufix;

		$mailObject						= spider_Controller::createObject('member_DaoMemberMail');
		$mailObject->target_type			= stripslashes( $_POST['target_type'] );
		$mailObject->template_id			= stripslashes( $_POST['template_id'] );
		$mailObject->mail_type				= stripslashes( $_POST['mail_type'] );
		$mailObject->bgcolor				= stripslashes( $_POST['bgcolor'] );
		$mailObject->subject				= stripslashes( $_POST['subject'] );
		$mailObject->body					= stripslashes( $_POST['body'] );
		$mailObject->select_type			= trim($select_type);
		$mailObject->list_id				= stripslashes( $_POST['list_id'] );
		$mailObject->reserve_date_year		= stripslashes( $_POST['reserve_date_year'] );
		$mailObject->reserve_date_month	= stripslashes( $_POST['reserve_date_month'] );
		$mailObject->reserve_date_day		= stripslashes( $_POST['reserve_date_day'] );
		$mailObject->reserve_date_hour		= stripslashes( $_POST['reserve_date_hour'] );
		$mailObject->reserve_date_min		= stripslashes( $_POST['reserve_date_min'] );
		$mailObject->mail_from_name		= trim(stripslashes($_POST['mail_from_name']));
		$mailObject->mail_from_address		= trim(stripslashes($_POST['mail_from_address']));
		$mailObject->mail_reply_address	= trim(stripslashes($_POST['mail_reply_address']));
		$mailObject->mail_return_path		= trim(stripslashes($_POST['mail_return_path']));
		// 対応履歴追記
		$mailObject->add_correspond		= trim(stripslashes($_POST['add_correspond']));
		$mailObject->correspond_status		= trim(stripslashes($_POST['correspond_status']));
		$mailObject->correspond_type		= trim(stripslashes($_POST['correspond_type']));
		$mailObject->correspond_category	= trim(stripslashes($_POST['correspond_category']));
		if( preg_match('/^[tT](|[rR][uU][eE])|[yY](|[eE][sS])$/',$mailObject->add_correspond) > 0 ) {
			$mailObject->add_correspond	= true;
		} else {
			$mailObject->add_correspond		= false;
			$mailObject->correspond_status		= null;
			$mailObject->correspond_type		= null;
			$mailObject->correspond_category	= null;
		}
		// 送信用パラメータ
		$sendParamArray	= $request->getParam('send_params','post','array');
		if( !is_array($sendParamArray) && strlen(trim($_POST['send_params']))>0 ) {
			$sendParamArray	= array(trim($_POST['send_params']));
		}
		$mailObject->send_params			= implode('&',$sendParamArray);;
		
		if( strlen(trim($mailObject->subject)) == 0 ) {
			$request->addLocaledError('member.error.mail.requiresubject',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( strlen(trim($mailObject->subject)) > 180 ) {
			$request->addLocaledError('member.error.mail.invalidsubject',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen(trim($mailObject->body)) == 0 ) {
			$request->addLocaledError('member.error.mail.requirebody',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( strlen(trim($mailObject->body)) > 30000 ) {
			$request->addLocaledError('member.error.mail.invalidbody',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen(trim($mailObject->target_type)) == 0 ) {
			$request->addLocaledError('member.error.mail.requiretarget',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( 'p' != $mailObject->target_type && 'm' != $mailObject->target_type ) {
			$request->addLocaledError('member.error.mail.invalidtarget',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen(trim($mailObject->mail_type)) == 0 ) {
			$request->addLocaledError('member.error.mail.requiretype',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( 'p' != $mailObject->mail_type && 'h' != $mailObject->mail_type ) {
			$request->addLocaledError('member.error.mail.invalidtype',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen(trim($mailObject->bgcolor)) == 0 ) {
		} else if( strlen(trim($mailObject->bgcolor)) > 8 ) {
			$request->addLocaledError('member.error.mail.invalidbgcolor',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( preg_match('/^(#|)[0-9a-fA-F]{6}$/',$mailObject->bgcolor) == 0 ) {
			$request->addLocaledError('member.error.mail.invalidbgcolor',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen(trim($mailObject->list_id)) > 0 ) {
			$reject_list_object	= spider_Controller::createObject('member_DaoMemberMailReject');
			if( !$dbo->loadById( $reject_list_object, $mailObject->list_id ) ) {
				$request->addLocaledError('member.error.dao.magazine.invalidmagazinetype',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		if( !preg_match('/^[2][0][0-9][0-9]$/', $mailObject->reserve_date_year ) ) {
			$request->addLocaledError('member.error.mail.invalidyear',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( !preg_match('/^[0-9][0-9]$/', $mailObject->reserve_date_month ) ) {
			$request->addLocaledError('member.error.mail.invalidmonth',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( !preg_match('/^[0-9][0-9]$/', $mailObject->reserve_date_day ) ) {
			$request->addLocaledError('member.error.mail.invalidday',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( !preg_match('/^[0-9][0-9]$/', $mailObject->reserve_date_hour ) ) {
			$request->addLocaledError('member.error.mail.invalidhour',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( !preg_match('/^[0-9][0-9]$/', $mailObject->reserve_date_min ) ) {
			$request->addLocaledError('member.error.mail.invalidmin',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		$mailObject->reserve_date	= $mailObject->reserve_date_year . "-" . $mailObject->reserve_date_month
			. "-" . $mailObject->reserve_date_day . " " . $mailObject->reserve_date_hour . ":" . $mailObject->reserve_date_min;
		$delivary_time	= strtotime( $mailObject->reserve_date );
		if( strlen($mailObject->mail_from_name) == 0 ) {
			$request->addLocaledError('member.error.mail.requirefromname',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( strlen($mailObject->mail_from_name) > 90 ) {
			$request->addLocaledError('member.error.mail.invalidfromname',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen($mailObject->mail_from_address) == 0 ) {
			$request->addLocaledError('member.error.mail.requirefrom',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( strlen($mailObject->mail_from_address) > 80 ) {
			$request->addLocaledError('member.error.mail.invalidfrom',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if ( preg_match('/^([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9\._-]+)+$/',$mailObject->mail_from_address) == 0 ) {
			$request->addLocaledError('member.error.mail.invalidfrom',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen($mailObject->mail_reply_address) == 0 ) {
			$mailObject->mail_reply_address	= $mailObject->mail_from_address;
		} else if( strlen($mailObject->mail_reply_address) > 80 ) {
			$request->addLocaledError('member.error.mail.invalidreply',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if ( preg_match('/^([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9\._-]+)+$/',$mailObject->mail_reply_address) == 0 ) {
			$request->addLocaledError('member.error.mail.invalidreply',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen($mailObject->mail_return_path) == 0 | $mailObject->mail_return_path == 'system_auto' ) {
			$mailObject->mail_return_path	= 'system_auto';
		} else if( strlen($mailObject->mail_return_path) > 80 ) {
			$request->addLocaledError('member.error.mail.invalidreturn',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if ( preg_match('/^([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9\._-]+)+$/',$mailObject->mail_return_path) == 0 ) {
			$request->addLocaledError('member.error.mail.invalidreturn',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		// パッケージコネクタの確認処理をおこなう
		if( is_array($GLOBALS['member.existsConnectorHash'] ) ) {
			foreach( $GLOBALS['member.existsConnectorHash'] as $packageId => $connectorObject ) {
				$connectorObject->mailConfirm( $request, $mailObject );
			}
		}
		
		// 選択タイプごとの確認
		if( 'q' == $mailObject->select_type ) {
			// 検索クエリの場合
			$count_sql	= $request->getSession(MEMBER_SESSION_NAME_LOADCOUNT_QUERY);
			$list_sql	= $request->getSession(MEMBER_SESSION_NAME_LOADLIST_QUERY);
			if( strlen($count_sql) == 0 || strlen($list_sql) == 0 ) {
				$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else {
				$mailObject->select_condition	= $count_sql . " ; " . $list_sql;
			}
		} else if( 's' == $mailObject->select_type ) {
			// セッション選択リストの場合
			$session_selected_array	= $request->getSession(MEMBER_SESSION_NAME_SELECTED_LIST);
			if( !is_array($session_selected_array) || count( $session_selected_array ) == 0 ) {
				$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
			} else if ( count( $session_selected_array ) > 1000 ) {
				$request->addLocaledError('member.error.mail.maxatonce',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else {
				// 選択リストからSQL文を作成する
				$member_id_array	= array();
				foreach( $session_selected_array as $member_id=>$member_name ) {
					array_push( $member_id_array, $member_id );
					// 表示のために選択メンバーIDとオブジェクトのハッシュを作成
					$member_object			= spider_Controller::createObject('member_DaoMember');
					if( strlen(trim($member_id)) > 0 ) {
						// IDが指定されているなら編集のため読み込み
						if( $dbo->loadById( $member_object, $member_id ) ){
						} else {
							$member_object->view_name	= "存在しないか削除済み";
						}
						$mailObject->member_id_object_hash[$member_id]	= $member_object;
					}
				}
				$query_condition	= " WHERE member_id IN ('" . implode( "','", $member_id_array ) . "')";
				$count_sql	= "SELECT COUNT(DISTINCT(member_id)) FROM " . TABLE_NAME_MEMBER . $query_condition;
				$list_sql	= "SELECT DISTINCT(member_id) FROM " . TABLE_NAME_MEMBER . $query_condition;
				$mailObject->select_condition	= $count_sql . " ; " . $list_sql;
			}
		} else {
			// IDポストの場合
			$mailObject->select_type	= 'm';
			$member_id_array	= array();
			if( is_array( $member_id ) ) {
				if( count( $member_id ) == 0 ) {
					$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
				} else {
					$member_id_array	= $member_id;
				}
			} else if( strlen(trim($member_id)) > 0 ) {
				array_push( $member_id_array, $member_id );
			} else {
				$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
			}
			if( !$request->isError() ) {
				foreach( $member_id_array as $member_id ) {
					// 表示のために選択メンバーIDとオブジェクトのハッシュを作成
					$member_object			= spider_Controller::createObject('member_DaoMember');
					if( $dbo->loadById( $member_object, $member_id ) ){
					} else {
						$member_object->view_name	= "存在しないか削除済み";
					}
					$mailObject->member_id_object_hash[$member_id]	= $member_object;
				}
				$query_condition	= " WHERE member_id IN ('" . implode( "','", $member_id_array ) . "')";
				$count_sql	= "SELECT COUNT(DISTINCT(member_id)) FROM " . TABLE_NAME_MEMBER . $query_condition;
				$list_sql	= "SELECT DISTINCT(member_id) FROM " . TABLE_NAME_MEMBER . $query_condition;
				$mailObject->select_condition	= $count_sql . " ; " . $list_sql;
			}
		}

		if( !$request->isError() ) {
			$resultString	= 'OK';
			$request->setSession($sessionConfirmName,$resultString);
		} else {
			$request->removeSession($sessionConfirmName);
		}
		$request->setSession($sessionObjectName,$mailObject);

		$request->setAttribute('member.mail.mail_object',$mailObject );

	}
}
?>