<?php
/*
 * member/history/Login.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : ログイン会員履歴表示用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage loginhistory ログイン履歴パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_history_Login extends system_login_ModuleBase {
	function member_history_Login() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {

		$dbo			= $request->getAttribute( 'dbo' );
		$memberId		= trim( stripslashes( $_GET['mi'] ) );
		$targetYear		= trim( stripslashes( $_GET['mlty'] ) );
		$targetMonth	= trim( stripslashes( $_GET['mltm'] ) );

		if( strlen(trim($memberId)) == 0 ) {
			$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
			return;
		} else {
			$memberObject	= spider_Controller::createObject('member_DaoMember');
			if( $dbo->loadById( $memberObject, $memberId, true ) ) {
				$request->setAttribute( 'member.history.login.memberObject', $memberObject );
			} else {
				$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
			}
		}
		
		if( preg_match('/^[0-9]{4}$/',$targetYear) == 0 || $targetYear < 1970 || $targetYear > date('Y') ) {
			$targetYear	= date('Y');
		}
		if( preg_match('/^[0-9]{1,2}$/',$targetMonth) == 0 || $targetMonth < 1 || $targetMonth > 12 ) {
			$targetMonth	= date('m');
		}
				
		$condition_string	= '';
		$condition_array	= array();
		// 対象会員ID
		$str	= 'member_id='.$dbo->quote($memberId);
		array_push( $condition_array, $str );
		// 開始日
		$startDate	= $targetYear.'-'.$targetMonth.'-01 00:00:00';
		$str	= 'login_date>='.$dbo->quote($targetYear.'-'.$targetMonth.'-01 00:00:00');
		array_push( $condition_array, $str );
		// 終了日
		$endYear	= $targetYear;
		$endMonth	= $targetMonth	+ 1;
		if( $endMonth > 12 ) {
			$endMonth	= '01';
			$endYear++;
		}
		$str	= 'login_date<'.$dbo->quote($endYear.'-'.$endMonth.'-01 00:00:00');
		array_push( $condition_array, $str );
		if ( count( $condition_array ) > 0 ) {
			$condition_string	= ' WHERE '.implode( ' AND ', $condition_array );
		}

		$sql	= 'SELECT * FROM '.TABLE_NAME_MEMBER_LOGIN_HISTORY.$condition_string.' ORDER BY login_date ASC';
		$loginHistoryObject	= spider_Controller::createObject('member_DaoMemberLoginHistory');
		$loginHistoryArray	= $dbo->queryAll( $sql, $loginHistoryObject );
		if ( false === $loginHistoryArray ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
		}
		$request->setAttribute( 'member.history.login.data_array', $loginHistoryArray );
		$request->setAttribute( 'member.history.login.member_id', $memberId );
		$request->setAttribute( 'member.history.login.targetYear', $targetYear );
		$request->setAttribute( 'member.history.login.targetMonth', $targetMonth );
	}
}
?>