-------------------------------------------------
-- file package sql
-- CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
-- URL: http://sourceforge.jp/projects/shopformer/
-- 
-- 
-- Mail: m_nakashima@users.sourceforge.jp
-- Auther: Masanori Nakashima
-- Last Update: 2010-06-23
-------------------------------------------------
-- file_bin
-- open_flag: 0=無制限, 0以外=パッケージ個別制御 
-- response_headers: ダウンロード時の追加レスポンスヘッダ
-------------------------------------------------
CREATE TABLE file_bin (
	file_number BIGINT UNSIGNED NOT NULL AUTO_INCREMENT
	,file_id VARCHAR(24) NOT NULL
	,file_name VARCHAR(255) NOT NULL
	,file_size BIGINT UNSIGNED NOT NULL DEFAULT 0
	,file_type SMALLINT NOT NULL DEFAULT 0
	,extension VARCHAR(8) NULL
	,mime_type VARCHAR(80) NULL
	,status_flag SMALLINT NOT NULL DEFAULT 1
	,related_table VARCHAR(32) NULL
	,related_field VARCHAR(32) NULL
	,open_flag SMALLINT NOT NULL DEFAULT 0
	,target_agent TEXT NULL
	,response_headers TEXT NULL
	,owner_id VARCHAR(16) NULL
	,modifier_id VARCHAR(16) NULL
	,updated_date TIMESTAMP NULL
	,registered_date TIMESTAMP NULL
	,CONSTRAINT file_bin_file_number PRIMARY KEY (file_number)
	,CONSTRAINT file_bin_file_id UNIQUE (file_id)
) ENGINE=InnoDB character set utf8;
CREATE INDEX idx_file_bin_status_flag ON file_bin( status_flag );
CREATE INDEX idx_file_bin_updated_date ON file_bin( updated_date );
CREATE INDEX idx_file_bin_registered_date ON file_bin( registered_date );
