<?php
/*
 * design/template/setting/Load.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'DaoTemplate.class.php');
class design_template_setting_Load extends system_login_ModuleBase {
	function design_template_setting_Load() {
	}
	function execute( & $request ) {
		$fileName			= strtolower(trim(stripslashes($_GET['fmt'])));
		if( strlen(trim($fileName)) == 0 ) {
			$request->addError('テンプレートファイル名を指定してください');
		}
		
		if( !$request->isError() ) {
			$templateObject	= new design_DaoTemplate($fileName);
			$variableObject	= new content_Variable($request);
			$templateObject->loadInfo( $request );
			$usedVariableKeys	= $templateObject->getRelatedVariableKeys( $request );
			foreach( $usedVariableKeys as $variableKey ) {
				$setup	= false;
				if( $variableObject->existsKey($variableKey) ) {
					// サイト変数にキーが存在する
					$setup	= true;
				}
				$label	= $templateObject->getLabel( $request, $variableKey );
				$templateObject->setLabel( $request, $variableKey, $label );
				$value	= $templateObject->getValue( $request, $variableKey);
				$templateObject->setValue( $request, $variableKey, $value );
				$templateObject->variableHash[$variableKey]				= $templateObject->variableObject->variableHash[$variableKey];
				$templateObject->variableHash[$variableKey]['note']	= $templateObject->getLabel( $request, $variableKey );
				$templateObject->variableHash[$variableKey]['setup']	= $setup;
			}
			$request->setAttribute('design.template.setting.templateObject',$templateObject );
		}
	}
}
?>