<?php
/*
 * design/template/Preview.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'util'
	.DIRECTORY_SEPARATOR.'File.class.php');
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'DaoTemplate.class.php');
class design_template_Preview extends system_login_ModuleBase {
	function design_template_Preview() {
	}
	function execute( & $request ) {
		$agentType			= strtolower(trim(stripslashes($_POST['agent'])));
		$fileName			= strtolower(trim(stripslashes($_POST['file_name'])));
		$bodyStrings		= $_POST['body_strings'];
		$bodyStrings		= mb_convert_kana($bodyStrings,'KV');
		if( strlen(trim($agentType)) == 0 ) {
			$agentType				= 'default';
		} else if( !array_key_exists( $agentType, $GLOBALS['SPIDER_USER_AGENT_CLASS_HASH'] ) ){
			$agentType				= 'default';
		}
		if( strlen(trim($fileName)) == 0 ) {
			$request->addError('テンプレートファイル名を指定してください');
			return;
		}
		
		// 変数置換
		$templateObject	= new design_DaoTemplate($fileName);
		$templateObject->loadInfo( $request );
		$bodyStrings	= $templateObject->getBodyVariableReplaced( $request, null, $bodyStrings );
		// 古い一時テンプレートを削除
		$oldFileArray	= array();
		foreach( $GLOBALS['SPIDER_USER_AGENT_CLASS_HASH'] as $aKey => $aName ) {
			$targetDir	= DIR_PATH_TEMPLATES.DIRECTORY_SEPARATOR.$aKey;
			if( is_dir( $targetDir ) ) {
				if( $dh = @opendir( $targetDir ) ) {
					while (($fname	= readdir($dh)) !== false) {
						if( preg_match('/^\\./',$fname) == 0
							&& preg_match('/^admin\\_/',$fname) == 0
							&& preg_match('/\\.tmp/',$fname) > 0
						) {
							$absolutePath	= $targetDir.DIRECTORY_SEPARATOR.$fname;
							if( !is_dir($absolutePath) && time() - filemtime($absolutePath) > 60 * 60 ) {
								$uri	= '/'.$aKey.'/'.$fname;
								array_push($oldFileArray,$uri);
							}
						}
					}
					closedir($dh);
				}
			}
		}
		foreach( $oldFileArray as $uri ) {
			system_DataFileWriter::delete( $request, $uri, DIR_NAME_TEMPLATES );
		}

		// 古いプレビューファイルを削除
		$oldFileArray	= array();
		$previewDir		= util_File::suri2path( '/upload/tmp/preview/' );
		if( is_dir( $previewDir ) ) {
			if( $dh = @opendir( $previewDir ) ) {
				while (($fname	= readdir($dh)) !== false) {
					if( preg_match('/^\\./',$fname) == 0 ) {
						$absolutePath	= $previewDir.DIRECTORY_SEPARATOR.$fname;
						if( !is_dir($absolutePath) ) {
							$uri	= '/upload/tmp/preview/'.$fname;
							array_push($oldFileArray,$uri);
						}
					}
				}
				closedir($dh);
			}
		}
		foreach( $oldFileArray as $uri ) {
			system_DataFileWriter::delete( $request, $uri, 'public' );
		}
		
		// テンプレートファイルを一時保存
		$tmpFileName	= $fileName.'.tmp';
		$tmpFileUri		= '/'.$agentType.'/'.$tmpFileName;
		$writer			= new system_DataFileWriter();
		if( $writer->open( $request, $tmpFileUri, 'w', DIR_NAME_TEMPLATES ) ) {
			$writer->write( $bodyStrings );
			$writer->close( $request );
		}
		
		
		// このテンプレートファイルを利用したページを一時作成
		$viewFileBody	= file_get_contents(dirname(__FILE__).DIRECTORY_SEPARATOR.'previewbody.txt');
		$viewFileBody	= str_replace('[TEMPLATE_TMP_NAME]',$tmpFileName,$viewFileBody);

		$viewFileUri	= '/upload/tmp/preview/'.$tmpFileName.'.php';
		$writer			= new system_DataFileWriter();
		if( $writer->open( $request, $viewFileUri, 'w', 'public' ) ) {
			$writer->write( $viewFileBody );
			$writer->close( $request );
		}
		$viewFileUri	= SPIDER_URI_BASE.preg_replace('/^\\//','',$viewFileUri);
		$request->setAttribute('design.template.previewUri',$viewFileUri );
	}
}
?>