<?php
/*
 * content/editor/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
class content_editor_Execute extends system_login_ModuleBase {
	function content_editor_Execute() {
	}
	function execute( & $request ) {
		
		$targetType		= strtolower(trim(stripslashes($_POST['target_type'])));
		$fileUri		= strtolower(trim(stripslashes($_POST['target_uri'])));
		$agentType		= strtolower(trim(stripslashes($_POST['agent_type'])));
		$targetBody		= stripslashes($_POST['target_body']);

		if( DIR_NAME_TEMPLATES != $targetType && DIR_NAME_PAGES != $targetType && DIR_NAME_WIDGETS != $targetType ) {
			$targetType	= 'public';
		}
		if( strlen($fileUri) < 1 ) {
			$request->addError('ファイルを指定してください');
		} else if( preg_match('/\\.[cC][sS][sS]$/',$fileUri) == 0
			&& preg_match('/\\.[jJ][sS]$/',$fileUri) == 0
			&& preg_match('/\\.[hH][tT][mM]([lL]|)$/',$fileUri) == 0
			&& preg_match('/\\.[tT][xX][tT]$/',$fileUri) == 0
			&& preg_match('/\\.[pP][hH][pP]$/',$fileUri) == 0
		) {
			$request->addError('指定のファイルはテキスト形式ではありません。');
		}
		if( !array_key_exists($agentType,$GLOBALS['SPIDER_USER_AGENT_CLASS_HASH']) ) {
			$agentType	= 'default';
		}
		
		$sessionName	= 'content.editor.body.'.$targetType.'.'.$agentType.'.'.str_replace('/','.',$fileUri);
		$confirmName	= 'content.editor.confirm.'.$targetType.'.'.$agentType.'.'.str_replace('/','.',$fileUri);
		$confirmResult	= $request->getSession($confirmName, SPIDER_SESSION_SCOPE_GLOBAL);
		$targetBody		= $request->getSession($sessionName, SPIDER_SESSION_SCOPE_GLOBAL);
		
		if( 'OK' != $confirmResult ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( !$request->isError() ) {
			// エラーがないなら種別に合わせて本文書き込み
			if( 'public' == $targetType ) {
				// 公開フォルダ内ファイルなら
				$writer			= new system_DataFileWriter();
				if( $writer->open( $request, $fileUri, 'w', 'public' ) ) {
					$writer->write( $targetBody );
					$writer->close( $request );
				}
			} else {
				// 公開フォルダ以外のファイルなら
				$writer			= new system_DataFileWriter();
				if( $writer->open( $request, '/'.$agentType.$fileUri, 'w', $targetType ) ) {
					$writer->write( $targetBody );
					$writer->close( $request );
				}
			}
			$request->setAttribute('content.file.edit.targetUri',$fileUri );
			$request->setAttribute('content.file.edit.targetType',$targetType );
			$request->setAttribute('content.file.edit.agentType',$agentType );
			$request->setAttribute('content.file.edit.targetBody',$targetBody );
		}
		$request->removeSession($sessionName, SPIDER_SESSION_SCOPE_GLOBAL);
		$request->removeSession($confirmName, SPIDER_SESSION_SCOPE_GLOBAL);
		
	}
}
?>