<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:system.login.Require}
{module:shopping.category.LoadList}
{module:shopping.promotion.LoadList}
{preset:page_title 'ショップ管理 > プロモーション一覧と検索'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">ショップ管理</a>
		&gt; プロモーション管理
	</div>
	<h1>ショップ管理 &gt; プロモーション一覧と検索</h1>

	{if:IS_ERROR}
		<ul class="error">
		{foreach:errors error}
			<li>{write:error}</li>
		{/foreach}
	</ul>
	{/if}

	<form name="sform" action="./index.php" method="get">
	<input type="hidden" name="pn" value="{write:shopping.promotion.page_number}" />
	<table style="margin:0 auto;width:95%;">
	<tbody>
	<tr>
		<td style="line-height:2em;vertical-align:top;">
			状態：<select name="shpmpstf" onchange="document.sform.submit();">
				<option value=""{if:strlen(shopping.promotion.status_flag)=0} selected{/if}>全て</option>
				{foreach:SHOPPING_PROMOTION_STATUS_HASH key status_name}
					<option value="{write:key}"
						{if:key=shopping.promotion.status_flag and strlen(shopping.promotion.status_flag)>0} selected{/if}
						>{write:status_name}</option>
				{/foreach}
			</select>
			検索ワード：<input type="text" name="shpq" value="{write:shopping.promotion.query}" /> <input type="submit" value="検索実行" />
		</td>
		<td style="text-align:right;line-height:2em;">
			<input type="button" value="プロモーション追加" onclick="shoppingPromotionAdd()"
			/><br />
			<?php for ( $key=0;$key<=0;$key++ ) { $request_object->setAttribute('key',$key); ?>
			並替項目<?php echo $key+1; ?>：<select name="shpsi[]" onchange="document.sform.submit();">
				{if:key>0}<option value=""{if:strlen(shopping.promotion.sort_item_array[key])=0} selected{/if}></option>{/if}
				<option value="reg"{if:shopping.promotion.sort_item_array[key]=='reg'} selected{/if}>登録日</option>
				<option value="upd"{if:shopping.promotion.sort_item_array[key]=='upd'} selected{/if}>更新日</option>
				<option value="dname"{if:shopping.promotion.sort_item_array[key]=='dname'} selected{/if}>プロモーション名</option>
				<option value="did"{if:shopping.promotion.sort_item_array[key]=='did'} selected{/if}>プロモーションID</option>
			</select>
			並順<?php echo $key+1; ?> <select name="shpso[]" onchange="document.sform.submit();">
				<option value="asc"{if:shopping.promotion.sort_order_array[key]='ASC'} selected{/if}>昇順</option>
				<option value="desc"{if:shopping.promotion.sort_order_array[key]='DESC' or strlen(shopping.promotion.sort_item_array[key])==0} selected{/if}>降順</option>
			</select><br />
			<?php } ?>
			ページ表示数：<select name="pr" onchange="document.sform.submit();">
				<option value="1"{if:shopping.promotion.page_rows==1} selected{/if}>1</option>
				<option value="5"{if:shopping.promotion.page_rows==5} selected{/if}>5</option>
				<option value="10"{if:shopping.promotion.page_rows==10} selected{/if}>10</option>
				<option value="20"{if:shopping.promotion.page_rows==20} selected{/if}>20</option>
				<option value="50"{if:shopping.promotion.page_rows==50} selected{/if}>50</option>
				<option value="100"{if:shopping.promotion.page_rows==100} selected{/if}>100</option>
			</select>
		</td>
	</tr>
	</tbody>
	</table>
	</form>

	<div style="margin:0 auto;width:95%;">
		{if:shopping.promotion.total_page>1}
			{write:shopping.promotion.total_count}件の検索結果 {write:shopping.promotion.page_number}/{write:shopping.promotion.total_page}ページ {write:count(shopping.promotion.promotion_array)}件を表示
			&nbsp;
			{if:shopping.promotion.page_number-5>1}...{/if}
			<?php for( $GLOBALS['pageNavi']=($GLOBALS['shopping.promotion.page_number']-5 >= 1 ? $GLOBALS['shopping.promotion.page_number']-5 : 1);
				$GLOBALS['pageNavi']<=$GLOBALS['shopping.promotion.total_page']
					&& $GLOBALS['pageNavi']<=($GLOBALS['shopping.promotion.page_number']-5 >= 1 ? $GLOBALS['shopping.promotion.page_number']-5 : 1)+9;
				$GLOBALS['pageNavi']++ ) { ?>
				{if:trim(pageNavi)!=trim(shopping.promotion.page_number)}
					<a href="javascript:FormerCommon.jumpPage({write:pageNavi})" onmouseover="this.style.color='#0000ff';" onmouseout="this.style.color='#808080';">{write:pageNavi}</a>
				{else}
					{write:pageNavi}
				{/if}
			<?php } ?>
			{if:shopping.promotion.page_number+9 < shopping.promotion.total_page}...{/if}
			&nbsp;
			{if:shopping.promotion.page_number-5>1}<a href="javascript:FormerCommon.jumpPage(1)" onmouseover="this.style.color='#0000ff';" onmouseout="this.style.color='#808080';">最初</a>{/if}
			{if:shopping.promotion.page_number+9 < shopping.promotion.total_page}<a href="javascript:FormerCommon.jumpPage({write:shopping.promotion.total_page})" onmouseover="this.style.color='#0000ff';" onmouseout="this.style.color='#808080';">最後</a>{/if}
			{if:shopping.promotion.has_prev_page}<a href="javascript:FormerCommon.prevPage()" onmouseover="this.style.color='#0000ff';" onmouseout="this.style.color='#808080';">前頁</a>{/if}
			{if:shopping.promotion.has_next_page}<a href="javascript:FormerCommon.nextPage()" onmouseover="this.style.color='#0000ff';" onmouseout="this.style.color='#808080';">次頁</a>{/if}
		{else}
			{write:shopping.promotion.total_count}件の検索結果
		{/if}
	</div>
	
	<table class="list" style="margin:0 auto;width:95%;">
	<tbody>
	<tr class="list">
		<th  style="width:5%;white-space:nowrap;">ID</th>
		<th>プロモーション情報</th>
		<th style="width:10%;white-space:nowrap;">操作</th>
	</tr>
	{foreach:shopping.promotion.promotion_array promotionObject}
	<tr id="prow-{write:promotionObject->'promotion_id'}"{if:promotionObject->'status_flag'<100} style="background-color:#ffe0e0;"{else-if:promotionObject->'status_flag'>=200} style="background-color:#a0a0a0;"{/if}>
		<td style="width:5%;white-space:nowrap;">{write:promotionObject->'promotion_id'}</td>
		<td>
			<span style="font-weight:bold;">
				{write:promotionObject->'promotion_name'}
				/
				紹介コード: <span style="font-weight:bold;">{write:promotionObject->'promotion_code'}</span>
			</span><br />
			<span style="color:#000088;">
				{write:SHOPPING_PROMOTION_RANK_HASH[promotionObject->'promotion_rank']}
				/
				{if:promotionObject->'pay_type'=='money'}
					定額報酬
					&yen;{write:number_format(promotionObject->'pay_value')}/件
				{else-if:promotionObject->'pay_type'=='rate'}
					定率報酬
					{write:promotionObject->'pay_value'}%
				{else}
					報酬なし
				{/if}
				/
				{if:promotionObject->'discount_type'=='money'}
					定額割引
					&yen;{write:number_format(promotionObject->'discount_value')}/件
				{else-if:promotionObject->'discount_type'=='rate'}
					定率割引
					{write:promotionObject->'discount_value'}%
				{else}
					割引なし
				{/if}
				/
				{if:promotionObject->'buying_flag'=='0'}
					卸販売なし
				{else-if:promotionObject->'buying_flag'=='1'}
					先払{write:promotionObject->'buying_rate'}%割引
				{else-if:promotionObject->'buying_flag'=='2'}
					許可{write:promotionObject->'buying_rate'}%割引
				{/if}
			</span>
			<br />
			<span style="font-size:x-small;color:#000088;">紹介ＰＣリンク: </span><input type="text" size="60" value="{if:defined('SPIDER_ACCESS_URL_HTTP') && strlen(SPIDER_ACCESS_URL_HTTP)>0}{write:SPIDER_ACCESS_URL_HTTP}{else}{write:SPIDER_URL_BASE}{/if}?afid={write:promotionObject->'promotion_code'}" style="width:70%;font-size:x-small;" /><br />
			<span style="font-size:x-small;color:#000088;">紹介携帯リンク: </span><input type="text" size="60" value="{if:defined('SPIDER_ACCESS_URL_HTTP') && strlen(SPIDER_ACCESS_URL_HTTP)>0}{write:SPIDER_ACCESS_URL_HTTP}{else}{write:SPIDER_URL_BASE}{/if}?guid=on&amp;afid={write:promotionObject->'promotion_code'}" style="width:70%;font-size:x-small;" /><br />
			{set:memberObject promotionObject->'memberObject'}
			{if:is_object(memberObject)}
			<div style="color:#008000;">
				関連会員情報: {write:memberObject->'member_id'} : {write:memberObject->'view_name'}
			</div>
			{/if}
		</td>
		<td class="list" style="text-align:center;">
			<select
				name="status_flag_{write:promotionObject->'promotion_id'}"
				onchange="shoppingPromotionChangeStatus('{write:promotionObject->'promotion_id'}',this)"
				{if:strlen(promotionObject->'member_id')>0}disabled="disabled"{/if}
				style="width:100%;">
				<option value=""{if:strlen(promotionObject->'status_flag')=0} selected{/if}>-</option>
				{foreach:SHOPPING_PROMOTION_STATUS_HASH key status_name}
					<option value="{write:key}"
						{if:key=promotionObject->'status_flag' and strlen(promotionObject->'status_flag')>0} selected{/if}
						>{write:status_name}</option>
				{/foreach}
			</select><br />
			{if:promotionObject::is_lock}{if:promotionObject::is_editable}
			<input type="button" style="width:100%;color:#FF0000;" value="ロック解除"
				onclick="window.location.href='./unlock.php?shppn={write:promotionObject->'promotion_number'}';" /><br />
			{/if}{/if}
			<input type="button" style="width:100%;" value="詳細閲覧"
				onclick="shoppingPromotionViewDetail('{write:promotionObject->'promotion_number'}');" /><br />
			{if:promotionObject::is_editable}
			<input type="button" style="width:100%;" value="登録変更"
				onclick="shoppingPromotionModify('{write:promotionObject->'promotion_number'}');" /><br />
			{/if}
		</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	<div style="margin:0 auto;width:95%;">
		{if:shopping.promotion.total_page>1}
			{write:shopping.promotion.total_count}件の検索結果 {write:shopping.promotion.page_number}/{write:shopping.promotion.total_page}ページ {write:count(shopping.promotion.promotion_array)}件を表示
			&nbsp;
			{if:shopping.promotion.page_number-5>1}...{/if}
			<?php for( $GLOBALS['pageNavi']=($GLOBALS['shopping.promotion.page_number']-5 >= 1 ? $GLOBALS['shopping.promotion.page_number']-5 : 1);
				$GLOBALS['pageNavi']<=$GLOBALS['shopping.promotion.total_page']
					&& $GLOBALS['pageNavi']<=($GLOBALS['shopping.promotion.page_number']-5 >= 1 ? $GLOBALS['shopping.promotion.page_number']-5 : 1)+9;
				$GLOBALS['pageNavi']++ ) { ?>
				{if:trim(pageNavi)!=trim(shopping.promotion.page_number)}
					<a href="javascript:FormerCommon.jumpPage({write:pageNavi})" onmouseover="this.style.color='#0000ff';" onmouseout="this.style.color='#808080';">{write:pageNavi}</a>
				{else}
					{write:pageNavi}
				{/if}
			<?php } ?>
			{if:shopping.promotion.page_number+9 < shopping.promotion.total_page}...{/if}
			&nbsp;
			{if:shopping.promotion.page_number-5>1}<a href="javascript:FormerCommon.jumpPage(1)" onmouseover="this.style.color='#0000ff';" onmouseout="this.style.color='#808080';">最初</a>{/if}
			{if:shopping.promotion.page_number+9 < shopping.promotion.total_page}<a href="javascript:FormerCommon.jumpPage({write:shopping.promotion.total_page})" onmouseover="this.style.color='#0000ff';" onmouseout="this.style.color='#808080';">最後</a>{/if}
			{if:shopping.promotion.has_prev_page}<a href="javascript:FormerCommon.prevPage()" onmouseover="this.style.color='#0000ff';" onmouseout="this.style.color='#808080';">前頁</a>{/if}
			{if:shopping.promotion.has_next_page}<a href="javascript:FormerCommon.nextPage()" onmouseover="this.style.color='#0000ff';" onmouseout="this.style.color='#808080';">次頁</a>{/if}
		{else}
			{write:shopping.promotion.total_count}件の検索結果
		{/if}
	</div>
	

<script language="JavaScript" type="text/javascript"><!--
var shoppingPromotionHttpObject;
var selectedPromotionId;
var selectedStatus;
function shoppingPromotionChangeStatus(promotionId,statusFlagSelect) {
	if( !promotionId ) {
		alert('プロモーションIDを指定してください');
		return;
	}
	if( !statusFlagSelect ) {
		alert('利用方法が正しくありません');
		return;
	}
	selectedPromotionId	= promotionId;
	var selected	= statusFlagSelect.selectedIndex;
	var statusFlag	= statusFlagSelect.options[selected].value;
	selectedStatus	= statusFlag;
	shoppingPromotionHttpObject	= FormerCommon.createHttpRequest(shoppingPromotionChangeStatusResult);
	var contents	= "command=0";
	contents	+= "&" + encodeURIComponent('promotion_id')+ "="+encodeURIComponent(promotionId);
	contents	+= "&" + encodeURIComponent('status_flag')+ "="+encodeURIComponent(statusFlag);
	if (shoppingPromotionHttpObject) {
		FormerCommon.displayGrayOut(9999);
		shoppingPromotionHttpObject.open("POST",'./changestatus.php',true);
		shoppingPromotionHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingPromotionHttpObject.send(contents);
	} else {
		alert('サーバーへの接続作成に失敗しました。');
	}
}
function shoppingPromotionChangeStatusResult() {
	if ((shoppingPromotionHttpObject.readyState == 4) && (shoppingPromotionHttpObject.status == 200)){
	    var lines	= shoppingPromotionHttpObject.responseText.cr2lf().split(LF);
	    var isError = false;
	    var error_message	= '';
	    for( var i=0; i<lines.length; i++ ){
			if( String(lines[i]).cr2lf().trim().length>0 ){
				var result	= String(lines[i]).cr2lf().trim();
				if( result == 'OK' ) {
					break;
				} else if( isError ) {
					error_message += result + "\n";
				} else {
					isError	= true;
				}
			}
		}
		if( isError ) {
			alert("設定の保存に失敗しました。\n\n" + error_message + "\n");
			setTimeout(FormerCommon.displayWhiteIn, 500);
		} else {
			setTimeout(FormerCommon.displayWhiteIn, 500);
			var rowElm	= document.getElementById('prow-'+selectedPromotionId);
			if( rowElm ) {
				if( selectedStatus < 100 ) {
					rowElm.style.backgroundColor	= '#ffe0e0';
				} else if( selectedStatus >= 200 ) {
					rowElm.style.backgroundColor	= '#a0a0a0';
				} else {
					rowElm.style.backgroundColor	= '#ffffff';
				}
			}
			alert('状態を変更しました');
		}
	} else if ((shoppingPromotionHttpObject.readyState == 4) && (shoppingPromotionHttpObject.status != 200)){
		setTimeout(FormerCommon.displayWhiteIn, 500);
		alert('適用時にサーバー通信でエラーが発生しました。');
	} else {
	}
}
//--></script>

	<hr style="width:95%;margin:0 auto;margin-top:1em;text-align:center;" />
	<div style="width:95%;margin:0 auto;text-align:right;">
		<a href="../">&gt;&gt; ショップ管理へ戻る</a>
	</div>