<?php include_once( "../../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.order.Cart}
{module:shopping.order.step.Form}
{module:shopping.order.Optimize}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_ORDER . '新規追加'}

	<div class="panc">
		<a href="../../../">管理パネルトップ</a>
		&gt; <a href="../../">ショップ管理</a>
		&gt; <a href="../">{write:SHOPPING_LABEL_ORDER}一覧</a>
		&gt; {write:SHOPPING_LABEL_ORDER}追加：配送とお支払い方法の指定
	</div><br />

	<div class="admin_orderform">	
	<h1><a name="pagetop" id="pagetop">{write:SHOPPING_LABEL_ORDER}追加：配送とお支払い方法の指定</a></h1>

	<div style="clear:both;width:95%;margin:0 auto;border:dotted 1px #999;background-color:#eee;color:#696969;text-align:center;padding:5px;">
		<a href="./purchaser.php">{write:SHOPPING_LABEL_PRODUCT}選択・お届け先の入力</a>
		&gt;
		<span style="font-weight:bold;">お支払い方法のご指定</span>
		&gt;
		{write:SHOPPING_LABEL_ORDER}内容の確認
		&gt;
		{write:SHOPPING_LABEL_ORDER}完了
	</div><br />

	{if:IS_ERROR}
	<!-- エラー表示 -->
	<ul class="error">
		{foreach:errors error}
			<li>{write:error}</li>
		{/foreach}
	</ul>
	{/if}
	
	{if:shopping.order.confirmResultPurchaser!='OK'}
	<p>
		お届け先のご指定をいただいておりません。<a href="./purchaser.php">お届け先の入力ページ</a>でお届け先をご入力ください。
	</p>
	<div style="margin: 0 auto;text-align:center;">
		<input type="button" value="お届け先の入力画面に戻る" style="padding:5px;text-align:center;background-color:#DFDFDF;border-style:solid;border-width:1px;"
			onclick="window.location.href='./purchaser.php';" />
	</div>
	
	{else}

	{if:count(shopping.order.orderObject->'columnErrorHash')>0}
	<p>
		<span class="error-msg">
		入力漏れか入力内容が正しくありません。<br />
		背景が赤色になっている項目を入力しなおしてください。
		</span>
	</p>
	{/if}

	{set:columnErrorHash shopping.order.orderObject->'columnErrorHash'}
	{set:memberObject shopping.order.orderObject->'memberObject'}
	
	{if:strlen(memberObject->'member_number')>0 && memberObject->'member_class' > 0}	
		{set:maxUsagePoint 0}
		{if:'2'==shopping.order.pointSettleMethod}
			{set:maxUsagePoint shopping.order.orderObject->'payment_total'+shopping.order.orderObject->'point_use'}
		{else}
			{set:maxUsagePoint shopping.order.orderObject->'price_total'}
		{/if}
		{if:memberObject->'point'>0 && maxUsagePoint>0}
		<form name="pointForm" action="./settlement.php" method="POST">
		<input type="hidden" name="command" value="point" />
		<h2>ポイント利用</h2>
		<p>
			{write:memberObject->'view_name'}さんは現在{write:number_format(memberObject->'point')}ポイントをお持ちです。<br />
			ポイントは{write:number_format(shopping.order.pointUnit)}ポイント単位で
			{if:'2'==shopping.order.pointSettleMethod}お支払金額{else}{write:SHOPPING_LABEL_PRODUCT}代金{/if}{write:number_format(maxUsagePoint)}Pt.までポイントをご利用いただけます。<br />
			{if:array_key_exists('point_use',columnErrorHash)}
			<span style="color:#ff0000;">
			{foreach:columnErrorHash::point_use error}{write:error}<br />{/foreach}</span>
			{/if}
		</p>
		<table>
		<tbody>
		<tr>
			<th style="width:50%;">金額内容</th>
			<th style="width:50%;">ご利用ポイント数</th>
		</tr>
		<tr>
			<td>
				お支払金額:&yen;{write:number_format(shopping.order.orderObject->'payment_total'+shopping.order.orderObject->'point_use')}-<br />
				内{write:SHOPPING_LABEL_PRODUCT}代金:&yen;{write:number_format(shopping.order.orderObject->'price_total')}-
			</td>
			<td>
				{if:strlen(shopping.order.pointUnit)!=0 && shopping.order.pointUnit=='0'}
					<input type="text" name="point_use" size="5" value="{write:shopping.order.orderObject->'point_use'}" />
				{else}
				<select name="point_use"{if:array_key_exists('point_use',columnErrorHash)} style="background-color:#ffa0a0;"{/if}>
					<option value="0">0</option>
					{set:isMaxExists 'false'}
					<?php for( $GLOBALS['up']=$GLOBALS['shopping.order.pointUnit']; $GLOBALS['up']<=$GLOBALS['memberObject']->point
						&& $GLOBALS['up'] <= $GLOBALS['maxUsagePoint'] * ($GLOBALS['shopping.order.pointSettleRate']/100); $GLOBALS['up']+=$GLOBALS['shopping.order.pointUnit'] ) { ?>
					<option value="{write:up}"{if:shopping.order.orderObject->'point_use'==up} selected{set:isMaxExists 'true'}{/if}>{write:number_format(up)}</option>
					<?php } ?>
					{if:isMaxExists != 'true' && shopping.order.pointSettleRate==100 && memberObject->'point'>maxUsagePoint}
					<option value="{write:maxUsagePoint}"
						{if:shopping.order.orderObject->'point_use'==maxUsagePoint} selected{/if}
						>{write:number_format(maxUsagePoint)}</option>
					{/if}
				</select>{/if}/{write:number_format(memberObject->pointCurrent(request_object))}Pt.<br />
				<input type="submit" value="利用する" />
			</td>
		</tr>
		</tbody>
		</table>
		<p style="text-align:right;">
			ポイント利用後のお支払い金額: &yen;{write:number_format(shopping.order.orderObject->'payment_total')}-
		</p>
		</form>
		{/if}	
	{/if}

	<form name="orderForm" action="./settlementc.php" method="POST">
	{if:shopping.order.orderObject->'payment_total'>0 || shopping.order.orderObject->'point_use'>0}
	<h2>お支払い方法</h2>
	{if:array_key_exists('settle_method',columnErrorHash)}
	<p style="color:#ff0000;">
	{foreach:columnErrorHash::settle_method error}{write:error}<br />{/foreach}</p>
	{/if}
	{if:shopping.order.orderObject->'payment_total'==0}
		<p>
			ポイント内でお支払いが完了しています。
		</p>
		<input type="hidden" name="settle_method" value="16" />
	{else}
	<table style="width:95%;margin:0 auto;border-collapse:collapse;border:solid 1px #e0e0e0;{if:array_key_exists('settle_method',shopping.order.orderObject->'columnErrorHash')}background-color:#ffa0a0;{/if}">
	<tbody>
	{foreach:shopping.order.settlement.methodObjectArray settleMethodObject}
	<tr>
		<td style="width:10em;border:solid 1px #e0e0e0;vertical-align:top;padding:5px;">
			<input type="radio" name="settle_method" value="{write:settleMethodObject->getMethodNumber()}"
				{if:shopping.order.orderObject->'settle_method'==settleMethodObject->getMethodNumber()} checked{/if}
			/>{write:settleMethodObject->getMethodViewName()}
		</td>
		<td style="border:solid 1px #e0e0e0;padding:5px;">
			{write:settleMethodObject->getMethodExplanation() noescape}
			{write:settleMethodObject->getInputFormHtml(request,shopping.order.orderObject) noescape}
		</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	{/if}
	{else}
		<input type="hidden" name="settle_method" value="16" />
	{/if}
	
	<h2>その他・通信欄</h2>
	<p style="width:95%;margin:0 auto;">
		{if:array_key_exists('order_comment',columnErrorHash)}
		<span style="color:#ff0000;">
		{foreach:columnErrorHash::order_comment error}{write:error}<br />{/foreach}</span>
		{/if}
		<textarea name="order_comment" cols="50" rows="5"
			{if:array_key_exists('order_comment',shopping.order.orderObject->'columnErrorHash')} style="background-color:#ffa0a0;"{/if}
			>{write:shopping.order.orderObject->'order_comment'}</textarea>
	</p>

	<p style="text-align:center;">
		<input type="submit" value="{write:SHOPPING_LABEL_ORDER}内容の確認へ" name="submit" style="padding:5px;text-align:center;background-color:#DFDFDF;border-style:solid;border-width:1px;"/>
	</p>
	</form>
	
	{/if}
</div>