<?php include_once( "../../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.order.option.LoadList}
{module:shopping.category.LoadList}
{module:shopping.product.LoadList}
{module:shopping.order.CartAdmin}
{module:shopping.order.Optimize}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_ORDER . '情報編集'}
	<script language="JavaScript" type="text/javascript" src="/js/reserve.js" charset="UTF-8"></script>
	<div class="panc">
		<a href="../../../">管理パネルトップ</a>
		&gt; <a href="../../">ショップ管理</a>
		&gt; <a href="../">{write:SHOPPING_LABEL_ORDER}一覧</a>
		&gt; {write:SHOPPING_LABEL_ORDER}編集：{write:SHOPPING_LABEL_PRODUCT}選択とお届け先入力
	</div><br />

	<div class="admin_orderform">
	<h1><a name="pagetop" id="pagetop">{write:SHOPPING_LABEL_ORDER}編集{write:shopping.order.orderObject->'order_id'} : {write:SHOPPING_LABEL_PRODUCT}選択・お届け先入力</a></h1>
	
	<div style="clear:both;width:95%;margin:0 auto;border:dotted 1px #999;background-color:#eee;color:#696969;text-align:center;padding:5px;">
		<span style="font-weight:bold;">{write:SHOPPING_LABEL_PRODUCT}選択・お届け先の入力</span>
		&gt;
		お支払い方法の指定
		&gt;
		{write:SHOPPING_LABEL_ORDER}内容の確認
		&gt;
		{write:SHOPPING_LABEL_ORDER}完了
	</div><br />
	
	<!-- カート -->
	<h2>{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}選択</h2>
	<table>
	<thead>
	<tr>
		<th style="width:50%;"><form name="sform" method="get" onsubmit="shoppingOrderViewProduct()">
			<input type="hidden" name="pn" value="{write:shopping.product.page_number}" />
			<input type="hidden" name="pr" value="5" />
				<select name="shpci" onchange="shoppingOrderViewProduct()">
					<option value=""{if:count(shopping.product.category_id_array)=0} selected{/if}>全ての{write:SHOPPING_LABEL_PRODUCT}</option>
				{foreach:shopping.category.data_array num category_object}
				{set:child_category_array category_object::child_category_object_array}
					<option value="{write:category_object->'category_id'}"
						{if:in_array(category_object::category_id,shopping.product.category_id_array)} selected{/if}
						>{write:category_object->'category_name'}</option>
					{foreach:child_category_array child_category_object}
					{set:grand_child_category_array child_category_object::child_category_object_array}
					<option value="{write:child_category_object->'category_id'}"
						{if:in_array(child_category_object::category_id,shopping.product.category_id_array)} selected{/if}
						>&nbsp;┣&nbsp;{write:child_category_object->'category_name'}</option>
						{foreach:grand_child_category_array grand_child_category_object}
						<option value="{write:grand_child_category_object->'category_id'}"
							{if:in_array(grand_child_category_object::category_id,shopping.product.category_id_array)} selected{/if}
							>&nbsp;&nbsp;┣&nbsp;{write:grand_child_category_object->'category_name'}</option>
						{/foreach}
					{/foreach}
				{/foreach}
				</select><input type="text" name="shpq" size="10" value="{write:shopping.product.query}" /><input type="button" value="検索" onclick="shoppingOrderViewProduct()" />
		</form></th>
		<th style="width:50%;">買い物かご</th>
	</tr>
	</thead>
	<tbody>
	<tr>
		<td style="padding:0px;width:50%;vertical-align:top;"
		><div id="shopping-order-list" style="padding:0px;height:325px;overflow:scroll;"></div></td>
		<td style="padding:0px;width:50%;vertical-align:top;"
		><div id="shopping-order-cart" style="padding:0px;height:325px;overflow:scroll;"></div></td>
	</tr>
	</tbody>
	</table>
	<form name="pform" method="post">

	{if:IS_ERROR}
	<!-- エラー表示 -->
	<ul class="error">
		{foreach:errors error}
			<li>{write:error}</li>
		{/foreach}
	</ul>
	{/if}
	
	<br />
	<table>
	<tbody>
	<tr>
		<th>プロモーション紹介コード</th>
		<td>
			<input type="text" name="promotion_code" size="20" value="{write:shopping.order.orderObject->'promotion_code'}"
		/>&nbsp;<input type="button" value="適用" onclick="shoppingOrderApplyPromotion()" /><input type="button" value="解除" onclick="shoppingOrderApplyPromotion()" />
		</td>
	</tr>
	</tbody>
	</table>

	</form>

	<br />
	
	{set:columnErrorHash shopping.order.orderObject->'columnErrorHash'}
	{if:count(shopping.order.orderObject->'columnErrorHash')>0}
	<p>
		<span class="error-msg">
		入力漏れか入力内容が正しくありません。<br />
		背景が赤色になっている項目を入力しなおしてください。
		</span>
	</p>
	{/if}
	<form name="orderForm" action="./purchaserc.php?shpoi={write:shopping.order.orderObject->'order_id'}" method="POST">	
	{set:memberObject shopping.order.orderObject->'memberObject'}
	<h2>{write:MEMBER_PERSONAL_LABEL}情報</h2>
	<table>
	<tbody>
	<tr>
		<th style="width:15em;padding:5px;vertical-align:top;">{write:MEMBER_PERSONAL_LABEL}ID</th>
		<td>{write:memberObject->'member_id'}<input type="hidden" name="member_id" value="{write:memberObject->'member_id'}" /></td>
	</tr>
	<tr>
		<th>会員種別</th>
		<td>
			<input type="hidden" name="member_class" value="{write:memberObject->'member_class'}" />
			{write:MEMBER_MEMBER_CLASS_HASH[memberObject->'member_class']}
		</td>
	</tr>
	<tr>
		<th style="width:15em;padding:5px;vertical-align:top;">お名前<span class="required">*</span></th>
		<td>
			<input type="text" name="family_name" size="10" value="{write:memberObject->'family_name'}"{if:array_key_exists('family_name',columnErrorHash)} style="background-color:#ffa0a0;"{/if} />
			<input type="text" name="first_name" size="10" value="{write:memberObject->'first_name'}"{if:array_key_exists('first_name',columnErrorHash)} style="background-color:#ffa0a0;"{/if} /><br />
			{if:array_key_exists('family_name',columnErrorHash)}
			<span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::family_name error}{write:error}<br />{/foreach}</span>
			{/if}
			{if:array_key_exists('first_name',columnErrorHash)}
			<span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::first_name error}{write:error}<br />{/foreach}</span>
			{/if}
		</td>
	</tr>
	<tr>
		<th>フリガナ{if:in_array('name_kana',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			<input type="text" name="family_kana" size="10" value="{write:memberObject->'family_kana'}"{if:array_key_exists('family_kana',columnErrorHash)} style="background-color:#ffa0a0;"{/if} />
			<input type="text" name="first_kana" size="10" value="{write:memberObject->'first_kana'}"{if:array_key_exists('first_kana',columnErrorHash)} style="background-color:#ffa0a0;"{/if} /><br />
			{if:array_key_exists('family_kana',columnErrorHash)}
			<span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::family_kana error}{write:error}<br />{/foreach}</span>
			{/if}
			{if:array_key_exists('first_kana',columnErrorHash)}
			<span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::first_kana error}{write:error}<br />{/foreach}</span>
			{/if}
		</td>
	</tr>
	<tr>
		<th>メールアドレス</th>
		<td>
			<div id="panel-select-email" style="display:none;visibility:hidden;position:absolute;white-space:nowrap;">
				<div id="panel-select-email-none" style="display:inline;">
					<input type="radio" id="mail_flag_0" name="mail_flag" value="0"{if:shopping.order.orderObject->'mail_flag'=='0'} checked{/if}
					/><label id="mail_flag_0_label" for="mail_flag_0" style="cursor:pointer;"> 送信しない</label>
				</div>
				<div id="panel-select-email-pc" style="display:inline;">
					<input type="radio" id="mail_flag_1" name="mail_flag" value="1"{if:shopping.order.orderObject->'mail_flag'=='1'} checked{/if}
					/><label id="mail_flag_1_label" for="mail_flag_1" style="cursor:pointer;"> {write:memberObject->'pc_mail'}</label>
				</div>
				<div id="panel-select-email-mb" style="display:inline;">
					<input type="radio" id="mail_flag_2" name="mail_flag" value="2"{if:shopping.order.orderObject->'mail_flag'=='2'} checked{/if}
					/><label id="mail_flag_2_label" for="mail_flag_2" style="cursor:pointer;"> {write:memberObject->'mb_mail'}</label>
				</div>
				<input type="hidden" name="pc_mail" value="{write:memberObject->'pc_mail'}" />
				<input type="hidden" name="mb_mail" value="{write:memberObject->'mb_mail'}" />
			</div>
			<div id="panel-input-email" style="visibility:visible;position:static;white-space:nowrap;">
				<input type="text" name="email" size="50" value="{write:memberObject->'email'}"
					{if:array_key_exists('email',columnErrorHash)} style="background-color:#ffa0a0;"{/if}
				/>
				{if:array_key_exists('email',columnErrorHash)}
				<br /><span style="color:#ff0000;font-size:x-small;">
				{foreach:columnErrorHash::email error}{write:error}<br />{/foreach}</span>
				{/if}
				<br />
				<input type="text" name="email_retype" size="50" value="{write:memberObject->'email_retype'}"
					{if:array_key_exists('email_retype',columnErrorHash)} style="background-color:#ffa0a0;"{/if}
				/>(確認入力)
				{if:array_key_exists('email_retype',columnErrorHash)}
				<br /><span style="color:#ff0000;font-size:x-small;">
				{foreach:columnErrorHash::email_retype error}{write:error}<br />{/foreach}</span>
				{/if}
			</div>
		</td>
	</tr>
	<tr>
		<th>郵便番号{if:in_array('zip_code',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			〒<input type="text" name="zip_code_pre" size="3" value="{write:memberObject->'zip_code_pre'}"
				{if:array_key_exists('zip_code_pre',columnErrorHash)} style="background-color:#ffa0a0;"{/if}
			/>-<input type="text" name="zip_code_pst" size="4" value="{write:memberObject->'zip_code_pst'}"
				{if:array_key_exists('zip_code_pst',columnErrorHash)} style="background-color:#ffa0a0;"{/if}
			/><br />
			{if:array_key_exists('zip_code_pre',columnErrorHash)}
			<span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::zip_code_pre error}{write:error}<br />{/foreach}</span>
			{/if}
			{if:array_key_exists('zip_code_pst',columnErrorHash)}
			<span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::zip_code_pst error}{write:error}<br />{/foreach}</span>
			{/if}
		</td>
	</tr>
	<tr>
		<th>都道府県{if:in_array('prefecture',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td style="padding:5px;{if:array_key_exists('prefecture_number',columnErrorHash)}background-color:#ffa0a0;{/if}">
			<select name="prefecture_number">
				<option value="">選択必須</option>
				{foreach:PREFECTURE_HASH prefNumber prefName}
				<option value="{write:prefNumber}"{if:prefNumber==memberObject->'prefecture_number'} selected{/if}>{write:prefName}</option>
				{/foreach}
			</select>
			{if:array_key_exists('prefecture_number',columnErrorHash)}
			<br /><span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::prefecture_number error}{write:error}<br />{/foreach}</span>
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:15em;padding:5px;vertical-align:top;">住所・番地{if:in_array('address',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			<input type="text" name="address" size="50" value="{write:memberObject->'address'}"
			{if:array_key_exists('address',columnErrorHash)} style="background-color:#ffa0a0;"{/if}
			/>
			{if:array_key_exists('address',columnErrorHash)}
			<br /><span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::address error}{write:error}<br />{/foreach}</span>
			{/if}
		</td>
	</tr>
	<tr>
		<th>建物名・部屋番号</th>
		<td>
			<input type="text" name="building" size="50" value="{write:memberObject->'building'}"
				{if:array_key_exists('building',columnErrorHash)} style="background-color:#ffa0a0;"{/if}
			/>
			<br />建物名も省略せずにご記入ください
			{if:array_key_exists('building',columnErrorHash)}
			<br /><span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::building error}{write:error}<br />{/foreach}</span>
			{/if}
		</td>
	</tr>
	<tr>
		<th>お電話番号{if:in_array('telephone',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			<input type="text" name="telephone_number_area" size="5" value="{write:memberObject->'telephone_number_area'}"
				{if:array_key_exists('telephone_number',columnErrorHash)} style="background-color:#ffa0a0;"{/if}
			/>-<input type="text" name="telephone_number_city" size="5" value="{write:memberObject->'telephone_number_city'}"
				{if:array_key_exists('telephone_number',columnErrorHash)} style="background-color:#ffa0a0;"{/if}
			/>-<input type="text" name="telephone_number_local" size="5" value="{write:memberObject->'telephone_number_local'}"
				{if:array_key_exists('telephone_number',columnErrorHash)} style="background-color:#ffa0a0;"{/if}
			/>
			{if:array_key_exists('telephone_number',columnErrorHash)}
			<br /><span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::telephone_number error}{write:error}<br />{/foreach}</span>
			{/if}
		</td>
	</tr>
	<tr>
		<th>FAX番号{if:in_array('faximili',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			<input type="text" name="faximili_number_area" size="5" value="{write:memberObject->'faximili_number_area'}" style="ime-mode:inactive;"
			/>-<input type="text" name="faximili_number_city" size="5" value="{write:memberObject->'faximili_number_city'}" style="ime-mode:inactive;"
			/>-<input type="text" name="faximili_number_local" size="5" value="{write:memberObject->'faximili_number_local'}" style="ime-mode:inactive;"
			/>
		</td>
	</tr>
	<tr>
		<th>携帯電話番号{if:in_array('mobile',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			<input type="text" name="mobile_number_area" size="5" value="{write:memberObject->'mobile_number_area'}" style="ime-mode:inactive;"
			/>-<input type="text" name="mobile_number_city" size="5" value="{write:memberObject->'mobile_number_city'}" style="ime-mode:inactive;"
			/>-<input type="text" name="mobile_number_local" size="5" value="{write:memberObject->'mobile_number_local'}" style="ime-mode:inactive;"
			/>
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	
	{if:in_array('zip_code2',MEMBER_REGIST_ITEM) || in_array('prefecture2',MEMBER_REGIST_ITEM) || in_array('address2',MEMBER_REGIST_ITEM) || in_array('telephone2',MEMBER_REGIST_ITEM) || in_array('faximili2',MEMBER_REGIST_ITEM)}
	<h2>ご連絡先２</h2>
	<table>
	<tbody>
	{if:in_array('zip_code2',MEMBER_REGIST_ITEM)}
	<tr>
		<th>郵便番号{if:in_array('zip_code2',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			<input type="text" name="zip_code2_pre" size="3" value="{write:memberObject->'zip_code2_pre'}" style="ime-mode:inactive;"
				/>-<input type="text" name="zip_code2_pst" size="4" value="{write:memberObject->'zip_code2_pst'}" style="ime-mode:inactive;"
				/>
		</td>
	</tr>
	{/if}
	{if:in_array('prefecture2',MEMBER_REGIST_ITEM)}
	<tr>
		<th>都道府県{if:in_array('prefecture2',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			<select name="prefecture_number2">
				<option value="">選択</option>
				{foreach:PREFECTURE_HASH prefNumber prefName}
				<option value="{write:prefNumber}"
					{if:prefNumber==memberObject->'prefecture_number2'} selected{/if}
					/>{write:prefName}</option>
				{/foreach}
			</select>
		</td>
	</tr>
	{/if}
	{if:in_array('address2',MEMBER_REGIST_ITEM)}
	<tr>
		<th>住所・番地{if:in_array('address2',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			<input type="text" name="address2" size="50" value="{write:memberObject->'address2'}" style="ime-mode:active;" />
		</td>
	</tr>
	<tr>
		<th>建物名・部屋番号</th>
		<td>
			<input type="text" name="building2" size="50" value="{write:memberObject->'building2'}" style="ime-mode:active;" />
		</td>
	</tr>
	{/if}
	{if:in_array('telephone2',MEMBER_REGIST_ITEM)}
	<tr>
		<th style="width:15em;padding:5px;vertical-align:top;">電話番号{if:in_array('telephone2',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			<input type="text" name="telephone_number2_area" size="5" value="{write:memberObject->'telephone_number2_area'}"
				{if:array_key_exists('telephone_number2',columnErrorHash)} style="background-color:#ffa0a0;"{/if}
			/>-<input type="text" name="telephone_number2_city" size="5" value="{write:memberObject->'telephone_number2_city'}"
				{if:array_key_exists('telephone_number2',columnErrorHash)} style="background-color:#ffa0a0;"{/if}
			/>-<input type="text" name="telephone_number2_local" size="5" value="{write:memberObject->'telephone_number2_local'}"
				{if:array_key_exists('telephone_number2',columnErrorHash)} style="background-color:#ffa0a0;"{/if}
			/>
			{if:array_key_exists('telephone_number2',columnErrorHash)}
			<br /><span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::telephone_number2 error}{write:error}<br />{/foreach}</span>
			{/if}
		</td>
	</tr>
	{/if}
	{if:in_array('faximili2',MEMBER_REGIST_ITEM)}
	<tr>
		<th>FAX番号{if:in_array('faximili2',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			<input type="text" name="faximili_number2_area" size="5" value="{write:memberObject->'faximili_number2_area'}" style="ime-mode:inactive;"
			/>-<input type="text" name="faximili_number2_city" size="5" value="{write:memberObject->'faximili_number2_city'}" style="ime-mode:inactive;"
			/>-<input type="text" name="faximili_number2_local" size="5" value="{write:memberObject->'faximili_number2_local'}" style="ime-mode:inactive;"
			/>
		</td>
	</tr>
	{/if}
	</tbody>
	</table>
	<br />
	{/if}

	{if:in_array('company_name',MEMBER_REGIST_ITEM) || in_array('section_name',MEMBER_REGIST_ITEM)}
	<h2>お勤め先</h2>
	<table>
	<tbody>
	{if:in_array('company_name',MEMBER_REGIST_ITEM)}
	<tr>
		<th>会社名{if:in_array('company_name',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			<input type="text" name="company_name" size="50" value="{write:memberObject->'company_name'}"
			{if:array_key_exists('company_name',columnErrorHash)} style="ime-mode:active;background-color:#ffa0a0;"{else} style="ime-mode:active;"{/if}
			/>
			{if:array_key_exists('company_name',columnErrorHash)}
			<br /><span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::company_name error}{write:error}<br />{/foreach}</span>
			{/if}
		</td>
	</tr>
	{/if}
	{if:in_array('section_name',MEMBER_REGIST_ITEM)}
	<tr>
		<th>部署名{if:in_array('section_name',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			<input type="text" name="section_name" size="30" value="{write:memberObject->'section_name'}"
			{if:array_key_exists('section_name',columnErrorHash)} style="ime-mode:active;background-color:#ffa0a0;"{else} style="ime-mode:active;"{/if}
			/>
			{if:array_key_exists('section_name',columnErrorHash)}
			<br /><span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::section_name error}{write:error}<br />{/foreach}</span>
			{/if}
		</td>
	</tr>
	{/if}
	</tbody>
	</table>
	<br />
	{/if}
	
	{if:in_array('sex',MEMBER_REGIST_ITEM) || in_array('birth_year',MEMBER_REGIST_ITEM) || in_array('birth_month',MEMBER_REGIST_ITEM) || in_array('birth_day',MEMBER_REGIST_ITEM) || in_array('blood_type',MEMBER_REGIST_ITEM)}
	<h2>プロフィール</h2>
	<table>
	<tbody>
	{if:in_array('sex',MEMBER_REGIST_ITEM)}
	<tr>
		<th style="width:15em;padding:5px;vertical-align:top;">性別{if:in_array('sex',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			{foreach:MEMBER_MEMBER_SEX_HASH typeKey typeName}
			<input type="radio" name="sex" value="{write:typeKey}"
				{if:typeKey==memberObject->'sex'} checked{/if}
				/> {write:typeName}
			{/foreach}
		</td>
	</tr>
	{/if}
	{if:in_array('birth_year',MEMBER_REGIST_ITEM) || in_array('birth_month',MEMBER_REGIST_ITEM) || in_array('birth_day',MEMBER_REGIST_ITEM)}
	<tr>
		<th>生年月日{if:in_array('birth_year',MEMBER_REQUIRE_ITEM) || in_array('birth_month',MEMBER_REQUIRE_ITEM) || in_array('birth_day',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			{if:in_array('birth_year',MEMBER_REGIST_ITEM)}
			西暦 <select name="birth_year">
				<option value="">選択</option>
				<?php for( $i=date('Y'); $i>1900; $i-- ) { $request->setAttribute('page.year',$i); ?>
				<option value="{write:page.year}"
					{if:page.year==memberObject->'birth_year'} selected{/if}
				>{write:page.year}</option>
				<?php } ?>
			</select>年
			{/if}
			{if:in_array('birth_month',MEMBER_REGIST_ITEM)}
			<select name="birth_month">
				<option value="">選択</option>
				<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('page.month',sprintf('%02d',$i)); ?>
				<option value="{write:page.month}"
					{if:page.month==memberObject->'birth_month'} selected{/if}
				>{write:page.month}</option>
				<?php } ?>
			</select>月
			{/if}
			{if:in_array('birth_day',MEMBER_REGIST_ITEM)}
			<select name="birth_day">
				<option value="">選択</option>
				<?php for( $i=1; $i<=31; $i++ ) { $request->setAttribute('page.day',sprintf('%02d',$i)); ?>
				<option value="{write:page.day}"
					{if:page.day==memberObject->'birth_day'} selected{/if}
				>{write:page.day}</option>
				<?php } ?>
			</select>日
			{/if}
		</td>
	</tr>
	{/if}
	{if:in_array('blood_type',MEMBER_REGIST_ITEM)}
	<tr>
		<th>血液型{if:in_array('blood_type',MEMBER_REQUIRE_ITEM)}<span class="required">*</span>{/if}</th>
		<td>
			{foreach:MEMBER_MEMBER_BLOOD_TYPE_HASH typeKey typeName}
			<input type="radio" name="blood_type" value="{write:typeKey}"
				{if:typeKey==memberObject->'blood_type'} checked{/if}
				/> {write:typeName}
			{/foreach}
		</td>
	</tr>
	{/if}
	</tbody>
	</table>
	<br />
	{/if}
	
	<!-- お届け先の情報 -->
	<div id="address-area"></div>
	
	<!-- {write:SHOPPING_LABEL_ORDER}オプション -->
	{foreach:shopping.order.orderObject::shoppingOrderOptionObjectArray key optionObject}
	<h2>{write:optionObject->'optionName'}{if:optionObject->'required'}<span style="font-size:x-small;color:#ff0000;">※</span>{/if}</h2>
	<p>
		{write:nl2br(optionObject->'explain')}
		{if:is_array(optionObject->'columnErrorHash'['option_value'])}{set:errorArray optionObject->'columnErrorHash'['option_value']}
		<br />
		<span style="color:#ff0000;">{foreach:errorArray errorMessage}{write:errorMessage}<br />{/foreach}</span>
		{/if}
		<br />
		{write:optionObject->getInputForm( request, optionObject->'option_value' ) noescape}
	</p>
	<br />
	{/foreach}
	
	<h2>{write:SHOPPING_LABEL_ORDER}管理情報</h2>
	<table>
	<tbody>
	<tr>
		<th>{write:SHOPPING_LABEL_ORDER}日時</th>
		<td>
			<input type="text" name="order_date" size="25"
			value="{write:shopping.order.orderObject->'order_date'}"{if:array_key_exists('order_date',columnErrorHash)}style="background-color:#ffa0a0;"{/if}
			/><input type="button" value="現在日時設定" onclick="shoppingOrderDateRenew()" />  
			{if:array_key_exists('order_date',columnErrorHash)}
			<br /><span style="color:#ff0000;font-size:x-small;">
			{foreach:columnErrorHash::order_date error}{write:error}<br />{/foreach}</span>
			{/if}
		</td>
	</tr>
	<tr>
		<th>管理者メモ</th>
		<td>
			{if:array_key_exists('admin_note',columnErrorHash)}
			<span style="color:#ff0000;">
			{foreach:columnErrorHash::admin_note error}{write:error}<br />{/foreach}</span>
			{/if}
			<textarea name="admin_note" cols="50" rows="5"
				{if:array_key_exists('admin_note',shopping.order.orderObject->'columnErrorHash')} style="background-color:#ffa0a0;"{/if}
				>{write:shopping.order.orderObject->'admin_note'}</textarea>
		</td>
	</tr>
	</tbody>
	</table><br />
	
	<p style="text-align:center;">
		<input type="submit" value="お支払方法のご指定へ" name="submit" style="padding:5px;text-align:center;background-color:#DFDFDF;border-style:solid;border-width:1px;" />
	</p>
	</form>

	</div>
	
<script language="JavaScript" type="text/javascript"><!--
function shoppingOrderCopyAddress2Address(addressOrder) {
	document.getElementById('address-name-'+addressOrder).value	= document.orderForm.family_name.value + document.orderForm.first_name.value + '様';
	document.getElementById('address-kana-'+addressOrder).value	= document.orderForm.family_kana.value + document.orderForm.first_kana.value + 'サマ';
	document.getElementById('address-address-'+addressOrder).value	= document.orderForm.address.value;
	document.getElementById('address-building-'+addressOrder).value	= document.orderForm.building.value;
	document.getElementById('address-zip-code-pre-'+addressOrder).value	= document.orderForm.zip_code_pre.value;
	document.getElementById('address-zip-code-pst-'+addressOrder).value	= document.orderForm.zip_code_pst.value;
	document.getElementById('address-telephone-number-area-'+addressOrder).value	= document.orderForm.telephone_number_area.value;
	document.getElementById('address-telephone-number-city-'+addressOrder).value	= document.orderForm.telephone_number_city.value;
	document.getElementById('address-telephone-number-local-'+addressOrder).value	= document.orderForm.telephone_number_local.value;
	document.getElementById('address-prefecture-number-'+addressOrder).selectedIndex	= document.orderForm.prefecture_number.selectedIndex;
}
function shoppingOrderChangeEmailInput() {
	var memberId		= document.orderForm.member_id.value;
	var isMember		= (parseInt(document.orderForm.member_class.value) > 0);
	var mailSelectPanel	= document.getElementById('panel-select-email');
	var mailInputPanel	= document.getElementById('panel-input-email');
	var mailSelectPc	= document.getElementById('panel-select-email-pc');
	var mailSelectMb	= document.getElementById('panel-select-email-mb');
	var pcMail	= document.orderForm.pc_mail.value;
	var mbMail	= document.orderForm.mb_mail.value;
	if( pcMail && pcMail.length > 0 ) {
		mailSelectPc.style.display	= 'block';
		mailSelectPc.style.visibility	= 'visible';
		mailSelectPc.style.position		= 'static';
		var pcLabel	= document.getElementById('mail_flag_1_label');
		pcLabel.innerHTML	= ' ' +pcMail;
	} else {
		mailSelectPc.style.display	= 'none';
		mailSelectPc.style.visibility	= 'hidden';
		mailSelectPc.style.position		= 'absolute';
	}
	if( mbMail && mbMail.length > 0 ) {
		mailSelectMb.style.display	= 'block';
		mailSelectMb.style.visibility	= 'visible';
		mailSelectMb.style.position		= 'static';
		var mbLabel	= document.getElementById('mail_flag_2_label');
		mbLabel.innerHTML	= ' ' +mbMail;
	} else {
		mailSelectMb.style.display	= 'none';
		mailSelectMb.style.visibility	= 'hidden';
		mailSelectMb.style.position		= 'absolute';
	}
	if( memberId && memberId.length > 0 && isMember ) {
		mailSelectPanel.style.display	= 'block';
		mailSelectPanel.style.visibility	= 'visible';
		mailSelectPanel.style.position		= 'static';
		mailInputPanel.style.display		= 'none';
		mailInputPanel.style.visibility		= 'hidden';
		mailInputPanel.style.position		= 'absolute';
		var mailFlag0	= document.getElementById('mail_flag_0');
		var mailFlag1	= document.getElementById('mail_flag_1');
		var mailFlag2	= document.getElementById('mail_flag_2');
		if( mailFlag2.checked && mbMail ) {
			document.orderForm.email.value			= mbMail;
			document.orderForm.email_retype.value	= mbMail;
		} else if( mailFlag1.checked && pcMail ) {
			document.orderForm.email.value			= pcMail;
			document.orderForm.email_retype.value	= pcMail;
		} else if( mbMail ) {
			document.orderForm.email.value			= mbMail;
			document.orderForm.email_retype.value	= mbMail;
		} else {
			document.orderForm.email.value			= pcMail;
			document.orderForm.email_retype.value	= pcMail;
		}
	} else {
		mailSelectPanel.style.display	= 'none';
		mailSelectPanel.style.visibility	= 'hidden';
		mailSelectPanel.style.position		= 'absolute';
		mailInputPanel.style.display		= 'block';
		mailInputPanel.style.visibility		= 'visible';
		mailInputPanel.style.position		= 'static';
		mailSelectMb.style.display		= 'none';
		mailSelectMb.style.visibility		= 'hidden';
		mailSelectMb.style.position			= 'absolute';
		mailSelectPc.style.display		= 'none';
		mailSelectPc.style.visibility		= 'hidden';
		mailSelectPc.style.position			= 'absolute';
	}
}
//--></script>

<form name="cartForm" action="./cart.php?shpoi={write:shopping.order.orderObject->'order_id'}" method="post">
	<input type="hidden" name="command" value="" />
	<input type="hidden" name="cart_order" value="" />
	<input type="hidden" name="address_order" value="0" />
	<input type="hidden" name="maxAddressCount" value="1" />
</form>

<script language="JavaScript" type="text/javascript"><!--
var loadingHtml	= '<div style="text-align:center;padding:30px;"><img src="/js/images/loading_s_01.gif" /><br />now loading...</div>';
//
// {write:SHOPPING_LABEL_PRODUCT}リスト関連
// 
var shoppingOrderListHttpObject;
function shoppingOrderViewProduct() {
	shoppingOrderListHttpObject	= FormerCommon.createHttpRequest(shoppingOrderViewProductResult);
	if (shoppingOrderListHttpObject) {
		var listPanel	= document.getElementById('shopping-order-list');
		if( listPanel ) {
			listPanel.innerHTML	= loadingHtml;
		}
		var contents	= FormerCommon.createFormContents(document.sform);
		shoppingOrderListHttpObject.open("GET",'./ajax_products.php?shpoi={write:shopping.order.orderObject->'order_id'}&'+contents,true);
		shoppingOrderListHttpObject.send(null);
	}
	return false;
}
function shoppingOrderViewProductResult() {
	if ((shoppingOrderListHttpObject.readyState == 4) && (shoppingOrderListHttpObject.status == 200)){
		var listPanel	= document.getElementById('shopping-order-list');
		if( listPanel ) {
			listPanel.innerHTML	= shoppingOrderListHttpObject.responseText;
		}
	} else if ((shoppingOrderListHttpObject.readyState == 4) && (shoppingOrderListHttpObject.status != 200)){
		alert('system error!');
	}
}
//
// 買い物かご関連
//
var shoppingOrderCartHttpObject;
function shoppingOrderViewCart() {
	shoppingOrderCartHttpObject	= FormerCommon.createHttpRequest(shoppingOrderViewCartResult);
	var addressOrder	= document.cartForm.address_order.value;
	if (shoppingOrderCartHttpObject) {
		var cartPanel	= document.getElementById('shopping-order-cart');
		if( cartPanel ) {
			cartPanel.innerHTML	= loadingHtml;
		}
		shoppingOrderCartHttpObject.open("GET",'./ajax_cart.php?shpoi={write:shopping.order.orderObject->'order_id'}&addord='+addressOrder,true);
		shoppingOrderCartHttpObject.send(null);
	}
}
function shoppingOrderViewCartResult() {
	if ((shoppingOrderCartHttpObject.readyState == 4) && (shoppingOrderCartHttpObject.status == 200)){
		var cartPanel	= document.getElementById('shopping-order-cart');
		if( cartPanel ) {
			cartPanel.innerHTML	= shoppingOrderCartHttpObject.responseText;
		}
		shoppingOrderViewCartAddress();
	} else if ((shoppingOrderCartHttpObject.readyState == 4) && (shoppingOrderCartHttpObject.status != 200)){
		alert('system error!');
	}
}
function shoppingCartClear() {
	document.cartForm.command.value			='clear';
	document.cartForm.cart_order.value		='';
	document.cartForm.address_order.value	='0';
	shoppingOrderCartHttpObject	= FormerCommon.createHttpRequest(shoppingOrderViewCartResult);
	var addressOrder	= document.cartForm.address_order.value;
	var contents	= FormerCommon.createFormContents(document.cartForm);
	if( shoppingOrderCartHttpObject ) {
		var cartPanel	= document.getElementById('shopping-order-cart');
		if( cartPanel ) {
			cartPanel.innerHTML	= loadingHtml;
		}
		shoppingOrderCartHttpObject.open("POST",'./ajax_cart.php?shpoi={write:shopping.order.orderObject->'order_id'}&addord='+addressOrder,true);
		shoppingOrderCartHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingOrderCartHttpObject.send(contents);
	}
}
function shoppingCartCountDown(cartOrder,addressOrder) {
	document.cartForm.command.value	='countdown';
	document.cartForm.address_order.value	= addressOrder;
	document.cartForm.cart_order.value		= cartOrder;
	shoppingOrderCartHttpObject	= FormerCommon.createHttpRequest(shoppingOrderViewCartResult);
	var addressOrder	= document.cartForm.address_order.value;
	var contents	= FormerCommon.createFormContents(document.cartForm);
	if( shoppingOrderCartHttpObject ) {
		var cartPanel	= document.getElementById('shopping-order-cart');
		if( cartPanel ) {
			cartPanel.innerHTML	= loadingHtml;
		}
		shoppingOrderCartHttpObject.open("POST",'./ajax_cart.php?shpoi={write:shopping.order.orderObject->'order_id'}&addord='+addressOrder,true);
		shoppingOrderCartHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingOrderCartHttpObject.send(contents);
	}
}
function shoppingCartCountUp(cartOrder,addressOrder) {
	document.cartForm.command.value	='countup';
	document.cartForm.address_order.value	= addressOrder;
	document.cartForm.cart_order.value		= cartOrder;
	shoppingOrderCartHttpObject	= FormerCommon.createHttpRequest(shoppingOrderViewCartResult);
	var addressOrder	= document.cartForm.address_order.value;
	var contents	= FormerCommon.createFormContents(document.cartForm);
	if( shoppingOrderCartHttpObject ) {
		var cartPanel	= document.getElementById('shopping-order-cart');
		if( cartPanel ) {
			cartPanel.innerHTML	= loadingHtml;
		}
		shoppingOrderCartHttpObject.open("POST",'./ajax_cart.php?shpoi={write:shopping.order.orderObject->'order_id'}&addord='+addressOrder,true);
		shoppingOrderCartHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingOrderCartHttpObject.send(contents);
	}
}
function shoppingCartDrop(cartOrder,addressOrder) {
	document.cartForm.command.value	='drop';
	document.cartForm.address_order.value	= addressOrder;
	document.cartForm.cart_order.value		= cartOrder;
	shoppingOrderCartHttpObject	= FormerCommon.createHttpRequest(shoppingOrderViewCartResult);
	var addressOrder	= document.cartForm.address_order.value;
	var contents	= FormerCommon.createFormContents(document.cartForm);
	if( shoppingOrderCartHttpObject ) {
		var cartPanel	= document.getElementById('shopping-order-cart');
		if( cartPanel ) {
			cartPanel.innerHTML	= loadingHtml;
		}
		shoppingOrderCartHttpObject.open("POST",'./ajax_cart.php?shpoi={write:shopping.order.orderObject->'order_id'}&addord='+addressOrder,true);
		shoppingOrderCartHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingOrderCartHttpObject.send(contents);
	}
}
function shoppingCartAddAddress() {
	document.cartForm.command.value	='addaddress';
	shoppingOrderCartHttpObject	= FormerCommon.createHttpRequest(shoppingOrderViewCartResult);
	document.cartForm.address_order.value	= document.cartForm.maxAddressCount.value;
	var addressOrder	= document.cartForm.address_order.value;
	var contents	= FormerCommon.createFormContents(document.cartForm);
	if( shoppingOrderCartHttpObject ) {
		var cartPanel	= document.getElementById('shopping-order-cart');
		if( cartPanel ) {
			cartPanel.innerHTML	= loadingHtml;
		}
		shoppingOrderCartHttpObject.open("POST",'./ajax_cart.php?shpoi={write:shopping.order.orderObject->'order_id'}&addord='+addressOrder,true);
		shoppingOrderCartHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingOrderCartHttpObject.send(contents);
	}
}
function shoppingCartDropAddress() {
	var addressOrder	= document.cartForm.address_order.value;
	var vewOrder	= String(parseInt(addressOrder)+1);
	if( confirm('宛先'+vewOrder+'を削除します！\n宛先'+vewOrder+'に含まれる{write:SHOPPING_LABEL_PRODUCT}選択もカートから削除されます！\n削除してよろしいですか？') ) {
		document.cartForm.command.value	='dropaddress';
		shoppingOrderCartHttpObject	= FormerCommon.createHttpRequest(shoppingOrderViewCartResult);
		var contents	= FormerCommon.createFormContents(document.cartForm);
		if( shoppingOrderCartHttpObject ) {
			var cartPanel	= document.getElementById('shopping-order-cart');
			if( cartPanel ) {
				cartPanel.innerHTML	= loadingHtml;
			}
			shoppingOrderCartHttpObject.open("POST",'./ajax_cart.php?shpoi={write:shopping.order.orderObject->'order_id'}&addord='+addressOrder,true);
			shoppingOrderCartHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
			shoppingOrderCartHttpObject.send(contents);
		}
	}
}
function shoppingCartChangeAddress(addressOrder) {
	if( addressOrder < parseInt(document.cartForm.maxAddressCount.value) ) {
		document.cartForm.address_order.value	= addressOrder;
		shoppingOrderViewCart();
	}
}
function shoppingCartChangeAddressMax(maxCount) {
	document.cartForm.maxAddressCount.value = maxCount;
	if( parseInt(document.cartForm.address_order.value) >= maxCount ) {
		document.cartForm.address_order.value	= String(maxCount-1);
		shoppingOrderViewCart();
	}
}
function shoppingOrderListPageJump(pageNumber) {
	document.sform.pn.value	= pageNumber;
	shoppingOrderViewProduct();
}
function shoppingOrderCartAdd( formObject ) {
	if( formObject ) {
		var addressOrder	= document.cartForm.address_order.value;
		formObject.address_order.value	= addressOrder;
		var contents	= FormerCommon.createFormContents(formObject);
		shoppingOrderCartHttpObject	= FormerCommon.createHttpRequest(shoppingOrderViewCartResult);
		if( shoppingOrderCartHttpObject ) {
			var cartPanel	= document.getElementById('shopping-order-cart');
			if( cartPanel ) {
				cartPanel.innerHTML	= loadingHtml;
			}
			var urlPost = './ajax_cart.php?shpoi={write:shopping.order.orderObject->'order_id'}&addord='+addressOrder;
			shoppingOrderCartHttpObject.open("POST",urlPost,true);
			shoppingOrderCartHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
			shoppingOrderCartHttpObject.send(contents);
		}
	}
	shoppingOrderViewCalendarPanelClose();
}
function shoppingOrderApplyPromotion() {
	if( document.pform ) {
		var addressOrder	= document.cartForm.address_order.value;
		var contents	= FormerCommon.createFormContents(document.pform);
		shoppingOrderCartHttpObject	= FormerCommon.createHttpRequest(shoppingOrderViewCartResult);
		if( shoppingOrderCartHttpObject ) {
			shoppingOrderCartHttpObject.open("POST",'./ajax_cart.php?shpoi={write:shopping.order.orderObject->'order_id'}&addord='+addressOrder,true);
			shoppingOrderCartHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
			shoppingOrderCartHttpObject.send(contents);
		}
	}
}
//
// 宛先関連
//
var shoppingOrderCartAddressHttpObject;
function shoppingOrderViewCartAddress() {
	shoppingOrderCartAddressHttpObject	= FormerCommon.createHttpRequest(shoppingOrderViewCartAddressResult);
	if (shoppingOrderCartAddressHttpObject) {
		var addressArea	= document.getElementById('address-area');
		if( addressArea ) {
			addressArea.innerHTML	= loadingHtml;
		}
		shoppingOrderCartAddressHttpObject.open("GET",'./ajax_address.php?shpoi={write:shopping.order.orderObject->'order_id'}',true);
		shoppingOrderCartAddressHttpObject.send(null);
	}
}
function shoppingOrderViewCartAddressResult() {
	if ((shoppingOrderCartAddressHttpObject.readyState == 4) && (shoppingOrderCartAddressHttpObject.status == 200)){
		var addressArea	= document.getElementById('address-area');
		if( addressArea ) {
			addressArea.innerHTML	= shoppingOrderCartAddressHttpObject.responseText;
		}
	} else if ((shoppingOrderCartAddressHttpObject.readyState == 4) && (shoppingOrderCartAddressHttpObject.status != 200)){
		alert('system error!');
	}
}
//
// 
//
function shoppingOrderDateRenew() {
	var nowDate	= new Date();
	var month	= '0' + String(nowDate.getMonth()+1);
	var day		= '0' + nowDate.getDate();
	var hour	= '0' + nowDate.getHours();
	var min		= '0' + nowDate.getMinutes();
	var sec		= '0' + nowDate.getSeconds();
	document.orderForm.order_date.value	= nowDate.getFullYear()
		+ '-' + month.substr(month.length-2)
		+ '-' + day.substr(day.length-2)
		+ ' ' + hour.substr(hour.length-2)
		+ ':' + min.substr(min.length-2)
		+ ':' + sec.substr(sec.length-2);
}
//
// 予約用のカレンダーパネルを表示する
//
var shoppingCalendarPanel;
var shoppingCalendarHttpObject;
var shoppingCalendarToReserve	= false;
var calendarType	= 'calendar';
function shoppingOrderViewCalendarPanel( productId, unitId, calType ) {
	calendarType	= calType;
	shoppingCalendarHttpObject	= FormerCommon.createHttpRequest(shoppingOrderViewCalendarPanelResult);
	if( shoppingCalendarHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		var uri	= './ajax_calendar.php?shpui='+encodeURIComponent(unitId);
		if( 'timetable' == calendarType ) {
			uri	= './ajax_timetable.php?shpui='+encodeURIComponent(unitId);
		}
		shoppingCalendarHttpObject.open("GET",uri,true);
		shoppingCalendarHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingCalendarHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
	
}
function shoppingOrderViewCalendarPanelResult() {
	if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status == 200)){
		shoppingCalendarPanel	= document.createElement('div');
		shoppingCalendarPanel.style.position	= 'absolute';
		shoppingCalendarPanel.style.top			= '10%';
		shoppingCalendarPanel.style.left		= '20%';
		shoppingCalendarPanel.style.width		= '60%';
		shoppingCalendarPanel.style.zIndex		= '999999';
		shoppingCalendarPanel.style.backgroundColor	= '#ffffff';
		shoppingCalendarPanel.style.textAlign		= 'left';
		shoppingCalendarPanel.style.padding			= '10px';
		shoppingCalendarPanel.innerHTML			= shoppingCalendarHttpObject.responseText;
		var bodyTags 	= document.getElementsByTagName('body');
		bodyTags[0].appendChild(shoppingCalendarPanel);
	} else if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status != 200)){
		alert('カレンダー取得中にサーバー通信に失敗しました');
		setTimeout(FormerCommon.displayWhiteIn, 100);
	}
}
function shoppingOrderViewCalendarPanelClose() {
	if( shoppingCalendarPanel ) {
		var bodyTags 	= document.getElementsByTagName('body');
		bodyTags[0].removeChild(shoppingCalendarPanel);
		setTimeout(FormerCommon.displayWhiteIn, 100);
		shoppingCalendarPanel	= null;
	}
}
//
// カレンダーの年月を切り替える
//
function shoppingCalendarRenew() {
	shoppingCalendarToReserve	= false;
	shoppingCalendarPost();
}
//
// 現在の状況を保存して予約に進む
//
function shoppingCalendarGoReserve() {
	shoppingCalendarToReserve	= true;
	shoppingCalendarPost();
}
//
// カレンダー表示を更新する
//
function shoppingCalendarPost(){
	var targetYear	= document.calsform.sclty.options[document.calsform.sclty.selectedIndex].value;
	var targetMonth	= document.calsform.scltm.options[document.calsform.scltm.selectedIndex].value;
	var productId	= document.mform.product_id.value;
	var unitId		= document.mform.unit_id.value;
	var contents	= FormerCommon.createFormContents(document.mform);
	shoppingCalendarHttpObject	= FormerCommon.createHttpRequest(shoppingCalendarPostResult);
	if( shoppingCalendarHttpObject ) {
		var calendarArea	= document.getElementById('shopping-calendar-area');
		if( calendarArea ) {
			calendarArea.innerHTML	= '';
		}
		var uri	= './ajax_cal.php?sclty='+targetYear+'&scltm='+targetMonth+'&shpui='+encodeURIComponent(unitId);
		if( 'timetable' == calendarType ) {
			uri	= './ajax_tt.php?sclty='+targetYear+'&scltm='+targetMonth+'&shpui='+encodeURIComponent(unitId);
		}
		shoppingCalendarHttpObject.open("POST",uri,true);
		shoppingCalendarHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingCalendarHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingCalendarPostResult() {
	if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status == 200)){
		var calendarArea	= document.getElementById('shopping-calendar-area');
		if( calendarArea ) {
			calendarArea.innerHTML	= shoppingCalendarHttpObject.responseText;
		}
		if( shoppingCalendarToReserve ) {
			document.mform.command.value	= 'add';
			shoppingOrderCartAdd( document.mform );
		} else {
			document.mform.command.value	= '';
		}
	} else if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status != 200)){
		alert('状態変更中にサーバー通信に失敗しました');
	}
}

if(window.attachEvent){
	window.attachEvent('onload',shoppingOrderViewCart);
	window.attachEvent('onload',shoppingOrderViewProduct);
	window.attachEvent('onload',shoppingOrderViewCartAddress);
	window.attachEvent('onload',shoppingOrderChangeEmailInput);
}else{
	window.addEventListener('DOMContentLoaded',shoppingOrderViewCart,false);
	window.addEventListener('DOMContentLoaded',shoppingOrderViewProduct,false);
	window.addEventListener('DOMContentLoaded',shoppingOrderViewCartAddress,false);
	window.addEventListener('DOMContentLoaded',shoppingOrderChangeEmailInput,false);
}
//--></script>
<style type="text/css">
table.shopping-order-product-unit {
	border: none 0px #ffffff;
	width: 100%;
}
table.shopping-order-product-unit tbody tr {
	border: none 0px #ffffff;
}
table.shopping-order-product-unit tbody tr th, table.shopping-order-product-unit tbody tr td {
	border: none 0px #ffffff;
	border-bottom: dotted 1px #c0c0c0;
}
span.other-page a:link, span.other-page a:visited {
	margin-right: 1px;
	padding: 3px 6px;
	border: 1px solid #ccc;
	background: #ffffff;
	color: #333;
	font-weight: bold;
	text-decoration: none;
}
span.other-page a:hover, span.other-page a:active {
	margin-right: 1px;
	padding: 3px 6px;
	border: 1px solid #ccc;
	background: #ffe0e0;
	color: #333;
	font-weight: bold;
	text-decoration: none;
}
#address-select {
	width:100%;
	margin: 0px;
	padding: 0px;
}
#address-select li {
	display: inline-block;
	width: 4em;
	margin: 0px;
	padding: 0px;
	white-space: nowrap;
	text-align: center;
	font-size: 10px;
}
#address-select li div {
	display: block;
	padding: 3px;
	width:100%;
	text-decoration: none;
	border-right: solid 1px #000000;
	font-size: 10px;
}
#address-select li a {
	display: block;
	padding: 3px;
	width:100%;
	text-decoration: none;
	border-right: solid 1px #000000;
}
#address-select li a:link, #address-select li a:visited  {
	background-color: #808080;
	color: #ffffff;
}
#address-select li a:hover {
	background-color: #c0c0c0;
	color: #000000;
}
</style>