<?php include_once( "../../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.order.CartAdmin}
{module:shopping.order.step.Form}
{module:shopping.order.step.ConfirmAll}
{module:shopping.order.Optimize}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_ORDER . '情報編集 > 編集内容の確認'}

	<div class="panc">
		<a href="../../../">管理パネルトップ</a>
		&gt; <a href="../../">ショップ管理</a>
		&gt; <a href="../">{write:SHOPPING_LABEL_ORDER}一覧</a>
		&gt; {write:SHOPPING_LABEL_ORDER}編集：{write:SHOPPING_LABEL_ORDER}内容の確認
	</div><br />

	<h1>{write:SHOPPING_LABEL_ORDER}編集{write:shopping.order.orderObject->'order_id'}:{write:SHOPPING_LABEL_ORDER}内容の確認</h1>
	
	<div style="clear:both;width:95%;margin:0 auto;border:dotted 1px #999;background-color:#eee;color:#696969;text-align:center;padding:5px;">
		<a href="./purchaser.php?shpoi={write:shopping.order.orderObject->'order_id'}">{write:SHOPPING_LABEL_PRODUCT}選択・お届け先の入力</a>
		&gt;
		<a href="./settlement.php?shpoi={write:shopping.order.orderObject->'order_id'}">お支払い方法の指定</a>
		&gt;
		<span style="font-weight:bold;">{write:SHOPPING_LABEL_ORDER}内容の確認</span>
		&gt;
		{write:SHOPPING_LABEL_ORDER}完了
	</div><br />
	
	<p>
		ご{write:SHOPPING_LABEL_ORDER}内容とご入力内容を確認して問題なければページ下部の「この内容で申し込む」ボタンをクリックしてください。
	</p>
	{if:IS_ERROR}
		<ul class="error">
		{foreach:errors error}
			<li>{write:error}</li>
		{/foreach}
		</ul>
		<p>
			<a href="./purchaser.php?shpoi={write:shopping.order.orderObject->'order_id'}">お届け先の入力画面に戻る</a>
			<a href="./settlement.php?shpoi={write:shopping.order.orderObject->'order_id'}">お支払いのご指定画面に戻る</a>
		</p>
	{else-if:shopping.order.orderObject->getAllItemCount(request)==0}
		<p>
			{write:SHOPPING_LABEL_ORDER}内容がないか時間切れになりました。お手数ですが最初から選択してください。
		</p>
	{else}

	<div class="admin_cart">
	<h2>{write:MEMBER_PERSONAL_LABEL}情報</h2>
	{set:memberObject shopping.order.orderObject->'memberObject'}
	<table>
	<tbody>
	<tr>
		<th>お名前</th>
		<td>{write:memberObject->'family_name'} {write:memberObject->'first_name'}</td>
	</tr>
	<tr>
		<th>フリガナ</th>
		<td>{write:memberObject->'family_kana'} {write:memberObject->'first_kana'}</td>
	</tr>
	<tr>
		<th>メールアドレス</th>
		<td>{write:memberObject->'email'}</td>
	</tr>
	<tr>
		<th>ご住所</th>
		<td>
			〒{write:memberObject->'zip_code'}
			{if:strlen(memberObject->'prefecture_number')>0}{write:PREFECTURE_HASH[memberObject->'prefecture_number']}{/if}
			{write:memberObject->'address'}
			{write:memberObject->'building'}
		</td>
	</tr>
	<tr>
		<th>お電話番号</th>
		<td>{write:memberObject->'telephone_number'}</td>
	</tr>
	<tr>
		<th>FAX番号</th>
		<td>{write:memberObject->'faximili_number'}</td>
	</tr>
	<tr>
		<th>携帯電話番号</th>
		<td>{write:memberObject->'mobile_number'}</td>
	</tr>
	</tbody>
	</table>
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="./purchaser.php?shpoi={write:shopping.order.orderObject->'order_id'}">&gt;&gt; 入力しなおす</a>
	</div>
	<br />
	
	{if:in_array('zip_code2',MEMBER_REGIST_ITEM) || in_array('prefecture2',MEMBER_REGIST_ITEM) || in_array('address2',MEMBER_REGIST_ITEM) || in_array('telephone2',MEMBER_REGIST_ITEM) || in_array('faximili2',MEMBER_REGIST_ITEM)}
	<h2>ご連絡先２</h2>
	<table>
	<tbody>
	<tr>
		<th>ご住所</th>
		<td>
			〒{write:memberObject->'zip_code2'}
			{if:strlen(memberObject->'prefecture_number2')>0}{write:PREFECTURE_HASH[memberObject->'prefecture_number2']}{/if}
			{write:memberObject->'address2'}
			{write:memberObject->'building2'}
		</td>
	</tr>
	{if:in_array('telephone2',MEMBER_REGIST_ITEM)}
	<tr>
		<th>電話番号</th>
		<td>{write:memberObject->'telephone_number2'}</td>
	</tr>
	{/if}
	{if:in_array('faximili2',MEMBER_REGIST_ITEM)}
	<tr>
		<th>FAX番号</th>
		<td>{write:memberObject->'faximili_number2'}</td>
	</tr>
	{/if}
	</tbody>
	</table>
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="./purchaser.php?shpoi={write:shopping.order.orderObject->'order_id'}">&gt;&gt; 入力しなおす</a>
	</div><br />
	{/if}
	
	{if:in_array('company_name',MEMBER_REGIST_ITEM) || in_array('section_name',MEMBER_REGIST_ITEM)}
	<h2>お勤め先</h2>
	<table>
	<tbody>
	{if:in_array('company_name',MEMBER_REGIST_ITEM)}
	<tr>
		<th>会社名</th>
		<td>{write:memberObject->'company_name'}</td>
	</tr>
	{/if}
	{if:in_array('section_name',MEMBER_REGIST_ITEM)}
	<tr>
		<th>部署名</th>
		<td>{write:memberObject->'section_name'}</td>
	</tr>
	{/if}
	</tbody>
	</table>
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="./purchaser.php?shpoi={write:shopping.order.orderObject->'order_id'}">&gt;&gt; 入力しなおす</a>
	</div><br />
	{/if}
	
	{if:in_array('sex',MEMBER_REGIST_ITEM) || in_array('birth_year',MEMBER_REGIST_ITEM) || in_array('birth_month',MEMBER_REGIST_ITEM) || in_array('birth_day',MEMBER_REGIST_ITEM) || in_array('blood_type',MEMBER_REGIST_ITEM)}
	<h2>プロフィール</h2>
	<table>
	<tbody>
	{if:in_array('sex',MEMBER_REGIST_ITEM)}
	<tr>
		<th>性別</th>
		<td>{write:MEMBER_MEMBER_SEX_HASH[memberObject->'sex']}</td>
	</tr>
	{/if}
	{if:in_array('birth_year',MEMBER_REGIST_ITEM) || in_array('birth_month',MEMBER_REGIST_ITEM) || in_array('birth_day',MEMBER_REGIST_ITEM)}
	<tr>
		<th>生年月日</th>
		<td>
			{if:in_array('birth_year',MEMBER_REGIST_ITEM)}
			西暦 {write:memberObject->'birth_year'}年
			{/if}
			{if:in_array('birth_month',MEMBER_REGIST_ITEM)}
				{write:memberObject->'birth_month'}月
			{/if}
			{if:in_array('birth_day',MEMBER_REGIST_ITEM)}
				{write:memberObject->'birth_day'}日
			{/if}
		</td>
	</tr>
	{/if}
	{if:in_array('blood_type',MEMBER_REGIST_ITEM)}
	<tr>
		<th>血液型</th>
		<td>{write:MEMBER_MEMBER_BLOOD_TYPE_HASH[memberObject->'blood_type']}型</td>
	</tr>
	{/if}
	</tbody>
	</table>
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="./purchaser.php?shpoi={write:shopping.order.orderObject->'order_id'}">&gt;&gt; 入力しなおす</a>
	</div><br />
	{/if}
	</div>
	
	<div class="admin_cart">
	{foreach:shopping.order.orderObject::shoppingOrderAddressObjectArray addressOrder shoppingOrderAddressObject}
	<h2>宛先{write:(addressOrder+1)}の{write:SHOPPING_LABEL_ORDER}内容</h2>
	
	<table>
	<tr>
		<th>お名前</th>
		<td>{write:shoppingOrderAddressObject->'address_name'} ({write:shoppingOrderAddressObject->'address_kana'})</td>
	</tr>
	<tr>
		<th>宛先住所</th>
		<td>
			〒{write:shoppingOrderAddressObject->'zip_code'}
			{if:strlen(shoppingOrderAddressObject->'prefecture_number')>0}{write:PREFECTURE_HASH[shoppingOrderAddressObject->'prefecture_number']}{/if}
			{write:shoppingOrderAddressObject->'address'}
			{write:shoppingOrderAddressObject->'building'}
			<br />
			電話番号: {write:shoppingOrderAddressObject->'telephone_number'}
		</td>
	</tr>
	<tr>
		<th>お届け希望日時</th>
		<td>
			{if:strlen(shopping.order.deliveryWishfulDayStart)>0 && strlen(shopping.order.deliveryWishfulDayEnd)>0 && shopping.order.deliveryWishfulDayStart>0 && shopping.order.deliveryWishfulDayEnd>0 && strlen(shoppingOrderAddressObject->'wishful_date')>0}
			{write:shoppingOrderAddressObject->'wishful_date'}
			{/if}
			{write:shoppingOrderAddressObject->'wishful_time'}
		</td>
	</tr>
	{if:count(shopping.order.deliveryRappingHash)>0}
	<tr>
		<th>包装</th>
		<td>
			{write:shoppingOrderAddressObject->'wrapping_type'}
			{write:shoppingOrderAddressObject->'wrapping_words1'}
			{write:shoppingOrderAddressObject->'wrapping_words2'}
		</td>
	</tr>
	{/if}
	<tr>
		<th>配送伝票番号</th>
		<td>{write:shoppingOrderAddressObject->'delivery_code' nl2br}</td>
	</tr>
	</table>
	<br />
	<table>
	<thead>
	<tr>
		<th colspan="2">情報</th>
		<th>単価</th>
		<th>個数</th>
		<th>金額</th>
	</tr>
	</thead>
	<tbody>
	{foreach:shoppingOrderAddressObject::shoppingOrderItemObjectArray itemOrder shoppingOrderItemObject}
	{set:unitObject shoppingOrderItemObject->'shoppingProductUnitObject'}
	{set:productObject unitObject->'shoppingProductObject'}
	<tr>
		<td{if:is_array(shoppingOrderItemObject->'shoppingOrderOptionObjectArray')}
			rowspan="{write:count(shoppingOrderItemObject->'shoppingOrderOptionObjectArray')+1}"
		{/if}>
		{set:fileIdArray productObject::fileIdArray}
		{if:strlen(fileIdArray[0])>0}
			<a href="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/shopping/product/unit/detail.php?shpdi={write:unitObject->'unit_id'}" target="_blank"
			><img src="/file/download.php?fi={write:fileIdArray[0]}&amp;w=45&amp;h=45" /></a><br />
		{else}
			<table style="width:45px;height:45px;margin:0 auto;">
			<tbody>
			<tr>
				<td style="vertical-align:middle;text-align:center;font-size:9px;"
					><a href="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/shopping/product/unit/detail.php?shpdi={write:unitObject->'unit_id'}" target="_blank"
					>画像<br />なし</a></td>
			</tr>
			</tbody>
			</table>
		{/if}
		</td>
		<td>
			{write:productObject->'product_name'} {write:unitObject->'unit_name'}<br />
			{if:900==unitObject->'delivery_type'}
				チェックイン:{write:date('Y年m月d日',strtotime(shoppingOrderItemObject->'svc_start_date'))}<br />
				チェックアウト:{write:date('Y年m月d日',strtotime(shoppingOrderItemObject->'svc_limit_date'))}<br />
				&yen;{write:number_format(shoppingOrderItemObject->'price_unit')}×{write:ceil((strtotime(shoppingOrderItemObject->'svc_limit_date')-strtotime(shoppingOrderItemObject->'svc_start_date'))/(60*60*24))}泊
			{else-if:200<=unitObject->'delivery_type'}
				{write:date('Y年m月d日',strtotime(shoppingOrderItemObject->'svc_start_date'))} 単価&yen;{write:number_format(shoppingOrderItemObject->'price_unit')}<br />
				{write:date('H:i',strtotime(shoppingOrderItemObject->'svc_start_date'))}～{write:date('H:i',strtotime(shoppingOrderItemObject->'svc_limit_date'))}
				<br />
			{else}
			
			{/if}
		</td>
		<td style="text-align:right;white-space:nowrap;">&yen;{write:number_format(shoppingOrderItemObject->'price_unit')}</td>
		<td style="text-align:right;white-space:nowrap;">{write:shoppingOrderItemObject->'order_count'}</td>
		<td style="text-align:right;white-space:nowrap;">&yen;{write:number_format(shoppingOrderItemObject->getTotalUnitPrice( request ))}</td>
	</tr>
	{if:is_array(shoppingOrderItemObject->'shoppingOrderOptionObjectArray')}
	{foreach:shoppingOrderItemObject::shoppingOrderOptionObjectArray optionOrder shoppingOrderOptionObject}
	<tr>
		<td style="border-top:dotted 1px #a0a0a0;border-bottom:none;">{write:shoppingOrderOptionObject->'option_name'}:{write:shoppingOrderOptionObject->'option_value' nl2br}</td>
		<td style="border-top:dotted 1px #a0a0a0;border-bottom:none;text-align:right;white-space:nowrap;">&yen;{write:number_format(shoppingOrderOptionObject->'option_price')}</td>
		<td style="border-top:dotted 1px #a0a0a0;border-bottom:none;text-align:right;white-space:nowrap;">{write:shoppingOrderOptionObject->'order_count'}</td>
		<td style="border-top:dotted 1px #a0a0a0;border-bottom:none;text-align:right;white-space:nowrap;">&yen;{write:number_format(shoppingOrderOptionObject->getTotalPrice( request ))}</td>
	</tr>
	{/foreach}
	{/if}
	{/foreach}
	<tr>
		<th colspan="4" style="text-align:right;">{write:SHOPPING_LABEL_PRODUCT}計(税込)</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;background-color:#eee;">
			&yen;{write:number_format(shoppingOrderAddressObject->getTotalPaymentPrice(request))}
		</td>
	</tr>
	<tr>
		<th colspan="4" style="text-align:right;">送料</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;background-color:#eee;">
			&yen;{write:number_format(shoppingOrderAddressObject->'delivery_price')}
		</td>
	</tr>
	{if:shoppingOrderAddressObject->'wrapping_price'>0}
	<tr>
		<th colspan="4" style="text-align:right;">包装代</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;background-color:#eee;">
			&yen;{write:number_format(shoppingOrderAddressObject->'wrapping_price')}
		</td>
	</tr>
	{/if}
	{if:shoppingOrderAddressObject->'settle_fee'>0}
	<tr>
		<th colspan="4" style="text-align:right;">決済手数料</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;background-color:#eee;">
			&yen;{write:number_format(shoppingOrderAddressObject->'settle_fee')}
		</td>
	</tr>
	{/if}
	<tr>
		<th colspan="4" style="text-align:right;">小計(税込)</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;background-color:#eee;">
			&yen;{write:number_format(shoppingOrderAddressObject->getTotalPaymentPrice(request) + shoppingOrderAddressObject->'delivery_price' + shoppingOrderAddressObject->'wrapping_price' + shoppingOrderAddressObject->'settle_fee')}
		</td>
	</tr>
	</tbody>
	</table>
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="./purchaser.php?shpoi={write:shopping.order.orderObject->'order_id'}">&gt;&gt; 入力しなおす</a>
	</div>
	<br />
	{/foreach}

	{if:is_array(shopping.order.orderObject->'shoppingOrderOptionObjectArray') && count(shopping.order.orderObject->'shoppingOrderOptionObjectArray')>0}
	<h2>ご{write:SHOPPING_LABEL_ORDER}オプション</h2>
	<table>
	<tbody>
	{foreach:shopping.order.orderObject::shoppingOrderOptionObjectArray optionOrder shoppingOrderOptionObject}
	<tr>
		<th>{write:shoppingOrderOptionObject->'option_name'}</th>
		<td>{write:shoppingOrderOptionObject->'option_value' nl2br}</td>
		<td style="text-align:right;white-space:nowrap;">&yen;{write:number_format(shoppingOrderOptionObject->getTotalPrice( request ))}</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="./purchaser.php?shpoi={write:shopping.order.orderObject->'order_id'}">&gt;&gt; 入力しなおす</a>
	</div>
	{/if}
	
	<h2>お支払金額</h2>
	<table>
	<tbody>
	<tr>
		<th style="text-align:right;width:82%;">小計(税込)</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;">
			&yen;{write:number_format(shopping.order.orderObject->'price_total')}
		</td>
	</tr>
	<tr>
		<th style="text-align:right;">送料</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;">
			&yen;{write:number_format(shopping.order.orderObject->'delivery_price')}
		</td>
	</tr>
	{if:shopping.order.orderObject->'wrapping_price'>0}
	<tr>
		<th style="text-align:right;">包装代</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;">
			&yen;{write:number_format(shopping.order.orderObject->'wrapping_price')}
		</td>
	</tr>
	{/if}
	{if:shopping.order.orderObject->'delivery_price'>0}
	<tr>
		<th style="text-align:right;">配送料</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;">
			&yen;{write:number_format(shopping.order.orderObject->'delivery_price')}
		</td>
	</tr>
	{/if}
	{if:shopping.order.orderObject->'point_use'>0}
	<tr>
		<th style="text-align:right;">利用ポイント</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;color:#ff0000;">
			-&yen;{write:number_format(shopping.order.orderObject->'point_use')}
		</td>
	</tr>
	{/if}
	{if:shopping.order.orderObject->'point_total'>0}
	<tr>
		<th style="text-align:right;">発生ポイント</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;">
			+{write:number_format(shopping.order.orderObject->'point_total')}
		</td>
	</tr>
	{/if}
	{if:shopping.order.orderObject->'discount_price'>0}
	<tr>
		<th style="text-align:right;">
			{if:strlen(shopping.order.promotionInformation->'promotion_name')>0}{write:shopping.order.promotionInformation->'promotion_name'}様からの{/if}ご紹介割引
		</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;color:#ff0000;">
			-&yen;{write:number_format(shopping.order.orderObject->'discount_price')}
		</td>
	</tr>
	{/if}
	{if:shopping.order.orderObject->'settle_fee'>0}
	<tr>
		<th style="text-align:right;">決済手数料計</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;">
			&yen;{write:number_format(shopping.order.orderObject->'settle_fee')}
		</td>
	</tr>
	{/if}
	</tbody>
	</table>
	<div style="width:95%;margin:0 auto;text-align:right;margin-top:5px;font-size:20px;text-decoration:underline;">
		お客様合計お支払額(税込):
		&nbsp;&nbsp;
		<span style="font-weight:bold;color:#008000;">&yen;{write:number_format(shopping.order.orderObject->'payment_total')}-</span>
	</div>
	
	<br />
	</div>
		
	<form name="orderForm" action="./execute.php?shpoi={write:shopping.order.orderObject->'order_id'}" method="POST">

	<input type="hidden" name="command" value="confirm" />
	
	<div class="admin_orderform">

	{if:system.login.is_login && strlen(memberObject->'member_number')>0 && memberObject->'member_class_org' > 0}
	{else}
	<h2>会員登録</h2>
	<p>
		{if:memberObject->'member_class'==1}規約に同意して会員登録する{else}会員登録しない{/if}
	</p>
	{/if}

	<h2>お支払い方法</h2>
	<table style="width:95%;margin:0 auto;border-collapse:collapse;border:solid 1px #e0e0e0;">
	<tbody>
	{foreach:shopping.order.settlement.methodObjectArray settleMethodObject}
	{if:shopping.order.orderObject->'settle_method'==settleMethodObject->getMethodNumber()}
	{set:selecteSettleMethodObject settleMethodObject}
	<tr>
		<td style="width:10em;border:solid 1px #e0e0e0;vertical-align:top;padding:5px;">
			{write:settleMethodObject->getMethodViewName()}
		</td>
		<td style="border:solid 1px #e0e0e0;padding:5px;">
			{write:settleMethodObject->getMethodExplanation() noescape}
		</td>
	</tr>
	{/if}{/foreach}
	</tbody>
	</table>
	<p style="text-align:right;">
		<a href="./settlement.php?shpoi={write:shopping.order.orderObject->'order_id'}">&gt;&gt; 入力しなおす</a>
	</p>
	
	{if:strlen(shopping.order.orderObject->'order_comment')>0}
	<h2>その他・通信欄</h2>
	<p style="width:95%;margin:0 auto;">
		{write:shopping.order.orderObject->'order_comment' nl2br}
	</p>
	<p style="text-align:right;">
		<a href="./settlement.php?shpoi={write:shopping.order.orderObject->'order_id'}">&gt;&gt; 入力しなおす</a>
	</p>
	{/if}

	<h2>{write:SHOPPING_LABEL_ORDER}管理情報</h2>
	<table>
	<tbody>
	<tr>
		<th>{write:SHOPPING_LABEL_ORDER}日時</th>
		<td>{write:shopping.order.orderObject->'order_date'}</td>
	</tr>
	<tr>
		<th>管理者メモ</th>
		<td>{write:shopping.order.orderObject->'admin_note' nl2br}</td>
	</tr>
	</tbody>
	</table><br />
	
	<p style="text-align:center;color:#f00000;">
		{write:selecteSettleMethodObject->getConfirmAttention() noescape}
	</p>
	
	<div style="text-align:center;margin:0 auto;">
		<input type="submit" value="この内容で{write:SHOPPING_LABEL_ORDER}変更" style="padding:5px;text-align:center;background-color:#DFDFDF;border-style:solid;border-width:1px;" />
	</div><br />
	</div>
	</form>

	{/if}
