<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:system.login.Require}
{module:shopping.category.LoadList}
{module:shopping.order.settlement.LoadList}
{module:shopping.order.LoadList}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_ORDER . '一覧と検索'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">ショップ管理</a>
		&gt; {write:SHOPPING_LABEL_ORDER}一覧
	</div>

	<h1>
		ショップ管理 &gt;
		{if:is_object(shopping.order.memberObject)}
		{write:shopping.order.memberObject->'view_name'}さんの
		{/if}
		{write:SHOPPING_LABEL_ORDER}一覧
	</h1>
	{if:is_object(shopping.order.memberObject)}
	<div style="width:95%;margin:0 auto;text-align:right;">
		<a href="../../member/member/detail.php?mi={write:shopping.order.memberObject->'member_id'}">{write:shopping.order.memberObject->'view_name'}さんの詳細情報に戻る</a>
	</div>
	{/if}
	{if:IS_ERROR}
		<ul class="error">
		{foreach:errors error}
			<li>{write:error}</li>
		{/foreach}
	</ul>
	{/if}

	<form name="sform" action="./index.php" method="get">
	<input type="hidden" name="shpmi" value="{write:shopping.order.memberId}" />
	<input type="hidden" name="pn" value="{write:shopping.order.pageNumber}" />
	<table style="margin:0 auto;width:96%;">
	<tbody>
	<tr>
		<td style="line-height:2em;vertical-align:top;">
			<span style="white-space:nowrap;">{write:SHOPPING_LABEL_ORDER}日：<select name="shpsy">
			<?php for( $i=date('Y'); $i>date('Y')-10; $i-- ) { $request->setAttribute('page.year',$i); ?>
				<option value="{write:page.year}"{if:page.year==shopping.order.startYear} selected{/if}>{write:page.year}</option>
			<?php } ?>
			</select>年<select name="shpsm">
			<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('page.month',$i); ?>
				<option value="{write:page.month}"{if:page.month==shopping.order.startMonth} selected{/if}>{write:page.month}</option>
			<?php } ?>
			</select>月<select name="shpsd">
			<?php for( $i=1; $i<=31; $i++ ) { $request->setAttribute('page.day',$i); ?>
				<option value="{write:page.day}"{if:page.day==shopping.order.startDay} selected{/if}>{write:page.day}</option>
			<?php } ?>
			</select>日～<select name="shpey">
			<?php for( $i=date('Y'); $i>date('Y')-10; $i-- ) { $request->setAttribute('page.year',$i); ?>
				<option value="{write:page.year}"{if:page.year==shopping.order.endYear} selected{/if}>{write:page.year}</option>
			<?php } ?>
			</select>年<select name="shpem">
			<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('page.month',$i); ?>
				<option value="{write:page.month}"{if:page.month==shopping.order.endMonth} selected{/if}>{write:page.month}</option>
			<?php } ?>
			</select>月<select name="shped">
			<?php for( $i=1; $i<=31; $i++ ) { $request->setAttribute('page.day',$i); ?>
				<option value="{write:page.day}"{if:page.day==shopping.order.endDay} selected{/if}>{write:page.day}</option>
			<?php } ?>
			</select>日</span>
			<span style="white-space:nowrap;">検索ワード：<input type="text" name="shoq" value="{write:shopping.order.query}" /><input type="submit" value="検索実行" /></span><br />
			<a id="searchCondChange" href="javascript:changeViewSearchCondition()" style="font-size:x-small;">▼詳細条件を表示</a>
<script type="text/javascript"><!--
function changeViewSearchCondition() {
	var searchCondLink	= document.getElementById('searchCondChange');
	var searchCond		= document.getElementById('shopping-search-detail');
	if( searchCond && searchCondLink ) {
		if( searchCond.style.visibility == 'hidden' ) {
			searchCond.style.display = 'block';
			searchCond.style.visibility = 'visible';
			searchCond.style.position = 'static';
		} else {
			searchCond.style.display = 'none';
			searchCond.style.visibility = 'hidden';
			searchCond.style.position = 'absolute';
		}
	}
}
//--></script>
		<div id="shopping-search-detail" style="display:none;visibility:hidden;position:absolute;">
			<span style="white-space:nowrap;">{write:SHOPPING_LABEL_ORDER}状態：<select name="shpstf">
				<option value="">全ての状態</option>
				{foreach:SHOPPING_ORDER_STATUS_HASH key val}
				<option value="{write:key}"
					{if:strlen(shopping.order.statusFlag)>0 && key==shopping.order.statusFlag} selected{/if}
					>{write:val}</option>
				{/foreach}
			</select></span>
			<span style="white-space:nowrap;">決済状態：<select name="shpstsettle">
				<option value="">全ての状態</option>
				{foreach:SHOPPING_ORDER_STATUS_SETTLE_HASH key val}
				<option value="{write:key}"
					{if:strlen(shopping.order.statusSettle)>0 && key==shopping.order.statusSettle} selected{/if}
					>{write:val}</option>
				{/foreach}
			</select></span>
			<span style="white-space:nowrap;">決済方法：<select name="shpsettle">
				<option value="">全て</option>
				{foreach:shopping.order.settlement.methodObjectArray settleMethodObject}
				<option value="{write:settleMethodObject->getMethodNumber()}"
					{if:strlen(shopping.order.settleMethod)>0 && settleMethodObject->getMethodNumber()==shopping.order.settleMethod} selected{/if}
					>{write:settleMethodObject->getMethodViewName()}</option>
					{if:settleMethodObject->enableSynchronize() && settleMethodObject->'enable'}{set:page.enableSynchronize 'true'}{/if}
				{/foreach}
			</select></span>
			<span style="white-space:nowrap;">{write:SHOPPING_LABEL_PRODUCT}登録会員ID:<input type="text" size="8" name="shpiom" value="{write:shopping.order.unitOwnerId}" /></span>
			<span style="white-space:nowrap;">{write:SHOPPING_LABEL_PRODUCT}・販売単位ID：<input type="text" name="shoppq" size="15" value="{write:shopping.order.productQuery}" /></span>

			<span style="white-space:nowrap;">プロモーションID：<input type="text" name="shppc" size="15" value="{write:shopping.order.promotionCode}" /></span>
			<span style="white-space:nowrap;">プロモーション状態：<select name="shpstpromo">
				<option value="">全ての状態</option>
				{foreach:SHOPPING_ORDER_STATUS_PROMOTION_HASH key val}
				<option value="{write:key}"
					{if:strlen(shopping.order.statusPromotion)>0 && key==shopping.order.statusPromotion} selected{/if}
					>{write:val}</option>
				{/foreach}
			</select></span>
			<br />
			<span style="white-space:nowrap;">サービス開始予定日：<select name="shpsvcssy">
				<option value="">-</option>
			<?php for( $i=date('Y')+3; $i>date('Y')-3; $i-- ) { $request->setAttribute('page.year',$i); ?>
				<option value="{write:page.year}"{if:page.year==shopping.order.svcStartStartYear} selected{/if}>{write:page.year}</option>
			<?php } ?>
			</select>年<select name="shpsvcssm">
				<option value="">-</option>
			<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('page.month',$i); ?>
				<option value="{write:page.month}"{if:page.month==shopping.order.svcStartStartMonth} selected{/if}>{write:page.month}</option>
			<?php } ?>
			</select>月<select name="shpsvcssd">
				<option value="">-</option>
			<?php for( $i=1; $i<=31; $i++ ) { $request->setAttribute('page.day',$i); ?>
				<option value="{write:page.day}"{if:page.day==shopping.order.svcStartStartDay} selected{/if}>{write:page.day}</option>
			<?php } ?>
			</select>日～<select name="shpsvcsey">
				<option value="">-</option>
			<?php for( $i=date('Y')+3; $i>date('Y')-3; $i-- ) { $request->setAttribute('page.year',$i); ?>
				<option value="{write:page.year}"{if:page.year==shopping.order.svcStartEndYear} selected{/if}>{write:page.year}</option>
			<?php } ?>
			</select>年<select name="shpsvcsem">
				<option value="">-</option>
			<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('page.month',$i); ?>
				<option value="{write:page.month}"{if:page.month==shopping.order.svcStartEndMonth} selected{/if}>{write:page.month}</option>
			<?php } ?>
			</select>月<select name="shpsvcsed">
				<option value="">-</option>
			<?php for( $i=1; $i<=31; $i++ ) { $request->setAttribute('page.day',$i); ?>
				<option value="{write:page.day}"{if:page.day==shopping.order.svcStartEndDay} selected{/if}>{write:page.day}</option>
			<?php } ?>
			</select>日</span>
			<span style="white-space:nowrap;">サービス終了予定日：<select name="shpsvclsy">
				<option value="">-</option>
			<?php for( $i=date('Y')+3; $i>date('Y')-3; $i-- ) { $request->setAttribute('page.year',$i); ?>
				<option value="{write:page.year}"{if:page.year==shopping.order.svcLimitStartYear} selected{/if}>{write:page.year}</option>
			<?php } ?>
			</select>年<select name="shpsvclsm">
				<option value="">-</option>
			<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('page.month',$i); ?>
				<option value="{write:page.month}"{if:page.month==shopping.order.svcLimitStartMonth} selected{/if}>{write:page.month}</option>
			<?php } ?>
			</select>月<select name="shpsvclsd">
				<option value="">-</option>
			<?php for( $i=1; $i<=31; $i++ ) { $request->setAttribute('page.day',$i); ?>
				<option value="{write:page.day}"{if:page.day==shopping.order.svcLimitStartDay} selected{/if}>{write:page.day}</option>
			<?php } ?>
			</select>日～<select name="shpsvcley">
				<option value="">-</option>
			<?php for( $i=date('Y')+3; $i>date('Y')-3; $i-- ) { $request->setAttribute('page.year',$i); ?>
				<option value="{write:page.year}"{if:page.year==shopping.order.svcLimitLimitYear} selected{/if}>{write:page.year}</option>
			<?php } ?>
			</select>年<select name="shpsvclem">
				<option value="">-</option>
			<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('page.month',$i); ?>
				<option value="{write:page.month}"{if:page.month==shopping.order.svcLimitLimitMonth} selected{/if}>{write:page.month}</option>
			<?php } ?>
			</select>月<select name="shpsvcled">
				<option value="">-</option>
			<?php for( $i=1; $i<=31; $i++ ) { $request->setAttribute('page.day',$i); ?>
				<option value="{write:page.day}"{if:page.day==shopping.order.svcLimitLimitDay} selected{/if}>{write:page.day}</option>
			<?php } ?>
			</select>日</span>
			<br />
			<span style="white-space:nowrap;">▼メール配信日：<br />
			<select name="shphstmsy">
				<option value="">-</option>
			<?php for( $i=date('Y'); $i>date('Y')-3; $i-- ) { $request->setAttribute('page.year',$i); ?>
				<option value="{write:page.year}"{if:page.year==shopping.order.historyMailStartYear} selected{/if}>{write:page.year}</option>
			<?php } ?>
			</select>年<select name="shphstmsm">
				<option value="">-</option>
			<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('page.month',$i); ?>
				<option value="{write:page.month}"{if:page.month==shopping.order.historyMailStartMonth} selected{/if}>{write:page.month}</option>
			<?php } ?>
			</select>月<select name="shphstmsd">
				<option value="">-</option>
			<?php for( $i=1; $i<=31; $i++ ) { $request->setAttribute('page.day',$i); ?>
				<option value="{write:page.day}"{if:page.day==shopping.order.historyMailStartDay} selected{/if}>{write:page.day}</option>
			<?php } ?>
			</select>日～<select name="shphstmey">
				<option value="">-</option>
			<?php for( $i=date('Y'); $i>date('Y')-3; $i-- ) { $request->setAttribute('page.year',$i); ?>
				<option value="{write:page.year}"{if:page.year==shopping.order.historyMailLimitYear} selected{/if}>{write:page.year}</option>
			<?php } ?>
			</select>年<select name="shphstmem">
				<option value="">-</option>
			<?php for( $i=1; $i<=12; $i++ ) { $request->setAttribute('page.month',$i); ?>
				<option value="{write:page.month}"{if:page.month==shopping.order.historyMailLimitMonth} selected{/if}>{write:page.month}</option>
			<?php } ?>
			</select>月<select name="shphstmed">
				<option value="">-</option>
			<?php for( $i=1; $i<=31; $i++ ) { $request->setAttribute('page.day',$i); ?>
				<option value="{write:page.day}"{if:page.day==shopping.order.historyMailLimitDay} selected{/if}>{write:page.day}</option>
			<?php } ?>
			</select>日に<br />
			<select name="shpmailt">
				<option value=""></option>
				{foreach:member.mail.template.data_array mailTemplateObject}{if:mailTemplateObject->'template_type'!='1'}
				<option value="{write:mailTemplateObject->'template_id'}"
				{if:shopping.order.mailTemplateId==mailTemplateObject->'template_id'} selected{/if}
				>{write:mailTemplateObject->'template_name'}</option>
				{/if}{/foreach}
			</select>で送信履歴がある</span>
		</div>
		</td>
	</tr>
	</tbody>
	</table>
	<div style="margin:0 auto;width:96%;text-align:right;">
		<input type="button" value="{write:SHOPPING_LABEL_ORDER}追加" onclick="shopping_add_order()"
		/><input type="button" value="CSVダウンロード" onclick="window.location.href='./download/form.php';"
		/><br />{if:page.enableSynchronize=='true'}<input type="button" value="決済状態一括同期" onclick="settleSynchronizeExecuteAll()"
		/><br />{/if}
	</div>
	<div style="margin:0 auto;width:96%;">
		<div style="width:20%;float:left;">
			{write:shopping.order.totalCount}件の{write:SHOPPING_LABEL_ORDER}
		</div>
		<div style="width:50%;float:right;text-align:right;">
			<?php for ( $key=0;$key<1;$key++ ) { $request_object->setAttribute('key',$key); ?>
			並替項目<?php echo $key+1; ?>：<select name="shpsi[]" onchange="document.sform.submit();">
				{if:key>0}<option value=""{if:strlen(shopping.order.sortItems[key])=0} selected{/if}></option>{/if}
				<option value="order_date"{if:shopping.order.sortItems[key]=='order_date'} selected{/if}>{write:SHOPPING_LABEL_ORDER}日</option>
				<option value="registered_date"{if:shopping.order.sortItems[key]=='registered_date'} selected{/if}>登録日</option>
				<option value="updated_date"{if:shopping.order.sortItems[key]=='updated_date'} selected{/if}>更新日</option>
				<option value="order_id"{if:shopping.order.sortItems[key]=='order_id'} selected{/if}>{write:SHOPPING_LABEL_ORDER}ID</option>
			</select>
			並び順 <select name="shpso[]" onchange="document.sform.submit();">
				<option value="ASC"{if:shopping.order.sortOrders[key]='ASC'} selected{/if}>昇順</option>
				<option value="DESC"{if:shopping.order.sortOrders[key]='DESC' or strlen(shopping.order.sortItems[key])==0} selected{/if}>降順</option>
			</select><br />
			<?php } ?>
		</div>
	</div>
	</form>
	
	<table class="list" style="margin:0 auto;width:96%;">
	<tbody>
	<tr>
		<th>情報</th>
		<th>{write:SHOPPING_LABEL_ORDER}内容</th>
		<th style="width:8em;">状態</th>
	</tr>
	{foreach:shopping.order.data_array orderObject}
	{set:page.orderCost 0}
	{set:page.orderProfit 0}
	<tr style="{if:orderObject::is_lock}background-color:{if:orderObject::is_editable}#FFFFDD{else}#FFE0E0{/if}{/if};">
		<td style="padding:0px;border-bottom:double 2px #a0a0a0;">
			<table style="border-style:none;border-collapse:collapse;width:100%;margin:0px;height:100%;">
			<tbody>
			<tr>
				<th style="width:4em;background-color:#CFCFFF;color:#808080;border-style:none;text-align:left;vertical-align:top;white-space:nowrap;">{write:SHOPPING_LABEL_ORDER}ID</th>
				<td colspan="3" style="border-style:none;font-weight:bold;color:#000080;"><a href="javascript:shoppingOrderViewDetail({write:orderObject->'order_number'});">{write:orderObject->'order_id'}</a></td>
			</tr>
			{if:strlen(orderObject->'search_data_id')>0}
			<tr>
				<th style="width:4em;background-color:#CFCFFF;color:#808080;border-style:none;text-align:left;vertical-align:top;white-space:nowrap;">対象</th>
				<td colspan="3" style="border-style:none;font-weight:bold;color:#000080;"><a href="../../search/data/detail.php?schdi={write:orderObject->'search_data_id'}" target="_blank">{write:orderObject->'searchDataObject'->'subject'}</a></td>
			</tr>
			{/if}
			{if:strlen(orderObject->'promotion_code')>0}
			<tr>
				<th style="width:4em;background-color:#CFCFFF;color:#808080;border-style:none;text-align:left;vertical-align:top;white-space:nowrap;">紹介者</th>
				<td colspan="3" style="border-style:none;font-weight:bold;color:#000080;"><a href="javascript:shoppingOrderOpenPromotion('{write:orderObject->'shoppingPromotionObject'->'promotion_id'}');">{write:orderObject->'shoppingPromotionObject'->'promotion_name'}</a></td>
			</tr>
			{/if}
			<tr>
				<th style="width:4em;background-color:#CFCFFF;color:#808080;border-style:none;text-align:left;vertical-align:top;white-space:nowrap;">{write:SHOPPING_LABEL_ORDER}日</th>
				<td colspan="3" style="border-style:none;font-weight:bold;color:#000080;">{write:orderObject->'order_date'}</td>
			</tr>
			<tr>
				<th style="width:4em;background-color:#CFCFFF;color:#808080;border-style:none;text-align:left;vertical-align:top;white-space:nowrap;">{write:SHOPPING_LABEL_ORDER}者</th>
				<td colspan="3" style="border-style:none;color:#000080;font-size:x-small;">
					{set:memberObject orderObject::memberObject}
					<span style="white-space:nowrap;"><span style="font-weight:bold;">氏名:</span> <a href="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/member/member/detail.php?mi={write:memberObject->'member_id'}">{write:memberObject->'family_name'} {write:memberObject->'first_name'}</a>({write:memberObject->'family_kana'} {write:memberObject->'first_kana'})</span><br />
					<span style="white-space:nowrap;"><span style="font-weight:bold;">電話:</span> {write:memberObject->'telephone_number'}</span><br />
					<span style="white-space:nowrap;"><span style="font-weight:bold;">ＰＣ:</span> <a href="javascript:memberMemberMailForm('{write:memberObject->getUniqueId()}')"">{write:memberObject->'pc_mail'}</a></span><br />
					<span style="white-space:nowrap;"><span style="font-weight:bold;">携帯:</span> <a href="javascript:memberMemberMailForm('{write:memberObject->getUniqueId()}')"">{write:memberObject->'mb_mail'}</a></span><br />
					〒{write:memberObject->'zip_code'}<br />
					<span style="white-space:nowrap;">{if:strlen(memberObject->'prefecture_number')>0}{write:PREFECTURE_HASH[memberObject->'prefecture_number']}{/if}{write:memberObject->'address'} {write:memberObject->'building'}</span><br />
				</td>
			</tr>
			<tr>
				<th style="width:4em;background-color:#CFCFFF;color:#808080;border-style:none;border-top:dotted 1px #cccccc;text-align:left;vertical-align:top;white-space:nowrap;">宛先</th>
				<td colspan="3" style="border-style:none;color:#000080;font-size:x-small;border-top:dotted 1px #cccccc;">
				{if:count(orderObject->'shoppingOrderAddressObjectArray')>1}
					宛先が複数あります。詳細画面で確認してください。
				{else}
					{set:firstAddressObject orderObject->'shoppingOrderAddressObjectArray'[0]}
					<span style="white-space:nowrap;"><span style="font-weight:bold;">宛名:</span> {write:firstAddressObject->'address_name'}</span><br />
					<span style="white-space:nowrap;"><span style="font-weight:bold;">電話:</span> {write:firstAddressObject->'telephone_number'}</span><br />
					〒{write:firstAddressObject->'zip_code'}<br />
					<span style="white-space:nowrap;">{if:strlen(firstAddressObject->'prefecture_number')>0}{write:PREFECTURE_HASH[firstAddressObject->'prefecture_number']}{/if}{write:firstAddressObject->'address'} {write:firstAddressObject->'building'}</span>
				{/if}
				</td>
			</tr>
			</tbody>
			</table>
		</td>
		<td style="vertical-align: top;padding:0px;border-bottom:double 2px #a0a0a0;">
			<table class="shopping-order-list-contents">
			<tbody>
			{foreach:orderObject::shoppingOrderAddressObjectArray addressObject}
			{foreach:addressObject::shoppingOrderItemObjectArray orderItemObject}
			{set:unitObject orderItemObject->'shoppingProductUnitObject'}
				<tr style="border-bottom:dotted 1px #808080;">
					<td colspan="3" style="border-bottom:dotted 1px #808080;">
						{write:unitObject->'shoppingProductObject'->'product_name'}
						{write:unitObject->'unit_name'}
						{if:strlen(orderItemObject->'used_unit_id')>0}
							{write:orderItemObject->'usedUnitObject'->'unit_name'}
						{/if}
						{if:900==orderItemObject->'delivery_type'}
							<br />
							チェックイン:{write:date('Y年m月d日',strtotime(orderItemObject->'svc_start_date'))}<br />
							チェックアウト:{write:date('Y年m月d日',strtotime(orderItemObject->'svc_limit_date'))}
						{else-if:200<=orderItemObject->'delivery_type'}
							<br />
							{write:date('Y年m月d日',strtotime(orderItemObject->'svc_start_date'))}<br />
							{write:date('H:i',strtotime(orderItemObject->'svc_start_date'))}～{write:date('H:i',strtotime(orderItemObject->'svc_limit_date'))}
						{/if}<br />
						<?php if( defined('SHOPPING_ORDER_ITEM_FILE_USE') && '1' == SHOPPING_ORDER_ITEM_FILE_USE ){ ?>
						[<a href="./file/?shpon={write:orderObject->'order_number'}&amp;shpoin={write:orderItemObject->'item_number'}">アップロードファイル</a>]
						<?php } ?>
					</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;">&yen;{write:number_format(orderItemObject->'price_unit')}-</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">{write:orderItemObject->'order_count'}個</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">&yen;{write:number_format(orderItemObject->getTotalUnitPrice(request))}-</td>
				</tr>
				{foreach:orderItemObject::shoppingOrderOptionObjectArray optionObject}{if:optionObject->'option_price'>0}
				<tr style="border-bottom:dotted 1px #808080;">
					<td></td>
					<td colspan="2">
						{write:optionObject->'option_name'}={write:optionObject->'option_value'}
					</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;">&yen;{write:number_format(optionObject->'option_price')}-</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">{write:optionObject->'order_count'}個</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">&yen;{write:number_format(optionObject->getTotalPrice(request))}-</td>
				</tr>
				{/if}{/foreach}
			{/foreach}
			{/foreach}
			<!-- 直オプション -->
			{foreach:orderObject::shoppingOrderOptionObjectArray optionObject}{if:optionObject->'option_price'>0}
				<tr style="border-bottom:dotted 1px #808080;">
					<td></td>
					<td colspan="2">
						{write:optionObject->'option_name'}={write:optionObject->'option_value'}
					</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;">&yen;{write:number_format(optionObject->'option_price')}-</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">{write:optionObject->'order_count'}個</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">&yen;{write:number_format(optionObject->getTotalPrice(request))}-</td>
				</tr>
			{/if}{/foreach}
				<tr style="border-top:solid 1px #808080;border-bottom:dotted 1px #808080;">
					<td style="border-top:solid 1px #808080;border-bottom:dotted 1px #808080;" colspan="5">小計</td>
					<td style="border-top:solid 1px #808080;border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">&yen;{write:number_format(orderObject->'price_total')}-</td>
				</tr>
				{if:orderObject->'delivery_price'>0}
				<tr style="border-bottom:dotted 1px #808080;">
					<td style="border-bottom:dotted 1px #808080;" colspan="5">送料</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">&yen;{write:number_format(orderObject->'delivery_price')}-</td>
				</tr>
				{/if}
				{if:orderObject->'wrapping_price'>0}
				<tr style="border-bottom:dotted 1px #808080;">
					<td style="border-bottom:dotted 1px #808080;" colspan="5">包装代</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">&yen;{write:number_format(orderObject->'wrapping_price')}-</td>
				</tr>
				{/if}
				{if:orderObject->'settle_fee'>0}
				<tr style="border-bottom:dotted 1px #808080;">
					<td style="border-bottom:dotted 1px #808080;" colspan="5">決済手数料</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">&yen;{write:number_format(orderObject->'settle_fee')}-</td>
				</tr>
				{/if}
				{if:orderObject->'discount_price'>0}
				<tr style="border-bottom:dotted 1px #808080;">
					<td colspan="5" style="border-bottom:dotted 1px #808080;">紹介割引</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">▲&yen;{write:number_format(orderObject->'discount_price')}-</td>
				</tr>
				{/if}
				{if:orderObject->'purchase_total'>0}
				<tr style="border-bottom:dotted 1px #808080;">
					<td colspan="5" style="border-bottom:dotted 1px #808080;">{write:SHOPPING_LABEL_ORDER}合計</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">&yen;{write:number_format(orderObject->'purchase_total')}-</td>
				</tr>
				{/if}
				{if:orderObject->'point_use'>0}
				<tr style="border-bottom:dotted 1px #808080;">
					<td colspan="5" style="border-bottom:dotted 1px #808080;">利用ポイント</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">▲&yen;{write:number_format(orderObject->'point_use')}-</td>
				</tr>
				{/if}
				{if:orderObject->'discount_admin'!='0'}
				<tr style="border-bottom:solid 1px #808080;">
					<td style="border-bottom:solid 1px #808080;" colspan="5">調整金額</td>
					<td style="border-bottom:solid 1px #808080;text-align:right;white-space:nowrap;">&yen;{write:number_format(orderObject->'discount_admin')}-</td>
				</tr>
				{/if}
				<tr style="border-bottom:solid 1px #808080;">
					<td style="border-bottom:solid 1px #808080;" colspan="5">支払金額</td>
					<td style="border-bottom:solid 1px #808080;text-align:right;white-space:nowrap;">&yen;{write:number_format(orderObject->'payment_total')}-</td>
				</tr>
				<tr style="border-bottom:solid 1px #808080;">
					<td style="border-bottom:solid 1px #808080;" colspan="5">払済金額</td>
					<td style="border-bottom:solid 1px #808080;text-align:right;white-space:nowrap;">&yen;{write:number_format(orderObject->'settle_price')}-</td>
				</tr>
				{if:orderObject->'settle_price'>orderObject->'payment_total'}
				<tr style="border-bottom:solid 1px #808080;">
					<td style="border-bottom:solid 1px #808080;color:#ff0000;" colspan="5">過払金額</td>
					<td style="border-bottom:solid 1px #808080;text-align:right;white-space:nowrap;color:#ff0000;">&yen;{write:number_format(orderObject->'settle_price'-orderObject->'payment_total')}-</td>
				</tr>
				{else-if:orderObject->'settle_price'<orderObject->'payment_total'}
				<tr style="border-bottom:solid 1px #808080;">
					<td style="border-bottom:solid 1px #808080;color:#ff0000;" colspan="5">不足金額</td>
					<td style="border-bottom:solid 1px #808080;text-align:right;white-space:nowrap;color:#ff0000;">&yen;{write:number_format(orderObject->'payment_total'-orderObject->'settle_price')}-</td>
				</tr>
				{/if}
				{if:orderObject->'point_total'>0}
				<tr style="border-bottom:dotted 1px #808080;">
					<td colspan="5" style="border-bottom:dotted 1px #808080;">付与ポイント</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">&yen;{write:number_format(orderObject->'point_total')}-</td>
				</tr>
				{/if}
				{if:orderObject->'cost_total'>0}
				<tr style="border-bottom:dotted 1px #808080;">
					<td style="border-bottom:dotted 1px #808080;" colspan="5">仕入</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">▲&yen;{write:number_format(orderObject->'cost_total')}-</td>
				</tr>
				{if:orderObject->'promotion_fee'>0}
				<tr style="border-bottom:dotted 1px #808080;">
					<td style="border-bottom:dotted 1px #808080;" colspan="5">販促</td>
					<td style="border-bottom:dotted 1px #808080;text-align:right;white-space:nowrap;">▲&yen;{write:number_format(orderObject->'promotion_fee')}-</td>
				</tr>
				{/if}
				<tr style="border-bottom:solid 1px #808080;">
					<td style="border-bottom:solid 1px #808080;" colspan="5">粗利</td>
					<td style="border-bottom:solid 1px #808080;text-align:right;">&yen;{write:number_format(orderObject->'payment_total'-orderObject->'cost_total'-orderObject->'promotion_fee'-orderObject->'delivery_price'-orderObject->'wrapping_price'-orderObject->'settle_fee')}-</td>
				</tr>
				{/if}
			</tbody>
			</table>
		</td>
		<td style="width:8em;text-align:center;vertical-align:top;white-space:nowrap;border-bottom:double 2px #a0a0a0;">
			{if:orderObject->'payment_total'!=orderObject->'settle_price'}
			<div style="border:solid 1px #ff0000;background-color:#ff0000;white-space:nowrap;font-weight:bold;color:#ffffff;">
				決済金額不一致
			</div>
			{/if}
			{set:orderEnableSynchronize false}
			<div style="border:solid 1px #a0a0a0;background-color:#80a0ff;white-space:nowrap;">
				{foreach:shopping.order.settlement.methodObjectArray settleMethodObject}
					{if:strlen(orderObject->'settle_method')>0 && settleMethodObject->getMethodNumber()==orderObject->'settle_method'}
						{write:settleMethodObject->getMethodViewName()}
						{set:orderEnableSynchronize settleMethodObject->enableSynchronize()}
					{/if}
				{/foreach}
			</div>
			{write:SHOPPING_LABEL_ORDER}対応状態<br />
			<select id="sstatus_{write:orderObject->'order_number'}"
				class="status_settle_a{write:orderObject->'status_flag'}"
				style="width:100%;"
				onchange="shoppingOrderChangeStatusConfirm(this,{write:orderObject->'order_number'},'flag')"
				onfocus="shoppingOrderSetPrevStatus(this);"
				>
				{foreach:SHOPPING_ORDER_STATUS_HASH key val}{if:orderObject->isContinued() || key!=111}
				<option value="{write:key}" class="status_settle_a{write:key}"
					{if:strlen(orderObject->'status_flag')>0 && key==orderObject->'status_flag'} selected{/if}
					>{write:val}</option>
				{/if}{/foreach}
			</select><br />
			決済状態<br />
			<select id="ssettle_{write:orderObject->'order_number'}"
				class="status_settle_a{write:orderObject->'status_settle'}"
				style="width:100%;"
				onchange="shoppingOrderChangeStatusConfirm(this,{write:orderObject->'order_number'},'settle')"
				onfocus="shoppingOrderSetPrevStatus(this);"
				>
				{foreach:SHOPPING_ORDER_STATUS_SETTLE_HASH key val}
				<option value="{write:key}" class="status_settle_a{write:key}"
					{if:strlen(orderObject->'status_settle')>0 && key==orderObject->'status_settle'} selected{/if}
					>{write:val}</option>
				{/foreach}
			</select><br />
			{if:strlen(orderObject->'promotion_code')>0}
			プロモーション状態<br />
			<select id="spromo_{write:orderObject->'order_number'}"
				class="status_settle_a{write:orderObject->'status_promotion'}"
				style="width:100%;"
				onchange="shoppingOrderChangeStatusConfirm(this,{write:orderObject->'order_number'},'promotion')"{if:orderObject->'status_settle'<100} disabled="desabled"{/if}
				onfocus="shoppingOrderSetPrevStatus(this);"
				>
				{foreach:SHOPPING_ORDER_STATUS_PROMOTION_HASH key val}
				<option value="{write:key}" class="status_settle_a{write:key}"
					{if:strlen(orderObject->'status_promotion')>0 && key==orderObject->'status_promotion'} selected{/if}
					>{write:val}</option>
				{/foreach}
			</select><br />
			{/if}
			決済確認機能<br />
			{if:orderEnableSynchronize}
				<input type="button" value="決済状態確認" class="executeSettleSynchronize" style="width:100%;"
					onclick="executeSettleSynchronize('{write:orderObject->'order_number'}')"
					/><br />
			{else}
				<div style="border:solid 1px #a0a0a0;background-color:#c0c0c0;color:#ffffff;white-space:nowrap;">
					決済確認非対応
				</div>
			{/if}
			
			{if:orderObject::is_lock}{if:orderObject::is_editable}
			<input type="button" style="width:100%;color:#FF0000;" value="ロック解除"
				onclick="window.location.href='./order/unlock.php?shpdn={write:orderObject->'order_number'}';" /><br />
			{/if}{/if}
			{if:orderObject::is_editable}
			<input type="button" style="width:100%;" value="登録情報の変更"
				onclick="shopping_modify_order('{write:orderObject->'order_number'}');" /><br />
			{/if}
			
			<input type="button" style="width:100%;" value="メール再通知"
				onclick="shoppingResendMail({write:orderObject->'order_number'},{write:orderObject->'status_flag'});" /><br />
		</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	<br />
	
	<h1>期間集計</h1>
	<table class="list" style="margin:0 auto;width:96%;">
	<thead>
	<tr>
		<th style="width:13%;">売上</th>
		<th style="width:13%;">仕入</th>
		<th style="width:13%;">販促</th>
		<th style="width:13%;">送料</th>
		<th style="width:13%;">包装</th>
		<th style="width:13%;">決済手数料</th>
		<th style="width:13%;">粗利</th>
	</tr>
	</thead>
	<tbody>
	<tr>
		<td style="width:13%;text-align:right;">&yen;{write:number_format(shopping.order.totalPayment)}-</td>
		<td style="width:13%;text-align:right;">&yen;{write:number_format(shopping.order.totalCost)}-</td>
		<td style="width:13%;text-align:right;">&yen;{write:number_format(shopping.order.totalFee)}-</td>
		<td style="width:13%;text-align:right;">&yen;{write:number_format(shopping.order.totalDelivery)}-</td>
		<td style="width:13%;text-align:right;">&yen;{write:number_format(shopping.order.totalWrapping)}-</td>
		<td style="width:13%;text-align:right;">&yen;{write:number_format(shopping.order.totalSettleFee)}-</td>
		<td style="width:13%;text-align:right;">&yen;{write:number_format(shopping.order.totalPayment-shopping.order.totalCost-shopping.order.totalFee-shopping.order.totalDelivery-shopping.order.totalWrapping-shopping.order.totalSettleFee)}-</td>
	</tr>
	</tbody>
	</table>

	{if:is_object(shopping.order.memberObject)}
	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:95%;margin:0 auto;text-align:right;">
		<a href="../../member/member/detail.php?mi={write:shopping.order.memberObject->'member_id'}">{write:shopping.order.memberObject->'view_name'}さんの詳細情報に戻る</a>
	</div>
	{/if}

<style type="text/css">
<!--
.status_0 { color: #FF0000; }
.status_1 { color: #FF6000; }
.status_101 { color: #6060FF; }
.status_settle_a0 { background-color: #ff9090; }
.status_settle_a10 { background-color: #ffff00; }
.status_settle_a101 { background-color: #c0c0c0; }
.status_settle_a111 { background-color: #e0e0e0; }
.status_settle_a201 { background-color: #909090; }
.status_settle_a211 { background-color: #909090; }
.status_settle_a255 { background-color: #909090; }
//-->
</style>
<script language="JavaScript" type="text/javascript"><!--
function changeSelectColor(selectElement) {
	selectElement.className	= selectElement.options[selectElement.selectedIndex].className;
}
var shoppingOrderStatusHttpObject;
var shoppingOrderCurOrderNumber;
var shoppingOrderCurTargetString;
var shoppingOrderCurStatusNumber;
var shoppingOrderPrevStatusIndex;
function shoppingOrderSetPrevStatus(selectElement) {
	shoppingOrderPrevStatusIndex	= selectElement.selectedIndex;
}
function shoppingOrderChangeStatusConfirm(selectElement,orderNumber,targetString) {
	if( !selectElement ) {
		alert('システムエラー！');
		return;
	} else if( !targetString ) {
		alert('システムエラー！');
		return;
	} else if( !orderNumber ) {
		alert('システムエラー！');
		return;
	}
	if( selectElement.selectedIndex == shoppingOrderPrevStatusIndex ) {
		return;
	} else {
		shoppingOrderChangeStatus(selectElement,orderNumber,targetString);
	}
}
function shoppingOrderChangeStatus(selectElement,orderNumber,targetString) {
	if( !selectElement ) {
		alert('システムエラー！');
		return;
	} else if( !targetString ) {
		alert('システムエラー！');
		return;
	} else if( !orderNumber ) {
		alert('システムエラー！');
		return;
	}
	if( selectElement.selectedIndex == shoppingOrderPrevStatusIndex ) {
		return;
	}
	var statusNumber;
	if( selectElement.options && selectElement.selectedIndex >= 0 ) {
		statusNumber	= selectElement.options[selectElement.selectedIndex].value;
	} else {
		alert('システムエラー！');
		return;
	}

	var contents	= encodeURIComponent('target_status')+"="+encodeURIComponent(targetString);
	contents	+= '&' + encodeURIComponent('status_number')+"="+encodeURIComponent(statusNumber);
	if( !confirm('状態を変更します!\nこの操作は元に戻せなくなる場合があります!\n本当に実行してよろしいですか？') ) {
		selectElement.selectedIndex	= shoppingOrderPrevStatusIndex;
		return;
	}
	if( targetString == 'flag' && confirm('状態変更を{write:SHOPPING_LABEL_ORDER}者にメール通知しますか？\n'
	+'「ＯＫ」をクリックすると状態を変更してメール通知します。\n「キャンセル」をクリックするとメール通知しないで状態を変更します。') ) {
		contents	+= '&' + encodeURIComponent('is_notify')+"="+encodeURIComponent('yes');
	}
	
	changeSelectColor(selectElement);
	shoppingOrderCurOrderNumber		= orderNumber;
	shoppingOrderCurTargetString	= targetString;
	shoppingOrderCurStatusNumber	= statusNumber;
	
	shoppingOrderStatusHttpObject	= FormerCommon.createHttpRequest(shoppingOrderChangeStatusResult);
	if( shoppingOrderStatusHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		shoppingOrderStatusHttpObject.open("POST",'./ajax/status.php?shpon='+orderNumber,true);
		shoppingOrderStatusHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingOrderStatusHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingOrderChangeStatusResult() {
	if ((shoppingOrderStatusHttpObject.readyState == 4) && (shoppingOrderStatusHttpObject.status == 200)){
		setTimeout(FormerCommon.displayWhiteIn, 500);
	    var lines	= shoppingOrderStatusHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
	    	// 決済情報が変更になった場合にプロモーション状態があれば連動させる
	    	if( 'settle' == shoppingOrderCurTargetString ) {
	    		var promoStatusSelect	= document.getElementById('spromo_'+shoppingOrderCurOrderNumber);
	    		if( promoStatusSelect ) {
	    			if( shoppingOrderCurStatusNumber < 100 ) {
	    				// 未決済の場合
	    				promoStatusSelect.selectedIndex	= 0;
	    				shoppingOrderChangeStatus(promoStatusSelect,shoppingOrderCurOrderNumber,'promotion');
	    				promoStatusSelect.disabled		= 'disabled';
	    			} else {
	    				// 決済済みになったら
	    				promoStatusSelect.selectedIndex	= 1;
	    				shoppingOrderChangeStatus(promoStatusSelect,shoppingOrderCurOrderNumber,'promotion');
	    				promoStatusSelect.disabled		= '';
	    			}
	    		}
	    	}
	    	// 背景色も変える
	    	
	    } else {
	    	alert(shoppingOrderStatusHttpObject.responseText);
	    }
	} else if ((shoppingOrderStatusHttpObject.readyState == 4) && (shoppingOrderStatusHttpObject.status != 200)){
		setTimeout(FormerCommon.displayWhiteIn, 500);
		alert('適用時にサーバー通信でエラーが発生しました。');
	}
}
function shoppingOrderOpenPromotion(promotionId) {
	window.location.href='../promotion/detail.php?shppi='+promotionId;
}
/**
 * 決済状態を同期する関数
 */
var settleSynchronizeHttpObject;
var shoppingOrderCurOrderNumber;
function executeSettleSynchronize(orderNumber) {
	shoppingOrderCurOrderNumber		= orderNumber;
	var contents	= '';
	settleSynchronizeHttpObject	= FormerCommon.createHttpRequest(settleSynchronizeResult);
	if( settleSynchronizeHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		settleSynchronizeHttpObject.open("GET",'./ajax/synchronize.php?shpon='+orderNumber,true);
		settleSynchronizeHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		settleSynchronizeHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function settleSynchronizeResult() {
	if ((settleSynchronizeHttpObject.readyState == 4) && (settleSynchronizeHttpObject.status == 200)){
		setTimeout(FormerCommon.displayWhiteIn, 500);
	    var lines	= settleSynchronizeHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
	    } else {
	    	alert(settleSynchronizeHttpObject.responseText);
	    }
	} else if ((settleSynchronizeHttpObject.readyState == 4) && (settleSynchronizeHttpObject.status != 200)){
		setTimeout(FormerCommon.displayWhiteIn, 500);
		alert('適用時にサーバー通信でエラーが発生しました。');
	}
}
/**
 * 決済状態を一括で同期する関数
 */
var synchronizeButtonObjectArray	= new Array();
function settleSynchronizeExecuteAll() {
	FormerCommon.displayGrayOut(9999);
	synchronizeButtonObjectArray	= new Array();
	var inputTags 	= document.getElementsByTagName('input');
	for(var i=0,n=inputTags.length;i<n;i++) {
		var inputType	= inputTags[i].type;
		var className	= inputTags[i].className;
		if( 'button'==inputType && 'executeSettleSynchronize' == className ) {
			synchronizeButtonObjectArray.push(inputTags[i]);
		}
	}
	if( synchronizeButtonObjectArray.length > 0 ) {
		executeSettleSynchronizeAllClick();
	} else {
		setTimeout(FormerCommon.displayWhiteIn, 500);
	}
}
function executeSettleSynchronizeAllClick() {
	if( synchronizeButtonObjectArray && synchronizeButtonObjectArray.length > 0 ) {
		var tagObject	= synchronizeButtonObjectArray.shift();
		if( tagObject ) {
			tagObject.click();
			if( synchronizeButtonObjectArray.length > 0 ) {
				setTimeout(executeSettleSynchronizeAllClick, 500);
			} else {
				setTimeout(FormerCommon.displayWhiteIn, 500);
			}
		} else {
			setTimeout(FormerCommon.displayWhiteIn, 500);
		}
	} else {
		setTimeout(FormerCommon.displayWhiteIn, 500);
	}
}
/**
 * 現在の状態でメールを再送信
 */
function shoppingResendMail( orderNumber, statusNumber ) {
	var contents	= encodeURIComponent('target_status')+"="+encodeURIComponent('flag');
	contents	+= '&' + encodeURIComponent('status_number')+"="+encodeURIComponent(statusNumber);
	contents	+= '&' + encodeURIComponent('is_notify')+"="+encodeURIComponent('yes');
	shoppingOrderStatusHttpObject	= FormerCommon.createHttpRequest(shoppingResendMailResult);
	if( shoppingOrderStatusHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		shoppingOrderStatusHttpObject.open("POST",'./ajax/status.php?shpon='+orderNumber,true);
		shoppingOrderStatusHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingOrderStatusHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingResendMailResult(){
	if ((shoppingOrderStatusHttpObject.readyState == 4) && (shoppingOrderStatusHttpObject.status == 200)){
		setTimeout(FormerCommon.displayWhiteIn, 500);
	    var lines	= shoppingOrderStatusHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
	    } else {
	    	alert(shoppingOrderStatusHttpObject.responseText);
	    }
		setTimeout(FormerCommon.displayWhiteIn, 500);
	} else if ((shoppingOrderStatusHttpObject.readyState == 4) && (shoppingOrderStatusHttpObject.status != 200)){
		setTimeout(FormerCommon.displayWhiteIn, 500);
		alert('適用時にサーバー通信でエラーが発生しました。');
	}
}
//--></script>
<style type="text/css">
table.shopping-order-list-contents {
	border-collapse: collapse;
	width:100%;
}
table.shopping-order-list-contents tbody tr th,table.shopping-order-list-contents tbody tr td {
	border: none 0px #ffffff;
	font-size:x-small;
}
</style>
