<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_PRODUCT . 'カテゴリ一覧'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">ショップ管理</a>
		&gt; {write:SHOPPING_LABEL_PRODUCT}カテゴリ管理
	</div>

	<h1>ショップ管理 &gt; {write:SHOPPING_LABEL_PRODUCT}カテゴリ管理</h1>
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="javascript:shopping_add_category()">&gt;&gt; カテゴリ新規作成</a>
	</div>
	<br />
	<div id="category-list-area"></div>
	

<style type="text/css"><!--
table.list tbody tr td {
	padding: 0px;
}
#category-list-area {
	width: 96%;
	margin: 0 auto;
}
#category-list-area ul {
	list-style-type: none;
}
#category-list-area ul li {
	padding-left: 1em;
	margin-top: 2px;
	border-top: solid 1px #008000;
}
#category-list-area ul li ul li {
	padding-left: 2em;
	margin-top: 2px;
	border-top: dotted 1px #008000;
}
#category-list-area ul li div.category-name {
	float: left;
	padding: 5px;
	line-hight: 1em;
}
#category-list-area ul li div.category-edit {
	width: 8em;
	float: right;
	text-align: right;
	padding: 5px;
	line-hight: 1em;
}
#category-list-area ul li div.category-image {
	text-align :right;
	padding: 5px;
	line-hight: 1em;
}
#category-list-area ul li div.category-description {
	clear: both;
	height: 0px;
}
--></style>

<script type="text/javascript"><!--
var shoppingCategoryHttpdObject;
function shoppingCategoryMove(categoryId,direction){
	var contents	= "command=0";
	contents	+= "&" + encodeURIComponent('category_id')+ "="+encodeURIComponent(categoryId);
	contents	+= "&" + encodeURIComponent('direction')+ "="+encodeURIComponent(direction);
	shoppingCategoryHttpdObject	= FormerCommon.createHttpRequest(shoppingCategoryMoveResult);
	if( shoppingCategoryHttpdObject ) {
		var url	= './move.php';
		shoppingCategoryHttpdObject.open("post",url,true);
		shoppingCategoryHttpdObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingCategoryHttpdObject.send(contents);
		FormerCommon.displayGrayOut(9999);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingCategoryMoveResult(){
	if ((shoppingCategoryHttpdObject.readyState == 4) && (shoppingCategoryHttpdObject.status == 200)){
		shoppingGetCategories();
	} else if ((shoppingCategoryHttpdObject.readyState == 4) && (shoppingCategoryHttpdObject.status != 200)){
		alert('HTTP通信に失敗しました！');
	}
}
function shoppingGetCategories() {
	shoppingCategoryHttpdObject	= FormerCommon.createHttpRequest(shoppingGetCategoriesResult);
	if( shoppingCategoryHttpdObject ) {
		var url	= '../ajax/categories.php';
		shoppingCategoryHttpdObject.open("GET",url,true);
		shoppingCategoryHttpdObject.send(null);
		FormerCommon.displayGrayOut(9999);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingGetCategoriesResult() {
	if ((shoppingCategoryHttpdObject.readyState == 4) && (shoppingCategoryHttpdObject.status == 200)){
		var listBlock	= document.getElementById('category-list-area');
		listBlock.innerHTML	= '';
		var domDoc	= shoppingCategoryHttpdObject.responseXML;
		if( domDoc ) {
			var rootNodes	= domDoc.getElementsByTagName('categories');
			var rootNode	= rootNodes[0];
			var ulObject	= document.createElement('ul');
			listBlock.appendChild(ulObject);
			var nodes	= rootNode.childNodes;
			if( nodes.length > 0 ) {
				for( var num=0; num<nodes.length; num++ ) {
					var targetDom	= nodes[num];
					if( targetDom.tagName && targetDom.tagName == 'category'){
						var elm	= createCategoryListItem(targetDom);
						if(elm){
							ulObject.appendChild(elm);
						}
					}
				}
			}
		} else {
			alert('正常なXMLが取得できませんでした！');
		}
		setTimeout(FormerCommon.displayWhiteIn, 100);
	} else if ((shoppingCategoryHttpdObject.readyState == 4) && (shoppingCategoryHttpdObject.status != 200)){
		alert('カテゴリ一覧取得に失敗しました！');
		setTimeout(FormerCommon.displayWhiteIn, 100);
	}
}
function createCategoryListItem(categoryDom){
	var liElm	= document.createElement('li');
	liElm.imageArray	= new Array();
	var categoryId			= categoryDom.getAttribute("id");
	var categoryNumber	= categoryDom.getAttribute("number");
	var nodes				= categoryDom.childNodes;
	var childArray	= new Array();
	if( nodes && nodes.length > 0 ){
		for( var num=0; num<nodes.length; num++ ){
			var targetDom	= nodes[num];
			if( targetDom && targetDom.tagName == 'category' ){
				var child = createCategoryListItem(targetDom);
				if( child ){
					childArray.push(child);
				}
			} else if( targetDom && targetDom.tagName == 'image' ){
				liElm.imageArray[targetDom.getAttribute("number")]	= targetDom.getAttribute("uri");
			}
		}
	}
	// 
	var nameElm	= document.createElement('div');
	nameElm.className	= 'category-name';
	nameElm.innerHTML	= categoryDom.getAttribute("name");
	liElm.appendChild(nameElm);
	// 
	var editElm = document.createElement('div');
	editElm.className	= 'category-edit';
	editElm.innerHTML	=
	 '<a title="カテゴリの並び順を上に移動します" href="javascript:shoppingCategoryMove(\''+categoryId+'\',\'up\')">▲</a>'
	+'・<a title="カテゴリの並び順を下に移動します" href="javascript:shoppingCategoryMove(\''+categoryId+'\',\'down\')">▼</a>'
	+'・<a title="カテゴリの登録内容を編集します" href="./form.php?shpcn=' + categoryNumber +'">編集</a>'
	+'・<a title="カテゴリを削除します" href="./delete/confirm.php?shpcn=' + categoryNumber +'">削除</a>';
	liElm.appendChild(editElm);
	// 画像
	var imageElm = document.createElement('div');
	imageElm.className	= 'category-image';
	liElm.appendChild(imageElm);
	for( var i=0; i<liElm.imageArray.length; i++ ){
		var imgObj	= new Image();
		imgObj.style.marginLeft = '2px';
		imgObj.onload = function() {
			var imgW	= this.width;
			var imgH	= this.height;
			if( this.naturalWidth ){
				imgW	= this.naturalWidth;
				imgH	= this.naturalHeight;
			} else if( this.runtimeStyle ){
				run = this.runtimeStyle;
				mem = { w: run.width, h: run.height };
				run.width  = "auto";
				run.height = "auto";
				imgW = this.width;
				imgH = this.height;
				run.width  = mem.w; // restore
				run.height = mem.h;
			}
			imgW	= parseInt(imgW);
			imgH	= parseInt(imgH);
			if( imgH > 15 ){
				imgW	= Math.ceil(imgW * 15 / imgH);
				imgH	= 15;
			}
			this.style.width	= String(imgW) + 'px';
			this.style.height	= String(imgH) + 'px';
			this.orgWidth		= String(imgW) + 'px';
			this.orgHeight	= String(imgH) + 'px';
		};
		imgObj.onclick = function(){
			window.open(this.src,'shoppingCategoryImage','width='+this.orgWidth+',height='+this.orgHeight+',scrollbars=no,resizable=yes,location=no,toolbar=no');
		};
		imgObj.src	= '<?php echo SPIDER_URI_BASE; ?>' + liElm.imageArray[i];
		imgObj.style.verticalAlign = 'middle';
		imgObj.style.cursor	= 'pointer';
		imageElm.appendChild(imgObj);
	}
	// 
	var descElm = document.createElement('div');
	descElm.className	= 'category-description'
	liElm.appendChild(descElm);
	
	//
	if( childArray.length > 0 ){
		var cUl	= document.createElement('ul');
		for( var i=0; i<childArray.length; i++ ){
			cUl.appendChild(childArray[i]);
		}
		liElm.appendChild(cUl);
	}
	return liElm;
}
if(window.attachEvent){
	window.attachEvent('onload',shoppingGetCategories);
}else{
	window.addEventListener('DOMContentLoaded',shoppingGetCategories,false);
}
//--></script>