<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:member.upload.Confirm}
{preset:page_title MEMBER_PERSONAL_LABEL . '管理 > CSV登録'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">{write:MEMBER_PERSONAL_LABEL}情報一覧</a>
		&gt; CSVデータ登録
	</div>

	<h1>
		{write:MEMBER_PERSONAL_LABEL}管理 &gt; CSVデータ登録
	</h1>
	
{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<p style="text-align:center;">
		<input type="button" value="戻る"
			onclick="window.history.back();"
		/>
	</p>
	<br />
{else}
	<p style="text-align:center;">
		{if:member.upload.registInformationHash['ignoreFirstLine']}
			一行目はカラム名なので取り込みません<br />
		{/if}
		[登録を開始する]をクリックすると登録処理を開始します。
	</p>

	<div id="panel-barcontainer" style="text-align:left;border-style:solid;border-width:1px;width:60%;height:1em;margin:0 auto;"
		><div id="panel-bar" style="height:1em;background-color:#0000FF;width:0%;"></div>
	</div>
	<div style="text-align:center;">
		<div id="currentOffset" style="display:inline;">0</div> / {write:member.upload.registInformationHash['totalCount']}
	</div>
	<div id="messagePanel" style="width:96%;margin:0 auto;text-align:left;"></div>
	<div id="errorPanel" style="width:96%;margin:0 auto;text-align:left;"></div>
	
	<p style="text-align:center;">
		<input type="button" value="戻る"
			onclick="window.history.back();"
		/><input type="button" value="登録を開始する"
			id="dlbutton" onclick="memberUploadRequest()"
		/><br />
	</p>
	<br />
	<br />
	<br />

<script language="JavaScript" type="text/javascript"><!--
var memberUploadHttpObject;
var isValidateError	= false;
function memberUploadRequest() {
	var button		= document.getElementById('dlbutton');
	var bar			= document.getElementById('panel-bar');
	if( button ) {
		button.disabled	= 'disabled';
	}
	memberUploadHttpObject	= FormerCommon.createHttpRequest(memberUploadRequestResult);
	if( memberUploadHttpObject ) {
		var url			= './execute.php';
		memberUploadHttpObject.open("GET",url,true);
		memberUploadHttpObject.send(null);
	} else {
		alert('通信の作成に失敗しました。');
	}
	
}
function memberUploadRequestResult() {
	if ((memberUploadHttpObject.readyState == 4) && (memberUploadHttpObject.status == 200)){
		var offsetPanel		= document.getElementById('currentOffset');
		var messagePanel	= document.getElementById('messagePanel');
		var errorPanel		= document.getElementById('errorPanel');
		var bar				= document.getElementById('panel-bar');
		var response		= memberUploadHttpObject.responseText;
		var lines			= response.trim().split(LF);
		var totalCount		= new String(lines.shift()).trim();
		var processType		= new String(lines.shift()).trim();
		var isError			= new String(lines.shift()).trim();
		var currentOffset	= new String(lines.shift()).trim();
		var iTotalCount		= parseInt(totalCount);
		var iCurrentOffset	= parseInt(currentOffset);
		if( iCurrentOffset <= iTotalCount ) {
			offsetPanel.innerHTML	= currentOffset;
		}
		if( '1' == isError ) {
			isValidateError	= true;
		}
		var num=0;
		for( num=0; num < lines.length; num++ ) {
			var msgElm	= document.createElement('div');
			msgElm.style.color	= '#ff0000';
			msgElm.innerHTML	= lines[num];
			errorPanel.appendChild(msgElm);
		}
		if( '0' == processType ) {
			// 妥当性検査
			messagePanel.innerHTML	='妥当性検査を実行しています...';
			var rate	= Math.floor(( (iCurrentOffset/iTotalCount)*100 )/2);
			bar.style.width	= new String(rate) + '%';
			memberUploadRequest();
		} else if( '1' == processType ) {
			// 登録処理
			if( isValidateError ) {
				messagePanel.innerHTML	='ファイル内容にエラーがあるため処理を中断しました。';
			} else {
				messagePanel.innerHTML	='データベースへ登録しています...';
				var num=0;
				for( num=0; num < lines.length; num++ ) {
					var msgElm	= document.createElement('div');
					msgElm.style.color	= '#ff0000';
					msgElm.innerHTML	= lines[num];
					errorPanel.appendChild(msgElm);
				}
				if( iCurrentOffset > iTotalCount ) {
					// 終了している
					messagePanel.innerHTML	='登録処理が全て完了しました。';
					bar.style.width	= '100%';
				} else {
					// 終了していない
					var rate	= Math.floor(( (iCurrentOffset/iTotalCount)*100 )/2) + 50;
					bar.style.width	= new String(rate) + '%';
					memberUploadRequest();
				}
			}
		} else {
			alert('原因不明のエラーが発生しました。');
		}
	} else if ((memberUploadHttpObject.readyState == 4) && (memberUploadHttpObject.status != 200)){
		alert('通信に失敗しました。');
		memberUploadHttpObject	= null;
	}
}
//--></script>
{/if}
	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="../">&gt;&gt; {write:MEMBER_PERSONAL_LABEL}一覧へ戻る</a>
	</div>