<?php include_once( "../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:member.member.Select}
{preset:page_title MEMBER_PERSONAL_LABEL . '管理 > 選択リスト一覧'}

	<div class="panc">
		<a href="../">管理パネルトップ</a>
		&gt; <a href="./">{write:MEMBER_PERSONAL_LABEL}一覧と検索</a>
		&gt; {write:MEMBER_PERSONAL_LABEL}選択リスト一覧
	</div>

	<h1>{write:MEMBER_PERSONAL_LABEL}管理 &gt; {write:MEMBER_PERSONAL_LABEL}一覧と検索 &gt; 選択リスト{write:MEMBER_PERSONAL_LABEL}一覧</h1>
	
	{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	{/if}
	
	<form name="sform" action="./selected.php" method="get">
	<input type="hidden" name="pn" value="{write:member.member.select.page_number}" />
	<table style="margin:0 auto;width:96%;">
	<tbody>
	<tr>
		<td>
			ページ表示数：<select name="pr" onchange="document.sform.submit();">
				<option value="1"{if:member.member.select.page_rows=1} selected{/if}>1</option>
				<option value="5"{if:member.member.select.page_rows=5} selected{/if}>5</option>
				<option value="10"{if:member.member.select.page_rows=10} selected{/if}>10</option>
				<option value="20"{if:member.member.select.page_rows=20} selected{/if}>20</option>
				<option value="50"{if:member.member.select.page_rows=50} selected{/if}>50</option>
				<option value="100"{if:member.member.select.page_rows=100} selected{/if}>100</option>
			</select>
		</td>
		<td style="text-align:right;vertical-align:top;" colspan="2">
			<input type="button" name="" value="検索結果に戻る"
				onclick="window.location.href='{write:member.member.select.last_search_uri}'"
			/><input type="button" name="" value="選択リストメール送信"
				onclick="window.location.href='./mail/form.php?stype=s';"
			/><input type="button" name="" value="選択一括削除"
				onclick="window.location.href='./member/delete/confirm.php?target=selectedlist';"
			/><input type="button" value="CSVダウンロード"
				onclick="window.location.href='./download/form.php?stype=s';"
			/>
		</td>
	</tr>
	</tbody>
	</table>
	</form>

	{if:member.member.select.total_count==0}
	<p>
		現在選択リストに選択済みの{write:MEMBER_PERSONAL_LABEL}はいません。
	</p>
	{else}
	<table class="paging" style="margin:0 auto;width:100%;border-style:none;">
	<tr>
		<td style="width:6em;">
			{if:member.member.select.has_prev_page}
				<input type="button" value="前のページ" onclick="FormerCommon.prevPage()" />
			{else}
				<span style="color:#D0D0D0;">前のページ</span>
			{/if}
		</td>
		<td style="text-align:center;">
			{write:member.member.select.total_count}件  {write:member.member.select.page_number} / {write:member.member.select.total_page}ページ
		</td>
		<td style="width:6em;">
			{if:member.member.select.has_next_page}
				<input type="button" value="次のページ" onclick="FormerCommon.nextPage()" />
			{else}
				<span style="color:#D0D0D0;">次のページ</span>
			{/if}
		</td>
	</tr>
	</table>
	<table class="list" style="margin:0 auto;width:96%;">
	<tbody>
	<tr class="list">
		<th style="text-align:left;">ID</th>
		<th>表示名</th>
		<th>メール</th>
		<th>対応状況</th>
		<th>現在Pt.</th>
		<th>操作</th>
	</tr>
	{foreach:member.member.select.selected_member_object_array member_object}
	<tr class="list">
		<td style="text-align:left;">
			<input type="checkbox" name="select_{write:member_object->'member_id'}" value="{write:member_object->'member_id'}" onclick="member_selectMemberCheck(this)"
				{if:array_key_exists(member_object::member_id,member.member.select.selected_hash)} checked{/if}
				/>
			{write:member_object->'member_id'}
			<div style="font-size:x-small;">
				[<a href="javascript:memberMemberModify('{write:member_object->'member_id'}')">編集</a>]
				[<a href="./member/delete/confirm.php?mi={write:member_object->'member_id'}">削除</a>]
			</div>
		</td>
		<td>
			<a href="javascript:memberMemberDetail('{write:member_object->'member_id'}')">{write:member_object->'view_name'}</a>
		</td>
		<td>
			<a href="javascript:memberMemberMailForm('{write:member_object->getUniqueId()}')">{write:member_object->'pc_mail'}</a>
			{if:member_object->'pc_mail_error_count'>0}<span style="font-size:x-small;color:#ff0000;">(エラー戻り:{write:member_object->'pc_mail_error_count'})</span>{/if}
			<br />
			<a href="javascript:memberMemberMailForm('{write:member_object->getUniqueId()}')">{write:member_object->'mb_mail'}</a>
			{if:member_object->'mb_mail_error_count'>0}<span style="font-size:x-small;color:#ff0000;">(エラー戻り:{write:member_object->'mb_mail_error_count'})</span>{/if}
		</td>
		<td>
			{if:strlen(member_object->'last_correspond_date_year')>0}最終対応日: {write:member_object->'last_correspond_date_year'}年{write:member_object->'last_correspond_date_month'}月{write:member_object->'last_correspond_date_day'}日<br />{/if}
			{if:member_object->'complete_correspond'>0}対応済項目数: {write:member_object->'complete_correspond'}件<br />{/if}
			{if:member_object->'remain_correspond'>0}<span style="color:#ff0000;font-weight:bold;">要対応項目数: {write:member_object->'remain_correspond'}件</span><br />{/if}
		</td>
		<td style="text-align:right;">
			{write:number_format(member_object->'point')}Pt.
		</td>
		<td style="text-align:left;">
			<a href="./member/reject/form.php?mi={write:member_object->'member_id'}">メール拒否設定</a><br />
			<a href="javascript:memberMemberHistoryLogin('{write:member_object->'member_id'}')">ログイン履歴</a><br />
			<a href="javascript:memberMemberHistoryPoint('{write:member_object->'member_id'}')">ポイント履歴</a><br />
			<a href="javascript:memberMemberCorrespond('{write:member_object->'member_id'}')">対応履歴</a>
		</td>
	</tr>
	{/foreach}
	</table>
	<table class="paging" style="margin:0 auto;width:100%;border-style:none;">
	<tr>
		<td style="width:6em;">
			{if:member.member.select.has_prev_page}
				<input type="button" value="前のページ" onclick="FormerCommon.prevPage()" />
			{else}
				<span style="color:#D0D0D0;">前のページ</span>
			{/if}
		</td>
		<td style="text-align:center;">
			{write:member.member.select.total_count}件  {write:member.member.select.page_number} / {write:member.member.select.total_page}ページ
		</td>
		<td style="width:6em;">
			{if:member.member.select.has_next_page}
				<input type="button" value="次のページ" onclick="FormerCommon.nextPage()" />
			{else}
				<span style="color:#D0D0D0;">次のページ</span>
			{/if}
		</td>
	</tr>
	</tbody>
	</table>
	{/if}
	