<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:content.LoadFolders}
{preset:page_title 'コンテンツ管理管理 > ページ一覧'}

	<div class="panc">
		<a href="../../" title="管理パネルのトップページを表示します">管理パネルトップ</a>
		&gt; <a href="../" title="コンテンツ管理トップページを表示します">コンテンツ管理</a>
		&gt; ページ一覧
	</div>
	<h1>コンテンツ管理 &gt; ページ一覧</h1>
	
{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
{else}

	<form name="sform" action="./index.php" method="get">
	<table style="width:95%;margin:0 auto;">
	<tody>
	<tr>
		<td>
			フォルダ選択 <select name="ccurf" onchange="contentPageGetPageList();">
			{foreach:content.folderArray folderPath}{if:preg_match('/^\\/js/',folderPath)==0 && preg_match('/^\\/upload/',folderPath)==0 && preg_match('/^\\/file/',folderPath)==0 && preg_match('/\\/images\\//',folderPath)==0}
				<option value="{write:folderPath}"
					{if:content.currentFoloder==folderPath} selected{/if}
					>{write:folderPath}</option>
			{/if}{/foreach}
			</select>
		</td>
		<td style="text-align:right;">
		</td>
	</tr>
	<tbody>
	</table>
	</form>
	<br />
	

	<form name="list" action="#">
	<table class="list" style="width:95%;margin:0 auto;">
	<thead>
	<tr>
		<th style="width:30%;white-space:nowrap;">ファイル名</th>
		<th style="width:55%;white-space:nowrap;">ページタイトル</th>
		<th style="width:15%;white-space:nowrap;">操作</th>
	</tr>
	</thead>
	<tbody id="page-list">
	</tbody>
	</table>
	<br />	
	</form>

	<form name="createform" action="./setting/form.php" method="get">
	<p style="text-align:right;">
		<input type="hidden" name="uri" value="" />
		このフォルダにページを追加 &gt;&gt; <input type="text" name="page_name" size="15" value="" />.php <input type="button" value="追加" onclick="contentPageCreatePage()" />
	<p>
	</form>
	
<style type="text/css"><!--
table.list tbody tr td {
	padding: 5px;
}
--></style>
<script language="JavaScript" type="text/javascript"><!--
/** 現在表示中のフォルダ	*/
var contentPageCurrentFolder;
/** 現在表示中のページファイル名配列	*/
var contentPageFileNameArray;
/**
 * 現在表示しているコンテンツページ一覧を削除します
 */
function contentPageDeletePages() {
	contentPageFileNameArray	= new Array();
	var tbodyObject = document.getElementById('page-list');
	if( tbodyObject ) {
		var childs = tbodyObject.childNodes;
		for( var i=childs.length-1; i>=0; i-- ) {
			tbodyObject.removeChild(childs[i]);
		}
	}
}
/**
 * コンテンツページ一覧を取得します
 */
function contentPageGetPageList() {
	// 表示中のページをいったん削除
	contentPageDeletePages();
	// ローディングイメージ表示
	var tbodyObject = document.getElementById('page-list');
	if( tbodyObject ) {
		var trElm	= document.createElement('tr');
		var tdElm	= document.createElement('td');
		var loadImg	= new Image();
		loadImg.src='/js/images/loading_s_01.gif';
		tdElm.colSpan	= 3;
		tdElm.style.textAlign	= 'center';
		tdElm.appendChild(loadImg);
		trElm.appendChild(tdElm);
		tbodyObject.appendChild(trElm);
	}
	// カレントフォルダを記録
	contentPageCurrentFolder	= document.sform.ccurf.options[document.sform.ccurf.selectedIndex].value;
	// コンテンツページ一覧を呼び出し
	contentGetContentList(contentPageCurrentFolder,contentPageGetPageListResult);
}
/**
 * コンテンツページ一覧をページに出力するコールバック関数
 */
function contentPageGetPageListResult(contentObjectArray) {
	// 表示中のページをいったん削除
	contentPageDeletePages();
	var tbodyObject = document.getElementById('page-list');
	if( tbodyObject ) {
		for( var num=0; num<contentObjectArray.length; num++ ) {
			var contentObject	= contentObjectArray[num];
			contentPageFileNameArray.push(contentObject.name);
			if( contentObject.type == 'spider-dynamic' ) {
				var trElm	= document.createElement('tr');
				var tdFile	= document.createElement('td');
				var fileUri	= contentPageCurrentFolder+'/'+contentObject.name;
				if( contentPageCurrentFolder == '/' ) {
					fileUri	= contentPageCurrentFolder+contentObject.name;
				}
				tdFile.innerHTML	= contentObject.name;
				trElm.appendChild(tdFile);
				var tdTitle	= document.createElement('td');
				tdTitle.innerHTML	= contentObject.title;
				trElm.appendChild(tdTitle);
				var tdMod	= document.createElement('td');
				tdMod.innerHTML	= '<a href="./setting/form.php?uri='+fileUri+'">設定</a>'
					+ '・<a href="./html/form.php?uri='+fileUri+'">HTML</a>'
				;
				tdMod.style.textAlign	= 'center';
				trElm.appendChild(tdMod);
				tbodyObject.appendChild(trElm);
			}
		}
	}
}
if(window.attachEvent){
	window.attachEvent('onload',contentPageGetPageList);
}else{
	window.addEventListener('DOMContentLoaded',contentPageGetPageList,false);
}
/*
 * ページ作成関数
 */
function contentPageCreatePage() {
	if( document.createform.page_name ) {
		var pageName	= document.createform.page_name.value + '.php';
		for( var num=0; num < contentPageFileNameArray.length; num++ ) {
			var extPage	= contentPageFileNameArray[num];
			if(extPage==pageName) {
				alert(pageName + 'は既に存在します!');
				return;
			}	
		}
		if( pageName && pageName.length > 0 ) {
			var uri;;
			if( contentPageCurrentFolder == '/' ) {
				uri	= contentPageCurrentFolder + pageName;
			} else {
				uri	= contentPageCurrentFolder+'/'+pageName;
			}
			document.createform.uri.value = uri;
			document.createform.submit();
		} else {
			alert('ページ名を入力してください!');
		}
	}
}
//--></script>
{/if}