#pragma once
namespace ShootingGame 
{

  namespace Event 
  {
    struct Init{};
    struct PushStart {};
    struct PushSoundEdit {};
    struct TimeOut {};
    struct Update {};
    struct Render {};
    struct Escape {};
    struct Back {};
  }
  
  ref class GameMain; 
  
  struct GameStateMachine {
    explicit  GameStateMachine(GameMain^ main);
    template <class Event> void ProcessEvent(Event const& e);
    void Start();
    void Stop();
    ~GameStateMachine();
  private:
    struct impl;
    std::unique_ptr<impl> impl_;
  };

}

