//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// Game.h: Game NX̃C^[tFCX
//	F
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
///////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_GAME_H__C0DEC307_4A6A_48CD_B72C_4513D6C4580E__INCLUDED_)
#define AFX_GAME_H__C0DEC307_4A6A_48CD_B72C_4513D6C4580E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "sfinterface.h"
#include "sceneType.h"

namespace sf {
	namespace application {
		namespace scene {

class SF_INTERFACE Game  
{
public:
	Game(){};
	virtual ~Game(){};
	
	// Game C^[tF[Xdl\́A񋓕ϐ
	
	struct Data {
		std::string mapFileName;		// }bvt@C
		std::string dispositionFileName;// zuf[^
		std::string bgmFileName;		// BGMf[^
	};

	// Փxݒ
	enum DIFFICULTY {
		EASY,
		NORMAL,
		HARD
	};

	// Q[̏
	enum STATE {
		INITIALIZE,
		START,
		MAIN,
		RESTART,
		CLEAR,
		OVER
	};

	
	// OPERATOR //
	
	
	// OPERATIONS //

	// vC[\
	virtual void printPlayerInfo() = 0;
	// f[^GfBbg\
	virtual void printEditInfo() = 0;
	// Q[f[^[h
	virtual void load(const char * const pFileName) = 0;

	// ACCESS //

	// wi //
	virtual sf::system::console::Background * const background(void) = 0;
	
	// @ //
	virtual sf::application::Character * const player(void) = 0;
	
	// Փx 
	virtual const DIFFICULTY difficulty(void) const  = 0 ;
	virtual void difficulty(const DIFFICULTY value) = 0;
	
	// ݂̓Փx
	virtual const float currentDifficulty(void) const = 0;
	virtual void currentDifficulty(const float value) = 0;

	// Xe[W No 
	virtual void stageNo(const int value) = 0;
	virtual const int stageNo() const = 0;
	
	// XN[x 
	virtual void scrollSpeed(const float value) = 0;
	virtual const float scrollSpeed(void) const  = 0;
	
	// XRA
	virtual void score(const int value) = 0;
	virtual const int score(void) const = 0;
	
	// XN[Y ʒu 
	virtual void scrollY(const float value) = 0;
	virtual const float scrollY(void) const = 0;
	
	// X^[gʒu̐ݒ 
	virtual void restartPosition(const float value) = 0;
	virtual const float restartPosition(void) const = 0;

	// zuf[^IuWFNg 
	virtual sf::application::disposition::Controller* const controllerPtr(void) = 0; 

	//  
	virtual void state(const STATE value) = 0;
	virtual const STATE state(void) const = 0;

	// ^C}
	virtual	const int timer (void) const = 0;
	

};// Game
		}// scene
	}// application 
}//sf

#endif // !defined(AFX_GAME_H__C0DEC307_4A6A_48CD_B72C_4513D6C4580E__INCLUDED_)
