//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// FadeImpl.cpp: FadeImpl NX̃Cve[V
//  @tF[hCEtF[hAEgV[NXłB
//	:
// $Log: FadeImpl.cpp,v $
// Revision 1.1  2001/10/28 21:40:36  fujiwara
// DLLɕ
//
// Revision 1.5  2001/07/09 20:30:08  fujiwara
// Ȏgݍ
//
// Revision 1.4  2001/07/01 21:30:33  fujiwara
// [N`FbN
//
// Revision 1.3  2001/07/01 01:03:44  fujiwara
// const ̌
// zuGfB^͓ro
//
// Revision 1.2  2001/05/12 00:50:33  fujiwara
// bur𓱓AO\ǉ
//
//	2001/01/29 [[NopCu̒ǉ 
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
// Copyright (C) 2000 Satoshi Fujiwara. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
#pragma warning( disable : 4786 )	//STĽxO

// [[Nop
#include "sfdebug.h"

// System Includes //
#include <stack>
#include <list>

// Project Includes //
#include "exception.h"
#include "system.h"
#include "sound.h"
#include "console.h"
#include "Obj.h"
#include "Obj2D.h"
#include "ObjRectangle.h"
#include "ObjQuadrangle.h"
#include "input.h"
#include "Scene.h"
#include "main.h"
#include "AbstractScene.h"

#include "FadeImpl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace sf::application::scene;

// RXgN^ |||||||||||||||||||||||||||||
FadeImpl::FadeImpl()
{
	mbMove = false;
	system::System* mpSystem = system::instance();
	mpSound = mpSystem->sound();

	mStartColor = (0xff000000);
	mEndColor = 0x00000000;
	mSpeed = 0.05f;
	mType = Fade::FADE_IN;
	mbFadeVolume = true;

	mFadeObj.x(system::console::viewport::X + (system::console::viewport::WIDTH/2.0f));
	mFadeObj.y(0.0f + (system::console::viewport::HEIGHT / 2.0f));
	mFadeObj.z(0.0f);
	mFadeObj.sprite(Maininstance()->getBlankSprite());
	mFadeObj.scalingX(25.0f);
	mFadeObj.scalingY(60.0f);
	mFadeObj.color(mStartColor);
	mFadeObj.visibility(true);
	mFadeObj.drawMode(system::console::DRAW_TRANS);

	initialize();
}// FadeImpl();

// fXgN^ ||||||||||||||||||||||||||||||
FadeImpl::~FadeImpl()
{

}// FadeImpl()

//  |||||||||||||||||||||||||||||||
void FadeImpl::initialize(){
	
	if(mType == Fade::FADE_IN)
		mCurrent = 1.0f;
	else
		mCurrent = 0.0f;

	mEnd = (float)((mEndColor & 0xff000000) >> 24) / 256.0f; 

	float pitch_ = (mStartColor & 0xff000000) >> 24;
	
	// ZO邽߂̏u
	if(!pitch_) pitch_ = 0.00001f;
	if(!mSpeed) mSpeed = 0.00001f;
	
	if(mbFadeVolume){
		mVolumePitch = ((float)system::sound::volume::MIN - (float)mpSound->volumeMax()) 
			/  (((float)pitch_) / (mSpeed * 256.0f));
		pitch_ = ((mStartColor - mEndColor) & 0xff000000) >> 24;
	
		if(!pitch_) pitch_ = 0.0001f;
		if(mType == Fade::FADE_IN){
			mVolumePitch = ((float)system::sound::volume::MIN- (float)mpSound->volumeMax()) 
				/  (((float)pitch_) / (mSpeed * 256.0f));
			mVolume = (float)system::sound::volume::MIN;
		} else {
			mVolumePitch = ((float)system::sound::volume::MIN - (float)mpSound->volumeMax()) 
				/  (((float)pitch_) / (mSpeed * 256.0f));
			mVolume = (float)mpSound->volumeMax();
		}
	}
}// initialize()

// FadeImpl ------------------------------------------------------------------- 
void FadeImpl::move(void)
{
	mbMove = true;
	mCurrent -= mSpeed;
	
	if(mbFadeVolume)
		mVolume -= mVolumePitch;
	
	DWORD color = (((DWORD)(256.0f * mCurrent)) << 24) + (mStartColor & 0xffffff);
		
	// dwhsL[ꂽ?
	if(mpInput->exit(true)){
		callSceneEvent(&Listener::exitKeyPressed);
		delete this;
		return;
	}

	// I`FbN 
	if((mCurrent <= mEnd && mType == Fade::FADE_IN) || 
		(mCurrent >= mEnd && mType == Fade::FADE_OUT) || mpInput->start(true))
	{
		callSceneEvent(&Listener::endOfScene);
		delete this;
		return;
	}


	mFadeObj.color(color);

	//  
	if(mbFadeVolume)
		mpSound->masterVolume((int)mVolume);

	return;
}// FadeImpl