#!/bin/sh
#
# $Id: $
#

prefix="/usr/local"
action=
option=
target="all"
boost=
log=`pwd`/install.log
cc=
cxx=
makeopt=
installstrip=
debug=

install()
{
	if test ! -f config.h; then
		config=$1
		if test "x$boost" != "x"; then
			config="$config --with-boost=$boost"
		fi
#		if test "x$option" != "x"; then
#			config="$config --enable-$option"
#		fi

		config="$config --prefix=$prefix --disable-static"
		echo "*** run configure ***"
		echo "$config"
		$config
		if test $? != 0; then
			echo "*** Error The installation failed."
			return 1
		fi
	fi

	echo "*** Run Make ***"
	if test "x$makeopt" != x ; then
		echo "Make Options $makeopt"
	fi
	make $makeopt
	if test $? != 0; then
		echo "*** Error The installation failed."
		return 1
	fi

	echo "*** Run Make Install ***"
	if test "x"$installstrip = xon ; then
		echo "Make Install-Strip"
		make install-strip
	else
		make install
	fi
	if test $? != 0; then
		echo "*** Error The installation failed."
		return 1
	fi

	return 0
}


do_action()
{
	__t=$1
	__c=$2
	__p=`pwd`

	if test "$__t" != "all" && test "$__t" != "sl" && test "$__t" != "sa" && test "$__t" != "si" && test "$__t" != "sj"; then
		echo "Unknown target :\"$__t\"."
		echo "Try \`${0} --help' for more information."
		exit 1
	fi

	if test "$__t" = "all" || test "$__t" = "sl"; then
		echo "Entering Shibainu libraries. Run \"$__c\""
		cd shibainu-common
		$__c
		if test $? != 0; then
			exit 1
		fi
		cd $__p
	fi
	if test "$__t" = "all" || test "$__t" = "sa"; then
		echo "Entering Shibainu C++ Servlet API. Run \"$__c\""
		cd shibainu-servletapi
		$__c
		if test $? != 0; then
			exit 1
		fi
		cd $__p
	fi
	if test "$__t" = "all" || test "$__t" = "si"; then
		echo "Entering Shibainu Servlet Container. Run \"$__c\""
		cd shibainu
		$__c
		if test $? != 0; then
			exit 1
		fi
		cd $__p
	fi
	if test "$__t" = "all" || test "$__t" = "sj"; then
		echo "Entering Shibainu JSP Engine. Run \"$__c\""
		cd shibainu-jspruntime
		$__c
		if test $? != 0; then
			exit 1
		fi
		cd $__p
	fi
}


for i in $@
do
	case $i in
	-h|--help)
		echo "Usage: ${0} [options] action"
		echo "action:"
		echo "  -h, --help          display this help and exit"
		echo "  -b, --build         runs autotools script, to make \"configure\" script."
		echo "  -n, --buildclean    runs autotools script, to erase \"configure\" script."
		echo "  -i, --install       installs all applications"
		echo "  -u, --uninstall     uninstalls all applications"
		echo "  -c, --clean         \"make clean\" is executed for all the applications"
		echo "  -d, --distclean     \"make distclean\" is executed for all the applications"
		echo "options:"
		echo "  --prefix=dir        installation directory is specified"
		echo "                      default is \"/usr/local\""
		echo "  --target=app        build only \"app\" application"
		echo "                      specify library name."
		echo "                        sl: Shibainu Common Library"
		echo "                        sa: Shibainu C++ Servlet API"
		echo "                        si: Shibainu Servlet Container"
		echo "                        sj: Shibainu JSP Engine"
		echo "  --boost=dir         Boost library is specified."
		echo "  --cc=compiler       The C compiler can be specified."
		echo "  --cxx=compiler      The C++ compiler can be specified."
		echo "  --job=num           It uses it as the option \"-j num\" of Make."
		echo "  --debug             Enables debug option."
		echo "  --strip             \"strip\" is done with the installation."
		exit 0
		;;
	--prefix=*)
		prefix=`echo $i | sed -n 's/.*=//gp'` ;;
	--target=*)
		target=`echo $i | sed -n 's/.*=//gp'` ;;
	--boost=*)
		boost=`echo $i | sed -n 's/.*=//gp'` ;;
	--cc=*) 
		cc=`echo $i | sed -n 's/.*=//gp'` ;;
	--cxx=*) 
		cxx=`echo $i | sed -n 's/.*=//gp'` ;;
	--job=*) 
		makeopt="$makeopt -j `echo $i | sed -n 's/.*=//gp'`" ;;
	-b|--build)
		action=build ;;
	-n|--buildclean)
		action=buildclean ;;
	-i|--install)
		action=install ;;
	-u|--uninstall)
		action=uninstall ;;
	-c|--clean)
		action=clean ;;
	-d|--distclean)
		action=distclean ;;
	-g|--debug)
		debug=on ;;
	-s|--strip)
		installstrip=on ;;
	*)
		echo "Unknown option :\"$i\"."
		echo "Try \`${0} --help' for more information."
		exit 1
		;;
	esac

	shift
done


if test "x$action" = "xinstall";then
	pwd=`pwd`
	rm -f $log

	echo "The installation processing begins."
	echo "Prefix is $prefix"
	echo "Prefix is $prefix" >> $log

	if test "x"$cc != x ; then
		echo "C Compiler $cc"
		export CC=$cc
	fi
	if test "x"$cxx != x ; then
		echo "C++ Compiler $cxx"
		export CXX=$cxx
	fi

	#
	# ----- shibainu librarary -----
	#
	if test "$target" = "all" || test "$target" = "sl"; then
		echo "Shibainu Common Library is installing."
		echo "Shibainu Common Library is installing." >> $log
		__c="./configure"

		cd shibainu-common
		install "$__c" >> $log 2>&1
		if test $? != 0; then
			cd $pwd
			echo "*** Error The installation failed."
			exit 1
		fi
		cd $pwd
	fi

	#
	# ----- cpp servlet api -----
	#
	if test "$target" = "all" || test "$target" = "sa"; then
		echo "Shibainu C++ Servlet API is installing."
		echo "Shibainu C++ Servlet API is installing." >> $log
		__c="./configure --with-sl=$prefix"

		cd shibainu-servletapi
		install "$__c" >> $log 2>&1
		if test $? != 0; then
			cd $pwd
			echo "*** Error The installation failed."
			exit 1
		fi
		cd $pwd
	fi

	#
	# ----- shibainu container -----
	#
	if test "$target" = "all" || test "$target" = "si"; then
		echo "Shibainu Servlet Container is installing."
		echo "Shibainu Servlet Container is installing." >> $log
		__c="./configure --with-sl=$prefix --with-servlet=$prefix"

		cd shibainu
		install "$__c" >> $log 2>&1
		if test $? != 0; then
			cd $pwd
			echo "*** Error The installation failed."
			exit 1
		fi
		cd $pwd
	fi

    if test "$target" = "all"; then
	    echo "
-------------------------------------------------------------------------------
                      The installation was completed

       please set the environment variable \"SHIBAINU_HOME\" to
       "\"$prefix/shibainu-\${version}\"" before it executes it.

       please do the following to execution and the stop.
       Beginning is input, \"\$SHIBAINU_HOME/bin/shibainu\"
       The end is input, \"killall -KILL shibainu\"

-------------------------------------------------------------------------------
"
        fi

	#
	# ----- Shibainu JSP Engine -----
	#
	if test "$target" = "all" || test "$target" = "sj"; then
		echo "Shibainu JSP Engine is installing."
		echo "Shibainu JSP Engine is installing." >> $log
		__c="./configure --with-sl=$prefix --with-servlet=$prefix --with-si=$prefix"

		cd shibainu-jspruntime
		install "$__c" >> $log 2>&1
		if test $? != 0; then
			cd $pwd
			echo "*** Error The installation failed."
			exit 1
		fi
		cd $pwd
	fi

	echo "Success"
#
# --build
#
elif test "x$action" = "xbuild";then
	do_action $target $cmd "./build/gen_config.sh -b"

#
# --buildclean
#
elif test "x$action" = "xbuildclean";then
	do_action $target $cmd "./build/gen_config.sh -c"

#
# --install
#
elif test "x$action" = "xuninstall";then
	do_action $target $cmd "make uninstall"

#
# --clean
#
elif test "x$action" = "xclean";then
	do_action $target $cmd "make clean"

#
# --distclean
#
elif test "x$action" = "xdistclean";then
	do_action $target $cmd "make distclean"

#
# unknown actions
#
else
	echo "Please specify what do \"action\"."
	echo "Try \`${0} --help' for more information."
fi
