/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ServletResponseTest.cpp,v 1.16 2007/09/03 13:43:13 cvsuser Exp $
 */

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace sl::java::util;
using namespace servlet;


class ServletResponseTest : public GenericServlet {
public :

	void service(ServletRequest& request, ServletResponse& response)
		throw(ServletException)
	{
		response.setContentType("text/html;charset=EUC-JP");

		ServletOutputStream& out = response.getOutputStream();
		std::string s("<html>");
		out.write(s, 0, s.length());

		out.println("<head>");
		out.println("<title>Testing Servlets</title>");
		out.println("</head>");
		out.println("<body bgcolor=\"white\">");
		out.println("<h3>ServletResponse Test</h3>");

		//
		// Test of 'ServletResponse::setContentLength' function.
		//
		if (request.getParameter("test") == "type3") {
			String value = request.getParameter("value");
			int v = Integer::valueOf(value);

			response.setContentLength(v);
			out.println("Test of \"ServletResponse::setContentLength(");
			out.println(value);
			out.println(")\" function.");
			out.println("<br /><br />");
		}

		out.println("<table border=0>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletResponse::getCharacterEncoding");
		out.println("</td><td>");
		out.println(response.getCharacterEncoding());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletResponse::getContentType");
		out.println("</td><td>");
		out.println(response.getContentType());
		out.println("</td></tr>");

		//
		// Test of 'ServletResponse::setBufferSize' function.
		//
		if (request.getParameter("test") == "type2") {
			String value = request.getParameter("value");
			int v = Integer::valueOf(value);

			response.setBufferSize(v);

			out.println("Test of \"ServletResponse::setBufferSize(");
			out.println(value);
			out.println(")\" function.");
			out.println("<br /><br />");
		}

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletResponse::getBufferSize");
		out.println("</td><td>");
		out.println(response.getBufferSize());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletResponse::isCommitted");
		out.println("</td><td>");
		out.println(response.isCommitted());
		out.println("</td></tr>");

		out.println("</table>");

		out.println("<br />");

		//
		// Test of 'ServletResponse::reset' function.
		//
		if (request.getParameter("test") == "type1") {
			response.reset();

			response.setContentType("text/html;charset=ISO-8859-1");
			out.println("Test of \"ServletResponse::reset\" function.<br /><br />");
		}

		out.println("Invoke ServletResponseTest with Get Method<br />");
		out.println("<form method=\"GET\" ");
		out.println("action=\"/testing-servlets/servlets/ServletResponseTest\">");
		out.println("<select name=\"test\">");
		out.println("<option value=\"type0\">");
		out.println("<option value=\"type1\">ServletResponse::reset");
		out.println("<option value=\"type2\">ServletResponse::setBufferSize");
		out.println("<option value=\"type3\">ServletResponse::setContentLength");
		out.println("</select>");
		out.println("Value:");
		out.println("<input type=text size=10 name=value><br />\n");
		out.println("<input type=\"submit\" value=\"submit\" />");
		out.println("</form>");

		out.println("</body>");
		out.println("</html>");

		response.flushBuffer();
		out.println("TEST");
	}
};

SL_REGIST_LOADABLE_CLASS(ServletResponseTest)
