/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ServletRequestTest.cpp,v 1.21 2008/03/11 15:54:31 cvsuser Exp $
 */

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace sl::java::util;
using namespace servlet;


class ServletRequestTest : public GenericServlet {
public :

	void service(ServletRequest &req, ServletResponse &res)
		throw(ServletException)
	{
		ServletRequestWrapper request(req);
		ServletResponseWrapper response(res);

		response.setContentType("text/html;charset=EUC-JP");

		PrintWriter out = response.getWriter();
		out.println("<html>");
		out.println("<head>");
		out.println("<title>Testing Servlets</title>");
		out.println("</head>");
		out.println("<body bgcolor=\"white\">");
		out.println("<h3>ServletRequest Test</h3>");

		out.println("<p>ServletRequest::getParameterNames</p>");
		out.println("<table border=0>");
		Enumeration p = request.getParameterNames();
		while (p.hasMoreElements()) {
			try {
				std::string name = sl::object_cast<std::string>(p.nextElement());
				std::string value = request.getParameter(name);
				out.println("<tr><td bgcolor=\"#CCCCCC\">");
				out.println(name);
				out.println("</td><td>");
				out.println(value);
				out.println("</td></tr>");
			} catch (std::bad_cast& e) {
				std::cerr << "ServletRequestTest:" << e.what() << std::endl;
			}
		}
		out.println("</table>");

		out.println("<p>ServletRequest::setAttribute</p>");
		request.setAttribute("attribute1", "value1");
		request.setAttribute("attribute2", "value2");
		request.setAttribute("attribute3", "value3");

		out.println("<p>ServletRequest::getAttributeNames</p>");
		out.println("<table border=0>");
		p = request.getAttributeNames();
		while (p.hasMoreElements()) {
			try {
				std::string name = sl::object_cast<std::string>(p.nextElement());
				std::string value = sl::object_cast<std::string>(request.getAttribute(name));
				out.println("<tr><td bgcolor=\"#CCCCCC\">");
				out.println(name);
				out.println("</td><td>");
				out.println(value);
				out.println("</td></tr>");
			} catch (std::bad_cast& e) {
				std::cerr << "ServletRequestTest:" << e.what() << std::endl;
			}
		}
		out.println("</table>");

		out.println("<table border=0>");
		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getCharacterEncoding");
		out.println("</td><td>");
		out.println(request.getCharacterEncoding());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getContentLength");
		out.println("</td><td>");
		out.println(request.getContentLength());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getContentType");
		out.println("</td><td>");
		out.println(request.getContentType());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getLocalName");
		out.println("</td><td>");
		out.println(request.getLocalName());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getLocalAddr");
		out.println("</td><td>");
		out.println(request.getLocalAddr());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getLocalPort");
		out.println("</td><td>");
		out.println(request.getLocalPort());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getRemoteAddr");
		out.println("</td><td>");
		out.println(request.getRemoteAddr());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getRemoteHost");
		out.println("</td><td>");
		out.println(request.getRemoteHost());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getRemotePort");
		out.println("</td><td>");
		out.println(request.getRemotePort());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getServerName");
		out.println("</td><td>");
		out.println(request.getServerName());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getServerPort");
		out.println("</td><td>");
		out.println(request.getServerPort());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getProtocol");
		out.println("</td><td>");
		out.println(request.getProtocol());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::getScheme");
		out.println("</td><td>");
		out.println(request.getScheme());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletRequest::isSecure");
		out.println("</td><td>");
		out.println(request.isSecure());
		out.println("</td></tr>");

		out.println("</table>");
		out.println("<br /><br />");

		out.println("<p>ServletRequest::getInputStream</p>\n");

//		ServletInputStream& in = request.getInputStream();
//		InputStreamReader is(in);
//		BufferedReader br(is);

/*		BufferedReader* br = new BufferedReader(new InputStreamReader(in)); */
		BufferedReader br = request.getReader();

		out.println("<table>");
		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("</td><td>");

#if 1	/* POST ǡΥƥȤϰʲΤ褦ɤ߹. */
		String line;
		while ((line = br.readLine()) != "null") {
			out.println(line);
			out.println("<br />");
		}
#else
		std::vector<char> bytes;
		while (br.read(bytes, 0, 1024) != -1) {
			out.write(bytes);
			bytes.clear();
		} 
#endif
		out.println("</td></tr>");

		out.println("</table>");
		out.println("<br />");

		out.println("Invoke ServletRequestTest with Get Method<br />"); 
		out.println("<form method=\"GET\" ");
		out.println("action=\"/testing-servlets/servlets/ServletRequestTest\">");
		out.println("Value1:");
		out.println("<input type=text size=20 name=value1><br />\n");
		out.println("Value2:");
		out.println("<input type=text size=20 name=value2>\n");
		out.println("<input type=\"submit\" value=\"submit\" />"); 
		out.println("</form>");

		out.println("Invoke ServletRequestTest with Post Method<br />"); 
		out.println("<form method=\"POST\" ");
		out.println("action=\"/testing-servlets/servlets/ServletRequestTest\">");
		out.println("Value1:");
		out.println("<input type=text size=20 name=value1><br />\n");
		out.println("Value2:");
		out.println("<input type=text size=20 name=value2>\n");
		out.println("<input type=\"submit\" value=\"submit\" />"); 
		out.println("</form>");

		out.println("Post file to ServletRequestTest<br />"); 
		out.println("<form method=\"POST\" ");
		out.println("enctype=\"multipart/form-data\" ");
		out.println("action=\"/testing-servlets/servlets/ServletRequestTest\">");
		out.println("<input type=\"file\" name=\"submitfile\" />");
		out.println("<input type=\"submit\" value=\"submit\" />"); 
		out.println("</form>");

		out.println("</body>");
		out.println("</html>");
	}
};

SL_REGIST_LOADABLE_CLASS(ServletRequestTest)
