/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ServletContextTest.cpp,v 1.12 2008/03/11 15:54:31 cvsuser Exp $
 */

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace sl::java::util;
using namespace servlet;
using namespace servlet::http;


class ServletContextTest : public HttpServlet {
public :

	void service(HttpServletRequest &request, HttpServletResponse &response)
		throw(ServletException)
	{
		response.setContentType("text/html;charset=EUC-JP");

		ServletContext &context = getServletContext();

		PrintWriter out = response.getWriter();
		out.println("<html>");
		out.println("<head>");
		out.println("<title>ServletContext Test</title>");
		out.println("</head>");
		out.println("<body bgcolor=\"white\">");
		out.println("<h3>ServletContext Test</h3>");

		out.println("<p>ServletContext::getInitParameterNames</p>");
		out.println("<table border=0>");
		Enumeration e = context.getInitParameterNames();
		while (e.hasMoreElements()) {
			try {
				std::string name = sl::object_cast<std::string>(e.nextElement());
				std::string value = context.getInitParameter(name);
				out.println("<tr><td bgcolor=\"#CCCCCC\">");
				out.println(name);
				out.println("</td><td>");
				out.println(value);
				out.println("</td></tr>");
			} catch (std::bad_cast) {
				continue;
			}
		}
		out.println("</table>");

		out.println("<table border=0>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletContext::getMajorVersion");
		out.println("</td><td>");
		out.println(context.getMajorVersion());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletContext::getMinorVersion");
		out.println("</td><td>");
		out.println(context.getMinorVersion());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletContext::getServerInfo");
		out.println("</td><td>");
		out.println(context.getServerInfo());
		out.println("</td></tr>");

		std::string uri = request.getRequestURI();
		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.print("ServletContext::getRealPath (\"" + uri + "\")");
		out.println("</td><td>");
		out.println(context.getRealPath(uri));
		out.println("</td></tr>");

        if (request.getParameter("test") == "pattern1") {
            String value = request.getParameter("value");

			out.println("<tr><td bgcolor=\"#CCCCCC\">");
			out.print("ServletContext::getRealPath (\"");
			out.print(value);
			out.println("\")");
			out.println("</td><td>");
			out.println(context.getRealPath(value));
			out.println("</td></tr>");
		}

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletContext::getServletContextName");
		out.println("</td><td>");
		out.println(context.getServletContextName());
		out.println("</td></tr>");

		out.println("</table>");

		out.println("Invoke ServletContextTest with Get Method<br />");
		out.println("<form method=\"GET\" ");
		out.println("action=\"/testing-servlets/servlets/ServletContextTest\">");
		out.println("<select name=\"test\">");
		out.println("<option value=\"pattern1\">getRealPath");
		out.println("<option value=\"pattern2\">Test Pattern 2");
		out.println("<option value=\"pattern3\">Test Pattern 3");
		out.println("</select>");
		out.println("Value:");
		out.println("<input type=text size=10 name=value><br />\n");
		out.println("<input type=\"submit\" value=\"submit\" />");
		out.println("</form>");

		out.println("</body>");
		out.println("</html>");

		ServletException ex("TEST2");
		log("TEST1");
		log("TEST2", ex);
	}
};

SL_REGIST_LOADABLE_CLASS(ServletContextTest)
