/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ServletConfigTest.cpp,v 1.9 2008/03/11 15:54:31 cvsuser Exp $
 */

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace sl::java::util;
using namespace servlet;


class ServletConfigTest : public GenericServlet {
public :

	void service(ServletRequest& /* request */, ServletResponse& response)
		throw(ServletException)
	{
		response.setContentType("text/html;charset=EUC-JP");

		PrintWriter out = response.getWriter();

		out.println("<html>");
		out.println("<head>");
		out.println("<title>ServletConfig Test</title>");
		out.println("</head>");
		out.println("<body bgcolor=\"white\">");
		out.println("<h3>ServletConfig Test</h3>");

		out.println("<p>ServletConfig::getParameterNames</p>");
		out.println("<table border=0>");
		Enumeration e = getInitParameterNames();
		while (e.hasMoreElements()) {
			try {
				std::string name = sl::object_cast<std::string>(e.nextElement());
				std::string value = getInitParameter(name);
				out.println("<tr><td bgcolor=\"#CCCCCC\">");
				out.println(name);
				out.println("</td><td>");
				out.println(value);
				out.println("</td></tr>");
			} catch (std::bad_cast) {
				continue;
			}
		}
		out.println("</table>");
		out.println("<br />");

		out.println("<table border=0>");
		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("ServletConfig::getServletName");
		out.println("</td><td>");
		out.println(getServletName());
		out.println("</td></tr>");
		out.println("</table>");

		out.println("</body>");
		out.println("</html>");
	}
};

SL_REGIST_LOADABLE_CLASS(ServletConfigTest)
