/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: RequestDispatcherTest.cpp,v 1.7 2008/03/11 15:54:31 cvsuser Exp $
 */

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace sl::java::util;
using namespace servlet;


class RequestDispatcherTest : public GenericServlet {
public :

	void service(ServletRequest &request, ServletResponse &response)
		throw(ServletException)
	{
		response.setContentType("text/html;charset=EUC-JP");

		PrintWriter out = response.getWriter();
		out.println("<html>");
		out.println("<head>");
		out.println("<title>RequestDispatcher Test</title>");
		out.println("</head>");
		out.println("<body bgcolor=\"white\">");
		out.println("<h3>RequestDispatcher Test</h3>");
		out.println("<br />");

        if (request.getParameter("test") == "pattern1") {
            std::string value = request.getParameter("value");
			out.println("<p>RequestDispatcher::include<br />");
			out.println("<p> --- START --- <br />");
			std::auto_ptr<RequestDispatcher> rd =
							getServletContext().getRequestDispatcher(value);
			rd->include(request, response);
			out.println("<br /><p> --- END --- <br />");
		}

        if (request.getParameter("test") == "pattern2") {
            String value = request.getParameter("value");

			out.println("<p>RequestDispatcher::forward<br />");
			std::auto_ptr<RequestDispatcher> rd =
							getServletContext().getRequestDispatcher(value);
			rd->forward(request, response);
		}

		out.println("Invoke RequestDispatcherTest with Get Method<br />");
		out.println("<form method=\"GET\" ");
		out.println("action=\"/testing-servlets/servlets/RequestDispatcherTest\">");
		out.println("<select name=\"test\">");
		out.println("<option value=\"pattern0\">Test Pattern 0, nothing");
		out.println("<option value=\"pattern1\">Test Pattern 1, include");
		out.println("<option value=\"pattern2\">Test Pattern 2, forward");
		out.println("</select>");
		out.println("Value:");
		out.println("<input type=text size=20 name=value><br />\n");
		out.println("<input type=\"submit\" value=\"submit\" />");
		out.println("</form>");

		out.println("</table>");
		out.println("</body>");
		out.println("</html>");
	}
};

SL_REGIST_LOADABLE_CLASS(RequestDispatcherTest)
