/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: HttpServletResponseTest.cpp,v 1.5 2007/09/03 13:43:13 cvsuser Exp $
 */

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace sl::java::util;
using namespace servlet;
using namespace servlet::http;


class HttpServletResponseTest : public HttpServlet {
public :

	void doGet(HttpServletRequest &request, HttpServletResponse &response)
		throw(ServletException)
	{
		response.setContentType("text/html;charset=EUC-JP");

		PrintWriter out = response.getWriter();
		out.println("<html>");
		out.println("<head>");
		out.println("<title>HttpServletResponse Test</title>");
		out.println("</head>");
		out.println("<body bgcolor=\"white\">");

		out.println("<h3>HttpServletResponse Test</h3>");

        if (request.getParameter("test") == "pattern1") {
            String value = request.getParameter("value");

			out.println("<p>HttpServletResponse::addCookie<br />");
			out.print("Cookie(\"value\", ");
			out.print(value);
			out.println(");</p>");

			Cookie c("value", value);
			response.addCookie(c);
		}

		out.println("<br />");

        if (request.getParameter("test") == "pattern2") {
            String value = request.getParameter("value");

			out.println("<p>HttpServletResponse::addHeader<br />");
			out.print("addHeader(\"value\", ");
			out.print(value);
			out.println(");</p>");

			response.addHeader("value", value);
		}

        if (request.getParameter("test") == "pattern3") {
            String value = request.getParameter("value");
			int v = Integer::valueOf(value);

			response.sendError(v);
		}

        if (request.getParameter("test") == "pattern4") {
            String value = request.getParameter("value");
			response.sendRedirect(value);
		}

		out.println("<br />");

		out.println("Invoke HttpServletResponseTest with Get Method<br />");
		out.println("<form method=\"GET\" ");
		out.println("action=\"/testing-servlets/servlets/HttpServletResponseTest\">");
		out.println("<select name=\"test\">");
		out.println("<option value=\"pattern0\">Test Pattern 0, nothing");
		out.println("<option value=\"pattern1\">Test Pattern 1, addCookie");
		out.println("<option value=\"pattern2\">Test Pattern 2, addHeader");
		out.println("<option value=\"pattern3\">Test Pattern 3, sendError");
		out.println("<option value=\"pattern4\">Test Pattern 4, sendRedirect");
		out.println("</select>");
		out.println("Value:");
		out.println("<input type=text size=10 name=value><br />\n");
		out.println("<input type=\"submit\" value=\"submit\" />");
		out.println("</form>");

		out.println("Invoke HttpServletResponseTest with Post Method<br />");
		out.println("<form method=\"POST\" ");
		out.println("action=\"/testing-servlets/servlets/HttpServletResponseTest\">");
		out.println("<select name=\"test\">");
		out.println("<option value=\"pattern10\">Test Pattern 10");
		out.println("<option value=\"pattern11\">Test Pattern 11");
		out.println("<option value=\"pattern12\">Test Pattern 12");
		out.println("</select>");
		out.println("Value:");
		out.println("<input type=text size=10 name=value><br />\n");
		out.println("<input type=\"submit\" value=\"submit\" />");
		out.println("</form>");

		out.println("</body>");
		out.println("</html>");
	}

	void doPost(HttpServletRequest &request, HttpServletResponse &response)
		throw(ServletException)
	{
		doGet(request, response);
	}
};

SL_REGIST_LOADABLE_CLASS(HttpServletResponseTest)
