/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: HttpServletRequestTest.cpp,v 1.12 2008/03/11 15:54:31 cvsuser Exp $
 */

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace sl::java::util;
using namespace servlet;
using namespace servlet::http;


class HttpServletRequestTest : public HttpServlet {
public :

	void doGet(HttpServletRequest &request, HttpServletResponse &response)
		throw(ServletException)
	{
		response.setContentType("text/html;charset=EUC-JP");

		PrintWriter out = response.getWriter();
		out.println("<html>");
		out.println("<head>");
		out.println("<title>HttpServletRequest Test</title>");
		out.println("</head>");
		out.println("<body bgcolor=\"white\">");

		out.println("<h3>HttpServletRequest Test</h3>");
		out.println("<table border=0>");

		out.println("<p>HttpServletRequest::getHeaderNames</p>");
		Enumeration e = request.getHeaderNames();
		while (e.hasMoreElements()) {
			try {
				std::string name = sl::object_cast<std::string>(e.nextElement());
				std::string value = request.getHeader(name);
				out.println("<tr><td bgcolor=\"#CCCCCC\">");
				out.println(name);
				out.println("</td><td>");
				out.println(value);
				out.println("</td></tr>");
			} catch (std::bad_cast& e) {
				std::cerr << e.what() << std::endl;
			}
		}
		out.println("</table>");
		out.println("<br />");
		out.println("<table border=0>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::getMethod");
		out.println("</td><td>");
		out.println(request.getMethod());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::getRequestURL");
		out.println("</td><td>");
		out.println(request.getRequestURL());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::getRequestURI");
		out.println("</td><td>");
		out.println(request.getRequestURI());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::getContextPath");
		out.println("</td><td>");
		out.println(request.getContextPath());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::getServletPath");
		out.println("</td><td>");
		out.println(request.getServletPath());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::getPathInfo");
		out.println("</td><td>");
		out.println(request.getPathInfo());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::getPathTranslated");
		out.println("</td><td>");
		out.println(request.getPathTranslated());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::getQueryString");
		out.println("</td><td>");
		out.println(request.getQueryString());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::getRemoteUser");
		out.println("</td><td>");
		out.println(request.getRemoteUser());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::isUserInRole");
		out.println("</td><td>");
		out.println(request.isUserInRole());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::getRequestedSessionId");
		out.println("</td><td>");
		out.println(request.getRequestedSessionId());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::isRequestedSessionIdValid");
		out.println("</td><td>");
		out.println(request.isRequestedSessionIdValid());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::isRequestedSessionIdFromCookie");
		out.println("</td><td>");
		out.println(request.isRequestedSessionIdFromCookie());
		out.println("</td></tr>");

		out.println("<tr><td bgcolor=\"#CCCCCC\">");
		out.println("HttpServletRequest::isRequestedSessionIdFromURL");
		out.println("</td><td>");
		out.println(request.isRequestedSessionIdFromURL());
		out.println("</td></tr>");

		out.println("</table>");
		out.println("<br />");

		out.println("Invoke HttpServletRequestTest with Get Method<br />");
		out.println("<form method=\"GET\" ");
		out.println("action=\"/testing-servlets/servlets/HttpServletRequestTest\">");
		out.println("<select name=\"test\">");
		out.println("<option value=\"pattern1\">Test Pattern 1");
		out.println("<option value=\"pattern2\">Test Pattern 2");
		out.println("<option value=\"pattern3\">Test Pattern 3");
		out.println("</select>");
		out.println("Value:");
		out.println("<input type=text size=10 name=value><br />\n");
		out.println("<input type=\"submit\" value=\"submit\" />");
		out.println("</form>");

		out.println("Invoke HttpServletRequestTest with Post Method<br />");
		out.println("<form method=\"POST\" ");
		out.println("action=\"/testing-servlets/servlets/HttpServletRequestTest\">");
		out.println("<select name=\"test\">");
		out.println("<option value=\"pattern1\">Test Pattern 1");
		out.println("<option value=\"pattern2\">Test Pattern 2");
		out.println("<option value=\"pattern3\">Test Pattern 3");
		out.println("</select>");
		out.println("Value:");
		out.println("<input type=text size=10 name=value><br />\n");
		out.println("<input type=\"submit\" value=\"submit\" />");
		out.println("</form>");

		out.println("</body>");
		out.println("</html>");
	}

	void doPost(HttpServletRequest &request, HttpServletResponse &response)
		throw(ServletException)
	{
		doGet(request, response);
	}
};

SL_REGIST_LOADABLE_CLASS(HttpServletRequestTest)
