/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ErrorPageTest.cpp,v 1.1 2008/02/10 15:19:02 cvsuser Exp $
 */

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace sl::java::util;
using namespace servlet;
using namespace servlet::http;


class ErrorPageTest : public HttpServlet {
public :

	void doGet(HttpServletRequest &request, HttpServletResponse &response)
		throw(ServletException)
	{
        if (request.getParameter("test") == "test0") {
			response.sendError(404);
			return;
		}
        if (request.getParameter("test") == "test1") {
			response.sendError(486);
			return;
		}
        if (request.getParameter("test") == "test2") {
			response.sendError(999);
			return;
		}
        if (request.getParameter("test") == "test3") {
			response.sendError(500);
			return;
		}

		response.setContentType("text/html;charset=EUC-JP");

		std::ostream& out = response.getWriter();
		out << "<html>";
		out << "<head>";
		out << "<title>ErrorPage Test</title>";
		out << "</head>";
		out << "<body bgcolor=\"white\">";
		out << "<h3>ErrorPage Test</h3>";
		out << "<br />";

		out << "Invoke ErrorPageTest<br />";
		out << "<form method=\"GET\" ";
		out << "action=\"/testing-servlets/servlets/ErrorPageTest\">";
		out << "<select name=\"test\">";
		out << "<option value=\"test0\">Test 0, sendError(404) -> 404.html";
		out << "<option value=\"test1\">Test 1, sendError(486) -> 486.html";
		out << "<option value=\"test2\">Test 2, sendError(999) -> default";
		out << "<option value=\"test3\">Test 3, sendError(500) -> 500.jsp";
		out << "</select>";
		out << "<input type=\"submit\" value=\"submit\" />";
		out << "</form>";

		out << "</table>";
		out << "</body>";
		out << "</html>";
	}
};

SL_REGIST_LOADABLE_CLASS(ErrorPageTest)
