/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: CodeTestServlet.cpp,v 1.15 2007/09/02 14:07:48 cvsuser Exp $
 */

#include <sl/class_loader.hpp>
#include <sl/object.hpp>
#include <servlet/servlet_headers.h>
using namespace std;
using namespace boost;
using namespace servlet;
using namespace sl;


class CodeTestServlet : public GenericServlet {
public :

	void service(ServletRequest &request, ServletResponse &response)
		throw(ServletException)
	{
		response.setContentType("text/html;charset=EUC-JP");

		ostream& out = response.getWriter();
		out << "<html>" << endl;
		out << "<head>" << endl;
		out << "<title>Testing Servlets</title>" << endl;
		out << "</head>" << endl;
		out << "<body bgcolor=\"white\">" << endl;
		out << "<h3>Code Test</h3>" << endl;

		out << "<p>ServletRequest::getParameterNames</p>" << endl;
		out << "<table border=0>" << endl;

		typedef vector<sl::object> object_list_t;

		object_list_t objs = request.getParameterNames();
		for (object_list_t::iterator i = objs.begin(); i != objs.end(); i++) {
			try {
				string name = object_cast<string>(*i);
				string value = request.getParameter(name);
				out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
				out << name << endl;
				out << "</td><td>" << endl;
				out << value << endl;
				out << "</td></tr>" << endl;
			} catch (bad_cast& e) {
				cerr << "CodeTestServlet " << __LINE__ << " "<< e.what() << endl;
			}
		}
		out << "</table>" << endl;

		out << "<p>ServletRequest::setAttribute</p>" << endl;
		request.setAttribute("attribute1", "value1");
		request.setAttribute("attribute2", "value2");
		request.setAttribute("attribute3", "value3");

		out << "<p>ServletRequest::getAttributeNames</p>" << endl;
		out << "<table border=0>" << endl;

		objs = request.getAttributeNames();
		for (object_list_t::iterator i = objs.begin(); i != objs.end(); i++) {
			try {
				string name = object_cast<string>(*i);
				string value = object_cast<string>(request.getAttribute(name));
				out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
				out << name << endl;
				out << "</td><td>" << endl;
				out << value << endl;
				out << "</td></tr>" << endl;
			} catch (bad_cast& e) {
				cerr << "CodeTestServlet " << __LINE__ << " "<< e.what() << endl;
			}
		}
		out << "</table>" << endl;

		out << "<table border=0>" << endl;
		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getCharacterEncoding" << endl;
		out << "</td><td>" << endl;
		out << request.getCharacterEncoding() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getContentLength" << endl;
		out << "</td><td>" << endl;
		out << request.getContentLength() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getContentType" << endl;
		out << "</td><td>" << endl;
		out << request.getContentType() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getLocalName" << endl;
		out << "</td><td>" << endl;
		out << request.getLocalName() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getLocalAddr" << endl;
		out << "</td><td>" << endl;
		out << request.getLocalAddr() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getLocalPort" << endl;
		out << "</td><td>" << endl;
		out << request.getLocalPort() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getRemoteAddr" << endl;
		out << "</td><td>" << endl;
		out << request.getRemoteAddr() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getRemoteHost" << endl;
		out << "</td><td>" << endl;
		out << request.getRemoteHost() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getRemotePort" << endl;
		out << "</td><td>" << endl;
		out << request.getRemotePort() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getServerName" << endl;
		out << "</td><td>" << endl;
		out << request.getServerName() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getServerPort" << endl;
		out << "</td><td>" << endl;
		out << request.getServerPort() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getProtocol" << endl;
		out << "</td><td>" << endl;
		out << request.getProtocol() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::getScheme" << endl;
		out << "</td><td>" << endl;
		out << request.getScheme() << endl;
		out << "</td></tr>" << endl;

		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "ServletRequest::isSecure" << endl;
		out << "</td><td>" << endl;
		out << request.isSecure() << endl;
		out << "</td></tr>" << endl;

		out << "</table>" << endl;
		out << "<br /><br />" << endl;

		out << "<p>ServletRequest::getInputStream</p>" << endl;

		out << "<table>" << endl;
		out << "<tr><td bgcolor=\"#CCCCCC\">" << endl;
		out << "</td><td>" << endl;

		//
		// ܥǥʤ֤ stream ɤ߹
		// åȤɤ߹ߤ WAIT ƥॢԤȤʤäƤޤΤǡ
		// ܥǥΤɤ߹ߤԤʤ.
		// HTTPꥯȤξϤꤢǤ...
		//
		if (request.getContentLength() > 0) {
//			istream& in = request.getInputStream();
			istream& in = request.getReader();
			string file((istreambuf_iterator<char>(in)),
						 istreambuf_iterator<char>());

			out << file << endl;
		}

		out << "<br />" << endl;

		out << "</td></tr>" << endl;
		out << "</table>" << endl;
		out << "<br />" << endl;

		out << "Invoke CodeTestServlet with Get Method<br />" << endl;
		out << "<form method=\"GET\" " << endl;
		out << "action=\"/testing-servlets/servlets/CodeTestServlet\">" << endl;
		out << "Value1:" << endl;
		out << "<input type=text size=20 name=value1><br />\n" << endl;
		out << "Value2:" << endl;
		out << "<input type=text size=20 name=value2>\n" << endl;
		out << "<input type=\"submit\" value=\"submit\" />" << endl;
		out << "</form>" << endl;

		out << "Invoke CodeTestServlet with Post Method<br />" << endl;
		out << "<form method=\"POST\" " << endl;
		out << "action=\"/testing-servlets/servlets/CodeTestServlet\">" << endl;
		out << "Value1:" << endl;
		out << "<input type=text size=20 name=value1><br />\n" << endl;
		out << "Value2:" << endl;
		out << "<input type=text size=20 name=value2>\n" << endl;
		out << "<input type=\"submit\" value=\"submit\" />" << endl;
		out << "</form>" << endl;

		out << "Post file to CodeTestServlet<br />" << endl;
		out << "<form method=\"POST\" " << endl;
		out << "enctype=\"multipart/form-data\" " << endl;
		out << "action=\"/testing-servlets/servlets/CodeTestServlet\">" << endl;
		out << "<input type=\"file\" name=\"submitfile\" />" << endl;
		out << "<input type=\"submit\" value=\"submit\" />" << endl;
		out << "</form>" << endl;

		out << "</body>" << endl;
		out << "</html>" << endl;
	}
};

SL_REGIST_LOADABLE_CLASS(CodeTestServlet)
