/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*	 http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <sl/class_loader.hpp>
#include <sl/object.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace sl::java::util;
using namespace servlet;
using namespace servlet::http; 

/**
 * Example servlet showing request headers
 *
 */

class SessionExample : public HttpServlet {
public :

	void doGet(HttpServletRequest &request, HttpServletResponse &response)
		throw(ServletException)
	{
		response.setContentType("text/html;charset=ISO-8859-1");
		PrintWriter out = response.getWriter();
		out.println("<html>");
		out.println("<head>");

		std::string title = std::string("Sessions Example");
		out.println("<title>" + title + "</title>");
		out.println("</head>");
		out.println("<body>");

		out.println("<a href=\"../sessions.html\">");
		out.println("<img src=\"../images/code.gif\" height=24 ");
		out.println("width=24 align=right border=0 alt=\"view code\"></a>");
		out.println("<a href=\"../index.html\">");
		out.println("<img src=\"../images/return.gif\" height=24 ");
		out.println("width=24 align=right border=0 alt=\"return\"></a>");

		out.println("<h3>" + title + "</h3>");

		HttpSession &session = request.getSession(true);
		time_t create = session.getCreationTime();
		time_t access = session.getLastAccessedTime();
		out.println("Sessions ID: " + session.getId());
		out.println("<br>");
		out.println("Created: ");
		out.println(::ctime(&create));
		out.println("<br>");
		out.println("Last Accessed: ");
		out.println(::ctime(&access));

		std::string name  = request.getParameter("dataname");
		std::string value = request.getParameter("datavalue");
		if (!name.empty() && !value.empty())
			session.setAttribute(name, value);

		out.println("<P>");
		out.println("The following data in your session:<br>");

		Enumeration e = session.getAttributeNames();
		while (e.hasMoreElements()) {
			try {
				std::string name  = sl::object_cast<std::string>(e.nextElement());
				std::string value = sl::object_cast<std::string>(session.getAttribute(name));
				out.println(name + " = " + value + "<br>");

			} catch(std::bad_cast &e) {
				std::cerr << e.what () << std::endl;
				continue;
			}
		}

		out.println("<P>");
		out.println("<form action=\"");
		out.println(response.encodeURL("SessionExample"));
		out.println("\" ");
		out.println("method=POST>");
		out.println("Name of Sessions Attribute:");
		out.println("<input type=text size=20 name=dataname>");
		out.println("<br>");
		out.println("Value of Session Attribute:");
		out.println("<input type=text size=20 name=datavalue>");
		out.println("<br>");
		out.println("<input type=submit>");
		out.println("</form>");

		out.println("<P>GET based form:<br>");
		out.println("<form action=\"");
		out.println(response.encodeURL("SessionExample"));
		out.println("\" ");
		out.println("method=GET>");
		out.println("Name of Sessions Attribute:");
		out.println("<input type=text size=20 name=dataname>");
		out.println("<br>");
		out.println("Value of Sessions Attribute:");
		out.println("<input type=text size=20 name=datavalue>");
		out.println("<br>");
		out.println("<input type=submit>");
		out.println("</form>");

		out.println("<p><a href=\"");
		out.println(response.encodeURL("SessionExample?dataname=foo&datavalue=bar"));
		out.println("\" >URL encoded </a>");
	
		out.println("</body>");
		out.println("</html>");
	}

	void doPost(HttpServletRequest &request, HttpServletResponse &response)
		throw(ServletException)
	{
		doGet(request, response);
	}

};

SL_REGIST_LOADABLE_CLASS(SessionExample)
