/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::io;
using namespace servlet;
using namespace servlet::http;


/**
 * Example servlet showing request headers
 *
 */

class RequestParamExample : public HttpServlet {
public :

    void doGet(HttpServletRequest &request, HttpServletResponse &response)
        throw(ServletException)
    {
        response.setContentType("text/html;charset=ISO-8859-1");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");

        out.println("<title>Request Parameters Example</title>");
        out.println("</head>");
        out.println("<body bgcolor=\"white\">");

        out.println("<a href=\"../reqparams.html\">");
        out.println("<img src=\"../images/code.gif\" height=24 ");
        out.println("width=24 align=right border=0 alt=\"view code\"></a>");
        out.println("<a href=\"../index.html\">");
        out.println("<img src=\"../images/return.gif\" height=24 ");
        out.println("width=24 align=right border=0 alt=\"return\"></a>");

        out.println("<h3>Request Parameters Example</h3>");
        std::string firstName = request.getParameter("firstname");
        std::string lastName = request.getParameter("lastname");
        out.println(std::string("Parameters in this request:") + "<br>");
        if (firstName.length() || lastName.length()) {
            out.println(std::string("First Name"));
            out.println(" = " + (firstName) + "<br>");
            out.println(std::string("Last Name"));
            out.println(" = " + (lastName));
        } else {
            out.println(std::string("No Parameters, Please enter some"));
        }
        out.println("<P>");
        out.println("<form action=\"");
        out.println("RequestParamExample\" ");
        out.println("method=POST>");
        out.println("First Name:");
        out.println("<input type=text size=20 name=firstname>");
        out.println("<br>");
        out.println("Last Name:");
        out.println("<input type=text size=20 name=lastname>");
        out.println("<br>");
        out.println("<input type=submit>");
        out.println("</form>");

        out.println("</body>");
        out.println("</html>");
    }

    void doPost(HttpServletRequest &request, HttpServletResponse &response)
        throw(ServletException)
    {
        doGet(request, response);
    }

};

SL_REGIST_LOADABLE_CLASS(RequestParamExample)
