/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace servlet;
using namespace servlet::http;

/**
 * Example servlet showing request information.
 *
 */

class RequestInfoExample : public HttpServlet {
public :

    void doGet(HttpServletRequest &request, HttpServletResponse &response)
        throw(ServletException)
    {
        response.setContentType("text/html;charset=ISO-8859-1");

        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Request Information Example</title>");
        out.println("</head>");
        out.println("<body bgcolor=\"white\">");

        out.println("<a href=\"../reqinfo.html\">");
        out.println("<img src=\"../images/code.gif\" height=24 ");
        out.println("width=24 align=right border=0 alt=\"view code\"></a>");
        out.println("<a href=\"../index.html\">");
        out.println("<img src=\"../images/return.gif\" height=24 ");
        out.println("width=24 align=right border=0 alt=\"return\"></a>");

        out.println("<h3>Request Information Example</h3>");
        out.println("<table border=0><tr><td>");
        out.println(std::string("Method:"));
        out.println("</td><td>");
        out.println(request.getMethod());
        out.println("</td></tr><tr><td>");
        out.println(std::string("Request URI:"));
        out.println("</td><td>");
        out.println(request.getRequestURI());
        out.println("</td></tr><tr><td>");
        out.println(std::string("Protocol:"));
        out.println("</td><td>");
        out.println(request.getProtocol());
        out.println("</td></tr><tr><td>");
        out.println(std::string("Path Info:"));
        out.println("</td><td>");
        out.println(request.getPathInfo());
        out.println("</td></tr><tr><td>");
        out.println(std::string("Remote Address:"));
        out.println("</td><td>");
        out.println(request.getRemoteAddr());
        out.println("</table>");


        try {
            Object obj =
                    request.getAttribute("javax.servlet.request.cipher_suite");
            std::string cipherSuite = sl::object_cast<std::string>(obj);

            if (cipherSuite.empty()) {
                out.println("</td></tr><tr><td>");
                out.println("SSLCipherSuite:");
                out.println("</td>");
                out.println("<td>");
                out.println(cipherSuite);
                out.println("</td>");
            }
        } catch(std::bad_cast &e) { }

        out.println("</body>");
        out.println("</html>");
    }

    void doPost(HttpServletRequest &request, HttpServletResponse &response)
        throw(ServletException)
    {
        doGet(request, response);
    }

};

SL_REGIST_LOADABLE_CLASS(RequestInfoExample)
