/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace sl::java::util;
using namespace servlet;
using namespace servlet::http;

/**
 * Example servlet showing request headers
 *
 */

class RequestHeaderExample : public HttpServlet {
public :
    
    void doGet(HttpServletRequest &request, HttpServletResponse &response)
        throw(ServletException)
    {
#if 0
        response.setContentType("text/html;charset=ISO-8859-1");
        PrintWriter out = response.getWriter();

        out.println("<html>");
        out.println("<head>");
        out.println("<title>Request Header Example</title>");
        out.println("</head>");
        out.println("<body bgcolor=\"white\">");

        out.println("<a href=\"../reqheaders.html\">");
        out.println("<img src=\"../images/code.gif\" height=24 ");
        out.println("width=24 align=right border=0 alt=\"view code\"></a>");
        out.println("<a href=\"../index.html\">");
        out.println("<img src=\"../images/return.gif\" height=24 ");
        out.println("width=24 align=right border=0 alt=\"return\"></a>");

        out.println("<h3>Request Header Example</h3>");
        out.println("<table border=0>");

        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            try {
     	        std::string name = sl::object_cast<std::string>(e.nextElement());
                std::string value = request.getHeader(name);
                out.println("<tr><td bgcolor=\"#CCCCCC\">");
                out.println(name);
                out.println("</td><td>");
                out.println(value);
                out.println("</td></tr>");
            } catch (std::bad_cast) {
                continue;
            }
        }
        out.println("</table>");
        out.println("</body>");
        out.println("</html>");
#else
        response.setContentType("text/html;charset=ISO-8859-1");
        std::ostream& out = response.getWriter();

        out << "<html>" << std::endl;
        out << "<head>" << std::endl;
        out << "<title>Request Header Example</title>" << std::endl;
        out << "</head>" << std::endl;
        out << "<body bgcolor=\"white\">" << std::endl;

        out << "<a href=\"../reqheaders.html\">" << std::endl;
        out << "<img src=\"../images/code.gif\" height=24 " << std::endl;
        out << "width=24 align=right border=0 alt=\"view code\"></a>" << std::endl;
        out << "<a href=\"../index.html\">" << std::endl;
        out << "<img src=\"../images/return.gif\" height=24 " << std::endl;
        out << "width=24 align=right border=0 alt=\"return\"></a>" << std::endl;

        out << "<h3>Request Header Example</h3>" << std::endl;
        out << "<table border=0>" << std::endl;

        std::vector<sl::object> objs = request.getHeaderNames();
        std::vector<sl::object>::iterator i = objs.begin();
        for (; i != objs.end(); ++i) {
            try {
     	        std::string name = sl::object_cast<std::string>(*i);
                std::string value = request.getHeader(name);
                out << "<tr><td bgcolor=\"#CCCCCC\">" << std::endl;
                out << name << std::endl;
                out << "</td><td>" << std::endl;
                out << value << std::endl;
                out << "</td></tr>" << std::endl;
            } catch (std::bad_cast) {
                continue;
            }
        }
        out << "</table>" << std::endl;
        out << "</body>" << std::endl;
        out << "</html>" << std::endl;
#endif
    }

    void doPost(HttpServletRequest &request, HttpServletResponse &response)
        throw(ServletException)
    {
        doGet(request, response);
    }

};

SL_REGIST_LOADABLE_CLASS(RequestHeaderExample)
