/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::io;
using namespace servlet;
using namespace servlet::http;

/**
 * The simplest possible servlet.
 *
 */

class HelloWorldExample : public HttpServlet {
public :

    void doGet(HttpServletRequest& /* request */, HttpServletResponse& response)
        throw(ServletException)
    {
        response.setContentType("text/html;charset=ISO-8859-1");
#if 0
        PrintWriter out = response.getWriter();

        out.println("<html>");
        out.println("<head>");
        out.println("<title>Hello World!</title>");
        out.println("</head>");
        out.println("<body bgcolor=\"white\">");

        out.println("<a href=\"../helloworld.html\">");
        out.println("<img src=\"../images/code.gif\" height=24 ");
        out.println("width=24 align=right border=0 alt=\"view code\"></a>");
        out.println("<a href=\"../index.html\">");
        out.println("<img src=\"../images/return.gif\" height=24 ");
        out.println("width=24 align=right border=0 alt=\"return\"></a>");
        out.println("<h1>Hello World!</h1>");
        out.println("</body>");
        out.println("</html>");
#else
        std::ostream& out = response.getWriter();
        out << "<html>" << std::endl;
        out << "<head>" << std::endl;
        out << "<title>Hello World!</title>" << std::endl;
        out << "</head>" << std::endl;
        out << "<body bgcolor=\"white\">" << std::endl;

        out << "<a href=\"../helloworld.html\">" << std::endl;
        out << "<img src=\"../images/code.gif\" height=24 " << std::endl;
        out << "width=24 align=right border=0 alt=\"view code\"></a>" << std::endl;
        out << "<a href=\"../index.html\">" << std::endl;
        out << "<img src=\"../images/return.gif\" height=24 " << std::endl;
        out << "width=24 align=right border=0 alt=\"return\"></a>" << std::endl;
        out << "<h1>Hello World!</h1>" << std::endl;
        out << "</body>" << std::endl;
        out << "</html>" << std::endl;
#endif
    }
};

SL_REGIST_LOADABLE_CLASS(HelloWorldExample)
