/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::io;
using namespace servlet;
using namespace servlet::http;

/**
 * Example servlet showing request headers
 *
 */

class CookieExample : public HttpServlet {
public :
    
    void doGet(HttpServletRequest &request, HttpServletResponse &response)
        throw(ServletException)
    {
        response.setContentType("text/html;charset=ISO-8859-1");

        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");

        std::string title("Cookies Example");
        out.println("<title>" + title + "</title>");
        out.println("</head>");
        out.println("<body>");

        out.println("<a href=\"../cookies.html\">");
        out.println("<img src=\"../images/code.gif\" height=24 ");
        out.println("width=24 align=right border=0 alt=\"view code\"></a>");
        out.println("<a href=\"../index.html\">");
        out.println("<img src=\"../images/return.gif\" height=24 ");
        out.println("width=24 align=right border=0 alt=\"return\"></a>");

        out.println("<h3>" + title + "</h3>");

        std::vector<Cookie> cookies = request.getCookies();
        if (cookies.size()) {
            out.println("Your browser is sending the following cookies:");
            out.println("<br>");
            std::vector<Cookie>::iterator i = cookies.begin();
            for (; i != cookies.end(); i++) {
                out.println("Cookie Name: " + i->getName() + "<br>");
                out.println("  Cookie Value: " + i->getValue() + "<br><br>");
            }
        } else {
            out.println("cookies.no-cookies");
        }

        std::string cookieName = request.getParameter("cookiename");
        std::string cookieValue = request.getParameter("cookievalue");
        if (cookieName.length() && cookieValue.length()) {
            Cookie cookie(cookieName, cookieValue);
            response.addCookie(cookie);
            out.println("<P>");
            out.println("You just send the following cookie to your browser:");
            out.println("<br>");
            out.println("Name:  " + cookieName + "<br>");
            out.println("Value: " + cookieValue);
        }
        
        out.println("<P>");
        out.println("Create a cookie to send to your browser<br>");
        out.println("<form action=\"");
        out.println("CookieExample\" method=POST>");
        out.println("Name:");
        out.println("<input type=text length=20 name=cookiename><br>");
        out.println("Value:");
        out.println("<input type=text length=20 name=cookievalue><br>");
        out.println("<input type=submit></form>");
            
            
        out.println("</body>");
        out.println("</html>");
    }

    void doPost(HttpServletRequest &request, HttpServletResponse &response)
        throw(ServletException)
    {
        doGet(request, response);
    }

};

SL_REGIST_LOADABLE_CLASS(CookieExample)
