/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: DispatcherExample.cpp,v 1.2 2008/03/11 15:54:31 cvsuser Exp $
 */

#include <java/class_loader.h>
#include <java/java.h>
#include <servlet/servlet_headers.h>
using namespace java::lang;
using namespace java::io;
using namespace servlet;
using namespace servlet::http;

#include <string>
#include <boost/lexical_cast.hpp>
using namespace std;
using namespace boost;

#include <core/ServletContextImpl.h>
#include <interface/Connector.h>
#include <interface/Context.h>
#include <interface/Engine.h>
#include <interface/Host.h>
#include <interface/Server.h>
#include <interface/Service.h>
using namespace si::interface;
using namespace si::core;


//
// ˼Ƹμ˰¸ƤǤ.
//
class ManagerServlet : public HttpServlet {
public :

    void doGet(HttpServletRequest &request, HttpServletResponse &response)
        throw(ServletException)
    {
        response.setContentType("text/html;charset=ISO-8859-1");

		ServletContext& context = getServletContext();


		try {
			ServletContextImpl& c =dynamic_cast<ServletContextImpl&>(context);
			_ctx = c.getContainerContext();
		} catch (std::bad_cast& e) {
			throw ServletException("container is unknown coreation.");
		}

		_host    = dynamic_cast<Host*>(_ctx->getParent());
		_engine  = dynamic_cast<Engine*>(_host->getParent());
		_service = dynamic_cast<Service*>(_engine->getParent());
		_server  = dynamic_cast<Server*>(_service->getParent());

		string pattern = request.getParameter("pattern");

		if (pattern == "1") {
			getContextInfo(request, response);

		} else if (pattern == "2") {
			getHostInfo(request, response);

		} else if (pattern == "3") {
			getConnectorInfo(request, response);

		} else {
			response.setContentType("text/html;charset=ISO-8859-1");
			PrintWriter out = response.getWriter();
			out.println("<form method=\"GET\" ");
			out.println("action=\"/manager/servlet/ManagerServlet\" >");
			out.println("<select name=\"pattern\">");
			out.println("<option value=\"0\">");
			out.println("<option value=\"1\">Context");
			out.println("<option value=\"2\">Host");
			out.println("<option value=\"3\">Connector");
			out.println("</select>");
			out.println("<input type=\"submit\" value=\"submit\" />");
			out.println("</form>");
		}
    }

private :

	void getContextInfo(HttpServletRequest &req, HttpServletResponse &res)
	{
		req.setAttribute("path", Object(new String(_ctx->path())));
		req.setAttribute("docBase", Object(new String(_ctx->docBase())));
		RequestDispatcher& r =
						getServletContext().getRequestDispatcher("context.jsp");
		r.forward(req, res);
	}

	void getHostInfo(HttpServletRequest &req, HttpServletResponse &res)
	{
		set<shared_ptr<Context> > ctx_list = _host->getContextSet();
		req.setAttribute("size", Object(new Integer(ctx_list.size())));

		set<shared_ptr<Context> >::iterator i = ctx_list.begin();
		for (int n = 0; i != ctx_list.end(); i++, n++) {
			string path_index("path_index");
			path_index += boost::lexical_cast<string>(n);

			string path = (*i)->path();
			req.setAttribute(path_index, Object(new String(path)));

			string doc_index("doc_index");
			doc_index += boost::lexical_cast<string>(n);

			string doc = (*i)->docBase();
			req.setAttribute(doc_index, Object(new String(doc)));
		}
		RequestDispatcher& r =
					getServletContext().getRequestDispatcher("host.jsp");
		r.forward(req, res);
	}

	void getConnectorInfo(HttpServletRequest &req, HttpServletResponse &res)
	{
		res.setContentType("text/html;charset=ISO-8859-1");
		PrintWriter out = res.getWriter();

		vector<shared_ptr<Connector> > con_list = _service->getConnectorList();
		vector<shared_ptr<Connector> >::iterator i = con_list.begin();
		for (; i != con_list.end(); i++)
			out.println((*i)->name() + "<br />");
	}

	Context*	_ctx;
	Host*		_host;
	Engine*		_engine;
	Service*	_service;
	Server*		_server;
};

SL_REGIST_LOADABLE_CLASS(ManagerServlet)
