/*
 * $Id: ServletRequestAttributeListenerTest.cpp,v 1.5 2007/09/03 13:43:13 cvsuser Exp $
 */

#include <iostream>

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/ServletRequestAttributeListener.h>
#include <servlet/ServletRequestAttributeEvent.h>
using namespace servlet;

namespace listeners {

class ServletRequestAttributeListenerTest : public ServletRequestAttributeListener {
public :

	void attributeAdded(ServletRequestAttributeEvent& e)
	{
		std::cerr << "RequestAttributeListener::" << __FUNCTION__ << std::endl;
		printEvent(e);
	}
	void attributeRemoved(ServletRequestAttributeEvent& e)
	{
		std::cerr << "RequestAttributeListener::" << __FUNCTION__ << std::endl;
		printEvent(e);
	}
	void attributeReplaced(ServletRequestAttributeEvent& e)
	{
		std::cerr << "RequestAttributeListener::" << __FUNCTION__ << std::endl;
		printEvent(e);
	}

private :

	void printEvent(ServletRequestAttributeEvent& e)
	{
		e.getServletContext();
		e.getServletRequest();

		std::string n = e.getName();
		std::string v;

		try {
			v = sl::object_cast<std::string>(e.getValue());
		} catch (...) { }

		std::cerr << "getName : " << n << std::endl;
		std::cerr << "getValue: " << v << std::endl;
	}

};

}

SL_REGIST_LOADABLE_CLASS(listeners::ServletRequestAttributeListenerTest)
