/*
 * $Id: ServletContextListenerTest.cpp,v 1.4 2007/08/30 17:01:37 cvsuser Exp $
 */

#include <iostream>

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/ServletContextListener.h>
#include <servlet/ServletContextEvent.h>
using namespace servlet;

namespace listeners {

class ServletContextListenerTest : public servlet::ServletContextListener {
public :

	ServletContextListenerTest()
	{
		std::cerr << "ServletContextListenerTest" << std::endl;
	}

	virtual void contextInitialized(ServletContextEvent& e)
	{
		ServletContext& c = e.getServletContext();
		std::cerr << __FUNCTION__ << " :" << c.getServerInfo() << std::endl;
	}

	virtual void contextDestroyed(ServletContextEvent& e)
	{
		ServletContext& c = e.getServletContext();
		std::cerr << __FUNCTION__ << " :" << c.getServerInfo() << std::endl;
	}
};

}

SL_REGIST_LOADABLE_CLASS(listeners::ServletContextListenerTest)
