/*
 * $Id: ServletContextAttributeListenerTest.cpp,v 1.5 2007/09/03 13:43:13 cvsuser Exp $
 */

#include <iostream>

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/ServletContextAttributeListener.h>
#include <servlet/ServletContextAttributeEvent.h>
using namespace servlet;

namespace listeners {

class ServletContextAttributeListenerTest : public ServletContextAttributeListener {
public :

	void attributeAdded(ServletContextAttributeEvent& e)
	{
		std::cerr << "ContextAttributeListener::" << __FUNCTION__ << std::endl;
		printEvent(e);
	}

	void attributeRemoved(ServletContextAttributeEvent& e)
	{
		std::cerr << "ContextAttributeListener::" << __FUNCTION__ << std::endl;
		printEvent(e);
	}

	void attributeReplaced(ServletContextAttributeEvent& e)
	{
		std::cerr << "ContextAttributeListener::" << __FUNCTION__ << std::endl;
		printEvent(e);
	}

private :

	void printEvent(ServletContextAttributeEvent& e)
	{
		std::string n = e.getName();
		std::string v;

		try {
			v = sl::object_cast<std::string>(e.getValue());
		} catch (...) { }

		std::cerr << "getName : " << n << std::endl;
		std::cerr << "getValue: " << v << std::endl;
	}
};

}

SL_REGIST_LOADABLE_CLASS(listeners::ServletContextAttributeListenerTest)
