/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
 * Originally written by Jason Hunter, http://www.servlets.com.
 */

#ifndef __NUMBER_GUESS_BEAN_H__
#define __NUMBER_GUESS_BEAN_H__

#include <cmath>
#include <string>
#include <boost/lexical_cast.hpp>

namespace num {

class NumberGuessBean {

  int answer;
  bool success;
  std::string hint;
  int numGuesses;

public :
  NumberGuessBean() {
    reset();
  }

  void setGuess(std::string guess) {
    numGuesses++;

    int g;
    try {
      g = boost::lexical_cast<int>(guess);
    }
    catch (boost::bad_lexical_cast& e) {
      g = -1;
    }

    if (g == answer) {
      success = true;
    }
    else if (g == -1) {
      hint = "a number next time";
    }
    else if (g < answer) {
      hint = "higher";
    }
    else if (g > answer) {
      hint = "lower";
    }
  }

  bool getSuccess() {
    return success;
  }

  std::string getHint() {
    return "" + hint;
  }

  int getNumGuesses() {
    return numGuesses;
  }

  void reset() {
    answer = std::abs(random() % 100) + 1;
    success = false;
    numGuesses = 0;
  }
};

} // namespace

#endif // __NUMBER_GUESS_BEAN_H__
