/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <string>

#include <servlet/jsp/JspException.h>
#include <servlet/jsp/tagext/SimpleTagSupport.h>
using namespace servlet::jsp;
using namespace servlet::jsp::tagext;

namespace jsp2 { namespace examples { namespace simpletag {

/**
 * Displays a tile as a single cell in a table.
 */
class TileSimpleTag : public SimpleTagSupport {
private :
    std::string color;
    std::string label;

public :
    void doTag() throw( JspException )
	{
	getJspContext().getOut().write( 
	    "<td width=\"32\" height=\"32\" bgcolor=\"" + this->color + 
	    "\"><font color=\"#ffffff\"><center>" + this->label + 
                "</center></font></td>" );
    }

    void setColor( std::string color ) {
        this->color = color;
    }
    
    void setLabel( std::string label ) {
        this->label = label;
    }
};

} } } // namespace
