/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <cstdlib>	// random()

#include <servlet/jsp/JspException.h>
#include <servlet/jsp/tagext/JspFragment.h>
#include <servlet/jsp/tagext/SimpleTagSupport.h>
using namespace servlet::jsp;
using namespace servlet::jsp::tagext;


namespace jsp2 { namespace examples { namespace simpletag {

/**
 * SimpleTag handler that accepts takes three attributes of type
 * JspFragment and invokes then in a random order.
 */
class ShuffleSimpleTag : public SimpleTagSupport
{
private :
    JspFragment* fragment1;
    JspFragment* fragment2;
    JspFragment* fragment3;

public :
    void doTag() throw( JspException )
	{
        switch( (int)(::random() * 6) ) {
            case 0:
                fragment1->invoke();
                fragment2->invoke();
                fragment3->invoke();
                break;
            case 1:
                fragment1->invoke();
                fragment3->invoke();
                fragment2->invoke();
                break;
            case 2:
                fragment2->invoke();
                fragment1->invoke();
                fragment3->invoke();
                break;
            case 3:
                fragment2->invoke();
                fragment3->invoke();
                fragment1->invoke();
                break;
            case 4:
                fragment3->invoke();
                fragment1->invoke();
                fragment2->invoke();
                break;
            case 5:
                fragment3->invoke();
                fragment2->invoke();
                fragment1->invoke();
                break;
        }
    }

    void setFragment1( JspFragment& fragment1 )
	{
        this->fragment1 = &fragment1;
    }
    
    void setFragment2( JspFragment& fragment2 )
	{
        this->fragment2 = &fragment2;
    }
    
    void setFragment3( JspFragment& fragment3 )
	{
        this->fragment3 = &fragment3;
    }
};

} } } // namespace
