/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <servlet/jsp/JspException.h>
#include <servlet/jsp/tagext/SimpleTagSupport.h>
using namespace sl::java::lang;
using namespace servlet::jsp;
using namespace servlet::jsp::tagext;

namespace jsp2 { namespace examples { namespace simpletag { 

/**
 * SimpleTag handler that accepts a num attribute and 
 * invokes its body 'num' times.
 */
class RepeatSimpleTag : public SimpleTagSupport {
private :
	int num;

public :
	void doTag() throw(JspException)
	{
		for (int i=0; i<num; i++) {
			getJspContext().setAttribute("count", i + 1);
			getJspBody().invoke();
		}
	}

	void setNum(int num) {
		this->num = num;
	}
};

} } } // end of namesapce
