/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <string>
#include <servlet/jsp/tagext/SimpleTagSupport.h>
using namespace servlet::jsp;
using namespace servlet::jsp::tagext;

#include "../BookBean.h"

namespace jsp2 { namespace examples { namespace simpletag {

/**
 * SimpleTag handler that pretends to search for a book, and stores
 * the result in a scoped variable.
 */
class FindBookSimpleTag : public SimpleTagSupport {
private :
    std::string var;
    
    std::string BOOK_TITLE;
    std::string BOOK_AUTHOR;
    std::string BOOK_ISBN;
#if 0
    static const std::string BOOK_TITLE  = "The Lord of the Rings";
    static const std::string BOOK_AUTHOR = "J. R. R. Tolkein";
    static const std::string BOOK_ISBN   = "0618002251";
#endif

public :
	FindBookSimpleTag()
	{
    	BOOK_TITLE  = "The Lord of the Rings";
    	BOOK_AUTHOR = "J. R. R. Tolkein";
    	BOOK_ISBN   = "0618002251";
	}

    void doTag() throw(JspException)
	{
        BookBean* book = new BookBean( BOOK_TITLE, BOOK_AUTHOR, BOOK_ISBN );
        getJspContext().setAttribute( this->var, sl::java::lang::Object(book) );
    }

    void setVar( std::string var )
	{
        this->var = var;
    }
};

} } } // namespace
