/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/


#include <sl/object.hpp>
#include <sl/java/lang/Object.h>
#include <servlet/jsp/JspException.h>
#include <servlet/jsp/JspWriter.h>
#include <servlet/jsp/tagext/SimpleTagSupport.h>
#include <servlet/jsp/tagext/DynamicAttributes.h>
using namespace sl::java::lang;
using namespace servlet::jsp;
using namespace servlet::jsp::tagext;

namespace jsp2 {
namespace examples {
namespace simpletag {

/**
 * SimpleTag handler that echoes all its attributes 
 */
class EchoAttributesTag : public SimpleTagSupport, public DynamicAttributes
{
private :
	std::vector<std::string> keys;
	std::vector<sl::java::lang::Object> values;

public :
	void doTag() throw(JspException)
	{
		JspWriter& out = getJspContext().getOut();

		for( size_t i = 0; i < keys.size(); i++ ) {
			std::string key = keys[i];
			Object value    = values[i];
			out.println( "<li>" + key + " = " +
						 sl::object_cast<std::string>(value) + "</li>" );
		}
	}

	void setDynamicAttribute(const std::string& uri,
							 const std::string& localName, Object value) 
		throw(JspException)
	{
		keys.push_back( localName );
		values.push_back( value );
	}
};

} } } // namespace jsp2::examples::simpletag
