/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <cctype>
#include <functional>
#include <string>

namespace jsp2 { namespace examples { namespace el {

/**
 * Defines the functions for the jsp2 example tag library.
 * 
 * <p>Each function is defined as a static method.</p>
 */
class Functions {
public :
    static std::string reverse( std::string text ) {
        return std::string(text.rbegin(), text.rend());
    }

    static int numVowels( std::string text ) {
        std::string vowels = "aeiouAEIOU";
	int result = 0;
        for( size_t i = 0; i < text.length(); i++ ) {
	    if( vowels.find( text[ i ] ) != std::string::npos ) {
	        result++;
	    }
	}
	return result;
    }

    static std::string caps( std::string text ) {
	std::string result;
	std::transform(text.begin(), text.end(),
			std::back_inserter(result), std::ptr_fun(::toupper));
        return result;
    }
};

} } } // namespace
