/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <string>
#include <sl/object.hpp>

namespace jsp2 { namespace examples {

class BookBean : public sl::objectable {
private :
    std::string title;
    std::string author;
    std::string isbn;
    
public :
    BookBean( std::string title, std::string author, std::string isbn )
	{
        this->title = title;
        this->author = author;
        this->isbn = isbn;
    }

    std::string getTitle() {
        return this->title;
    }
    
    std::string getAuthor() {
        return this->author;
    }
    
    std::string getIsbn() {
        return this->isbn;
    }
    
};

} } // namespace
