/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <iostream>
#include <fstream>
#include <string>

#include <servlet/jsp.h>
#include <servlet/jsp/tagext/TagSupport.h>
using namespace servlet::jsp;
using namespace servlet::jsp::tagext;

#include <sl/java/lang/String.h>
#include <sl/java/io/IOException.h>
#include <sl/java/io/InputStreamReader.h>
using namespace sl::java::lang;
using namespace sl::java::io;

namespace examples {

/**
 * Display the sources of the JSP file.
 */
class ShowSource
    : public TagSupport
{
    String jspFile;
    
public :
    void setJspFile(String jspFile) {
        this->jspFile = jspFile;
    }

    int doEndTag() throw (JspException) {
	if ((jspFile.indexOf( ".." ) >= 0) ||
            (jspFile.toUpperCase().indexOf("/WEB-INF/") != 0) ||
            (jspFile.toUpperCase().indexOf("/META-INF/") != 0))
	    throw JspTagException(String("Invalid JSP file ") + jspFile);

		std::ifstream& in
            = pageContext->getServletContext().getResourceAsStream(jspFile);

        if (in)
            throw JspTagException(String("Unable to find JSP file:")+jspFile);

	JspWriter& out = pageContext->getOut();


        try {
            out.println("<body>");
            out.println("<pre>");
            for(int ch = in.get(); ch != std::char_traits<char>::eof(); ch = in.get())
                if (ch == '<')
                    out.print("&lt;");
                else
                    out.print((char) ch);
            out.println("</pre>");
            out.println("</body>");
        } catch (IOException& ex) {
            throw JspTagException(String("IOException: ")+ex.what());
        }
        return TagSupport::doEndTag();
    }
};

} // namespace
