/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#ifndef __LOG_TAG_H__
#define __LOG_TAG_H__

#include <servlet/jsp_headers.h>
using namespace servlet::jsp;
using namespace servlet::jsp::tagext;

#include "ExampleTagBase.h"

namespace examples {

/**
 * Log the contents of the body. Could be used to handle errors etc. 
 */
class LogTag : public ExampleTagBase {
    bool toBrowser;
    
public :
	LogTag() : toBrowser(false) { }

	void setToBrowser(const std::string& value);

    int doStartTag() throw (JspException);
    
    int doAfterBody() throw (JspException);
};

} // namespace examples

#endif // __LOG_TAG_H__
